/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImportTimerProgress;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterBootstrap
implements ApplicationListener {
    public static final String VIEW_PATH_PROPERTY = "path";
    public static final String VIEW_CHILDASSOCTYPE_PROPERTY = "childAssocType";
    public static final String VIEW_MESSAGES_PROPERTY = "messages";
    public static final String VIEW_LOCATION_VIEW = "location";
    public static final String VIEW_ENCODING = "encoding";
    private static final Log logger = LogFactory.getLog(ImporterBootstrap.class);
    private boolean logEnabled = false;
    private boolean allowWrite = true;
    private boolean useExistingStore = false;
    private TransactionService transactionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private ImporterService importerService;
    private List<Properties> bootstrapViews;
    private StoreRef storeRef = null;
    private List<String> mustNotExistStoreUrls = null;
    private Properties configuration = null;
    private String strLocale = null;
    private Locale locale = null;
    private AuthenticationComponent authenticationComponent;
    private boolean bootstrapPerformed = false;

    public void setAllowWrite(boolean write) {
        this.allowWrite = write;
    }

    public void setUseExistingStore(boolean useExistingStore) {
        this.useExistingStore = useExistingStore;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setBootstrapViews(List<Properties> bootstrapViews) {
        this.bootstrapViews = bootstrapViews;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setMustNotExistStoreUrls(List<String> storeUrls) {
        this.mustNotExistStoreUrls = storeUrls;
    }

    public StoreRef getStoreRef() {
        return this.storeRef;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setLocale(String locale) {
        StringTokenizer t = new StringTokenizer(locale, "_");
        int tokens = t.countTokens();
        if (tokens == 1) {
            this.locale = new Locale(locale);
        } else if (tokens == 2) {
            this.locale = new Locale(t.nextToken(), t.nextToken());
        } else if (tokens == 3) {
            this.locale = new Locale(t.nextToken(), t.nextToken(), t.nextToken());
        }
        this.strLocale = locale;
    }

    public String getLocale() {
        return this.strLocale;
    }

    public void setLog(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public boolean hasPerformedBootstrap() {
        return this.bootstrapPerformed;
    }

    public void bootstrap() {
        if (this.transactionService == null) {
            throw new ImporterException("Transaction Service must be provided");
        }
        if (this.namespaceService == null) {
            throw new ImporterException("Namespace Service must be provided");
        }
        if (this.nodeService == null) {
            throw new ImporterException("Node Service must be provided");
        }
        if (this.importerService == null) {
            throw new ImporterException("Importer Service must be provided");
        }
        if (this.storeRef == null) {
            throw new ImporterException("Store URL must be provided");
        }
        if (this.logEnabled && logger instanceof Log4JLogger) {
            Logger log4JLogger = ((Log4JLogger)logger).getLogger();
            log4JLogger.setLevel(Level.DEBUG);
        }
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        try {
            userTransaction.begin();
            if (!this.performBootstrap()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Store exists - bootstrap ignored: " + this.storeRef));
                }
            } else if (!this.allowWrite) {
                logger.warn((Object)("Store does not exist, but mode is read-only: " + this.storeRef));
            } else {
                if (!this.nodeService.exists(this.storeRef)) {
                    this.storeRef = this.nodeService.createStore(this.storeRef.getProtocol(), this.storeRef.getIdentifier());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Created store: " + this.storeRef));
                    }
                }
                if (this.bootstrapViews != null) {
                    for (Properties bootstrapView : this.bootstrapViews) {
                        String childAssocType;
                        String view = bootstrapView.getProperty(VIEW_LOCATION_VIEW);
                        if (view == null || view.length() == 0) {
                            throw new ImporterException("View file location must be provided");
                        }
                        String encoding = bootstrapView.getProperty(VIEW_ENCODING);
                        Reader viewReader = null;
                        ACPImportPackageHandler acpHandler = null;
                        if (view.endsWith(".acp")) {
                            File viewFile = this.getFile(view);
                            acpHandler = new ACPImportPackageHandler(viewFile, encoding);
                        } else {
                            viewReader = this.getReader(view, encoding);
                        }
                        Location importLocation = new Location(this.storeRef);
                        String path = bootstrapView.getProperty(VIEW_PATH_PROPERTY);
                        if (path != null && path.length() > 0) {
                            importLocation.setPath(path);
                        }
                        if ((childAssocType = bootstrapView.getProperty(VIEW_CHILDASSOCTYPE_PROPERTY)) != null && childAssocType.length() > 0) {
                            importLocation.setChildAssocType(QName.createQName(childAssocType, this.namespaceService));
                        }
                        BootstrapBinding binding = new BootstrapBinding();
                        binding.setConfiguration(this.configuration);
                        binding.setLocation(importLocation);
                        String messages = bootstrapView.getProperty(VIEW_MESSAGES_PROPERTY);
                        if (messages != null && messages.length() > 0) {
                            Locale bindingLocale = this.locale == null ? I18NUtil.getLocale() : this.locale;
                            ResourceBundle bundle = ResourceBundle.getBundle(messages, bindingLocale);
                            binding.setResourceBundle(bundle);
                        }
                        ImportTimerProgress importProgress = null;
                        if (logger.isDebugEnabled()) {
                            importProgress = new ImportTimerProgress(logger);
                            logger.debug((Object)("Importing " + view));
                        }
                        if (viewReader != null) {
                            this.importerService.importView(viewReader, importLocation, (ImporterBinding)binding, (ImporterProgress)importProgress);
                            continue;
                        }
                        this.importerService.importView(acpHandler, importLocation, (ImporterBinding)binding, (ImporterProgress)importProgress);
                    }
                }
                this.bootstrapPerformed = !this.useExistingStore;
            }
            userTransaction.commit();
        }
        catch (Throwable e) {
            try {
                if (userTransaction != null) {
                    userTransaction.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.authenticationComponent.clearCurrentSecurityContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AlfrescoRuntimeException("Bootstrap failed", e);
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
    }

    private Reader getReader(String view, String encoding) {
        InputStream viewStream = this.getClass().getClassLoader().getResourceAsStream(view);
        if (viewStream == null) {
            throw new ImporterException("Could not find view file " + view);
        }
        try {
            InputStreamReader inputReader = encoding == null ? new InputStreamReader(viewStream) : new InputStreamReader(viewStream, encoding);
            BufferedReader reader = new BufferedReader(inputReader);
            return reader;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImporterException("Could not create reader for view " + view + " as encoding " + encoding + " is not supported");
        }
    }

    private File getFile(String view) {
        InputStream viewStream = this.getClass().getClassLoader().getResourceAsStream(view);
        if (viewStream == null) {
            throw new ImporterException("Could not find view file " + view);
        }
        File tempFile = TempFileProvider.createTempFile((String)"acpImport", (String)".tmp");
        try {
            FileOutputStream os = new FileOutputStream(tempFile);
            FileCopyUtils.copy((InputStream)viewStream, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new ImporterException("Could not import view " + view, e);
        }
        catch (IOException e) {
            throw new ImporterException("Could not import view " + view, e);
        }
        return tempFile;
    }

    private boolean performBootstrap() {
        if (this.useExistingStore) {
            return true;
        }
        if (this.nodeService.exists(this.storeRef)) {
            return false;
        }
        if (this.mustNotExistStoreUrls != null) {
            for (String storeUrl : this.mustNotExistStoreUrls) {
                StoreRef storeRef = new StoreRef(storeUrl);
                if (!this.nodeService.exists(storeRef)) continue;
                return false;
            }
        }
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.bootstrap();
        }
    }

    private static class BootstrapBinding
    implements ImporterBinding {
        private Properties configuration = null;
        private ResourceBundle resourceBundle = null;
        private Location bootstrapLocation = null;
        private static final String IMPORT_LOCATION_UUID = "bootstrap.location.uuid";
        private static final String IMPORT_LOCATION_NODEREF = "bootstrap.location.noderef";
        private static final String IMPORT_LOCATION_PATH = "bootstrap.location.path";

        private BootstrapBinding() {
        }

        public void setConfiguration(Properties configuration) {
            this.configuration = configuration;
        }

        public Properties getConfiguration() {
            return this.configuration;
        }

        public void setResourceBundle(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public void setLocation(Location location) {
            this.bootstrapLocation = location;
        }

        public String getValue(String key) {
            String value = null;
            if (this.configuration != null) {
                value = this.configuration.getProperty(key);
            }
            if (value == null && this.resourceBundle != null) {
                value = this.resourceBundle.getString(key);
            }
            if (value == null && this.bootstrapLocation != null) {
                if (key.equals(IMPORT_LOCATION_UUID)) {
                    value = this.bootstrapLocation.getNodeRef().getId();
                } else if (key.equals(IMPORT_LOCATION_NODEREF)) {
                    value = this.bootstrapLocation.getNodeRef().toString();
                } else if (key.equals(IMPORT_LOCATION_PATH)) {
                    value = this.bootstrapLocation.getPath();
                }
            }
            return value;
        }

        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID;
        }

        public boolean allowReferenceWithinTransaction() {
            return true;
        }

        public QName[] getExcludedClasses() {
            return new QName[0];
        }
    }
}

