/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import java.io.InputStreamReader;
import org.alfresco.repo.importer.ImportTimerProgress;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.debug.NodeStoreInspector;

public class ImporterComponentTest
extends BaseSpringTest {
    private ImporterService importerService;
    private ImporterBootstrap importerBootstrap;
    private NodeService nodeService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.importerService = (ImporterService)this.applicationContext.getBean(ServiceRegistry.IMPORTER_SERVICE.getLocalName());
        this.importerBootstrap = (ImporterBootstrap)this.applicationContext.getBean("spacesBootstrap");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testImport() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        Location location = new Location(this.storeRef);
        this.importerService.importView(testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testBootstrap() {
        StoreRef bootstrapStoreRef = new StoreRef("workspace", "Test_" + System.currentTimeMillis());
        this.importerBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        this.importerBootstrap.bootstrap();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, bootstrapStoreRef));
    }
}

