/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.system;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.alfresco.repo.admin.patch.PatchDaoService;
import org.alfresco.repo.domain.AppliedPatch;
import org.alfresco.repo.domain.hibernate.VersionCounterDaoComponentImpl;
import org.alfresco.repo.importer.system.PatchInfo;
import org.alfresco.repo.importer.system.SystemInfo;
import org.alfresco.repo.importer.system.VersionCounterInfo;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;

public class SystemExporterImporter {
    private NodeService nodeService;
    private PatchDaoService patchDao;
    private VersionCounterDaoComponentImpl versionCounterDao;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPatchDao(PatchDaoService patchDaoService) {
        this.patchDao = patchDaoService;
    }

    public void setVersionDao(VersionCounterDaoComponentImpl versionCounterDao) {
        this.versionCounterDao = versionCounterDao;
    }

    public void exportSystem(OutputStream exportStream) {
        SystemInfo systemInfo = new SystemInfo();
        List<AppliedPatch> patches = this.patchDao.getAppliedPatches();
        for (AppliedPatch patch : patches) {
            PatchInfo patchInfo = new PatchInfo();
            patchInfo.appliedOnDate = patch.getAppliedOnDate();
            patchInfo.appliedToSchema = patch.getAppliedToSchema();
            patchInfo.appliedToServer = patch.getAppliedToServer();
            patchInfo.description = patch.getDescription();
            patchInfo.fixesFromSchema = patch.getFixesFromSchema();
            patchInfo.fixesToSchema = patch.getFixesToSchema();
            patchInfo.id = patch.getId();
            patchInfo.report = patch.getReport();
            patchInfo.succeeded = patch.getSucceeded();
            patchInfo.targetSchema = patch.getTargetSchema();
            patchInfo.wasExecuted = patch.getWasExecuted();
            systemInfo.patches.add(patchInfo);
        }
        List<StoreRef> storeRefs = this.nodeService.getStores();
        for (StoreRef storeRef : storeRefs) {
            VersionCounterInfo versionCounterInfo = new VersionCounterInfo();
            int versionCount = this.versionCounterDao.currentVersionNumber(storeRef);
            versionCounterInfo.storeRef = storeRef.toString();
            versionCounterInfo.count = versionCount;
            systemInfo.versionCounters.add(versionCounterInfo);
        }
        systemInfo.toXML(exportStream);
    }

    public void importSystem(InputStream importStream) {
        SystemInfo systemInfo = SystemInfo.createSystemInfo(importStream);
        for (PatchInfo patchInfo : systemInfo.patches) {
            AppliedPatch patch = this.patchDao.newAppliedPatch(patchInfo.id);
            patch.setAppliedOnDate(patchInfo.appliedOnDate);
            patch.setAppliedToSchema(patchInfo.appliedToSchema);
            patch.setAppliedToServer(patchInfo.appliedToServer);
            patch.setDescription(patchInfo.description);
            patch.setFixesFromSchema(patchInfo.fixesFromSchema);
            patch.setFixesToSchema(patchInfo.fixesToSchema);
            patch.setReport(patchInfo.report);
            patch.setSucceeded(patchInfo.succeeded);
            patch.setTargetSchema(patchInfo.targetSchema);
            patch.setWasExecuted(patchInfo.wasExecuted);
        }
        for (VersionCounterInfo versionCounterInfo : systemInfo.versionCounters) {
            StoreRef storeRef = new StoreRef(versionCounterInfo.storeRef);
            this.versionCounterDao.setVersionNumber(storeRef, versionCounterInfo.count);
        }
    }
}

