/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.system;

import java.io.InputStream;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.importer.system.SystemExporterImporter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoBootstrap
implements ApplicationListener {
    private TransactionService transactionService;
    private NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private SystemExporterImporter systemImporter;
    private List<String> mustNotExistStoreUrls = null;
    private String bootstrapView = null;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setSystemImporter(SystemExporterImporter systemImporter) {
        this.systemImporter = systemImporter;
    }

    public void setMustNotExistStoreUrls(List<String> storeUrls) {
        this.mustNotExistStoreUrls = storeUrls;
    }

    public void setBootstrapView(String bootstrapView) {
        this.bootstrapView = bootstrapView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        try {
            userTransaction.begin();
            if (this.performBootstrap()) {
                InputStream viewStream = this.getClass().getClassLoader().getResourceAsStream(this.bootstrapView);
                if (viewStream == null) {
                    throw new ImporterException("Could not find system info file " + this.bootstrapView);
                }
                try {
                    this.systemImporter.importSystem(viewStream);
                }
                finally {
                    viewStream.close();
                }
            }
            userTransaction.commit();
        }
        catch (Throwable e) {
            try {
                if (userTransaction != null) {
                    userTransaction.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.authenticationComponent.clearCurrentSecurityContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AlfrescoRuntimeException("System Info Bootstrap failed", e);
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
    }

    private boolean performBootstrap() {
        if (this.bootstrapView == null || this.bootstrapView.length() == 0) {
            return false;
        }
        if (this.mustNotExistStoreUrls != null) {
            for (String storeUrl : this.mustNotExistStoreUrls) {
                StoreRef storeRef = new StoreRef(storeUrl);
                if (!this.nodeService.exists(storeRef)) continue;
                return false;
            }
        }
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.bootstrap();
        }
    }
}

