/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.view;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.alfresco.repo.importer.Importer;
import org.alfresco.repo.importer.Parser;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.MetaDataContext;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.repo.importer.view.NodeItemContext;
import org.alfresco.repo.importer.view.ParentContext;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewParser
implements Parser {
    private static final Log logger = LogFactory.getLog(ViewParser.class);
    private static final String VIEW_CHILD_NAME_ATTR = "childName";
    private static final String VIEW_DATATYPE_ATTR = "datatype";
    private static final String VIEW_ISNULL_ATTR = "isNull";
    private static final String VIEW_INHERIT_PERMISSIONS_ATTR = "inherit";
    private static final String VIEW_ACCESS_STATUS_ATTR = "access";
    private static final String VIEW_ID_ATTR = "id";
    private static final String VIEW_IDREF_ATTR = "idref";
    private static final String VIEW_PATHREF_ATTR = "pathref";
    private static final String VIEW_NODEREF_ATTR = "noderef";
    private static final QName VIEW_METADATA = QName.createQName("http://www.alfresco.org/view/repository/1.0", "metadata");
    private static final QName VIEW_VALUE_QNAME = QName.createQName("http://www.alfresco.org/view/repository/1.0", "value");
    private static final QName VIEW_VALUES_QNAME = QName.createQName("http://www.alfresco.org/view/repository/1.0", "values");
    private static final QName VIEW_ASPECTS = QName.createQName("http://www.alfresco.org/view/repository/1.0", "aspects");
    private static final QName VIEW_PROPERTIES = QName.createQName("http://www.alfresco.org/view/repository/1.0", "properties");
    private static final QName VIEW_ASSOCIATIONS = QName.createQName("http://www.alfresco.org/view/repository/1.0", "associations");
    private static final QName VIEW_ACL = QName.createQName("http://www.alfresco.org/view/repository/1.0", "acl");
    private static final QName VIEW_ACE = QName.createQName("http://www.alfresco.org/view/repository/1.0", "ace");
    private static final QName VIEW_AUTHORITY = QName.createQName("http://www.alfresco.org/view/repository/1.0", "authority");
    private static final QName VIEW_PERMISSION = QName.createQName("http://www.alfresco.org/view/repository/1.0", "permission");
    private static final QName VIEW_REFERENCE = QName.createQName("http://www.alfresco.org/view/repository/1.0", "reference");
    private XmlPullParserFactory factory;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;

    public ViewParser() {
        try {
            this.factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), this.getClass());
            this.factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            throw new ImporterException("Failed to initialise view importer", e);
        }
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void parse(Reader viewReader, Importer importer) {
        try {
            XmlPullParser xpp = this.factory.newPullParser();
            xpp.setInput(viewReader);
            ParserContext parserContext = new ParserContext();
            parserContext.importer = importer;
            parserContext.dictionaryService = this.dictionaryService;
            parserContext.elementStack = new Stack();
            try {
                int eventType = xpp.getEventType();
                while (eventType != 1) {
                    switch (eventType) {
                        case 2: {
                            if (xpp.getDepth() == 1) {
                                this.processRoot(xpp, parserContext);
                                break;
                            }
                            this.processStartElement(xpp, parserContext);
                            break;
                        }
                        case 3: {
                            this.processEndElement(xpp, parserContext);
                        }
                    }
                    eventType = xpp.next();
                }
            }
            catch (Exception e) {
                throw new ImporterException("Failed to import package at line " + xpp.getLineNumber() + "; column " + xpp.getColumnNumber() + " due to error: " + e.getMessage(), e);
            }
        }
        catch (XmlPullParserException e) {
            throw new ImporterException("Failed to parse view", e);
        }
    }

    private void processStartElement(XmlPullParser xpp, ParserContext parserContext) throws XmlPullParserException, IOException {
        QName defName = this.getName(xpp);
        ElementContext element = parserContext.elementStack.peek();
        if (defName.equals(VIEW_METADATA)) {
            MetaDataContext metaDataContext = new MetaDataContext(defName, element);
            parserContext.elementStack.push(metaDataContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.indentLog("Pushed " + metaDataContext, parserContext.elementStack.size() - 1));
            }
        } else if (defName.equals(VIEW_ASPECTS) || defName.equals(VIEW_PROPERTIES) || defName.equals(VIEW_ASSOCIATIONS) || defName.equals(VIEW_ACL)) {
            if (element instanceof NodeItemContext) {
                throw new ImporterException("Cannot nest element " + defName + " within " + ((NodeItemContext)element).getElementName());
            }
            if (!(element instanceof NodeContext)) {
                throw new ImporterException("Element " + defName + " can only be declared within a node");
            }
            NodeContext node = (NodeContext)element;
            NodeItemContext nodeItemContext = new NodeItemContext(defName, node);
            parserContext.elementStack.push(nodeItemContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.indentLog("Pushed " + nodeItemContext, parserContext.elementStack.size() - 1));
            }
            if (defName.equals(VIEW_ACL)) {
                this.processACL(xpp, parserContext);
            }
        } else if (element instanceof MetaDataContext) {
            this.processMetaData(xpp, defName, parserContext);
        } else {
            if (element instanceof ParentContext) {
                if (defName.equals(VIEW_REFERENCE)) {
                    this.processStartReference(xpp, defName, parserContext);
                } else {
                    TypeDefinition typeDef = this.dictionaryService.getType(defName);
                    if (typeDef == null) {
                        throw new ImporterException("Type " + defName + " has not been defined in the Repository dictionary");
                    }
                    this.processStartType(xpp, typeDef, parserContext);
                }
                return;
            }
            if (element instanceof NodeContext) {
                Object def = ((NodeContext)element).determineDefinition(defName);
                if (def == null) {
                    throw new ImporterException("Definition " + defName + " is not valid; cannot find in Repository dictionary");
                }
                if (def instanceof AspectDefinition) {
                    this.processAspect(xpp, (AspectDefinition)def, parserContext);
                    return;
                }
                if (def instanceof PropertyDefinition) {
                    this.processProperty(xpp, ((PropertyDefinition)def).getName(), parserContext);
                    return;
                }
                if (def instanceof AssociationDefinition) {
                    this.processStartAssoc(xpp, (AssociationDefinition)def, parserContext);
                    return;
                }
            } else if (element instanceof NodeItemContext) {
                NodeItemContext nodeItem = (NodeItemContext)element;
                NodeContext node = nodeItem.getNodeContext();
                QName itemName = nodeItem.getElementName();
                if (itemName.equals(VIEW_ASPECTS)) {
                    AspectDefinition def = node.determineAspect(defName);
                    if (def == null) {
                        throw new ImporterException("Aspect name " + defName + " is not valid; cannot find in Repository dictionary");
                    }
                    this.processAspect(xpp, def, parserContext);
                } else if (itemName.equals(VIEW_PROPERTIES)) {
                    this.processProperty(xpp, defName, parserContext);
                } else if (itemName.equals(VIEW_ASSOCIATIONS)) {
                    AssociationDefinition def = node.determineAssociation(defName);
                    if (def == null) {
                        throw new ImporterException("Association name " + defName + " is not valid; cannot find in Repository dictionary");
                    }
                    this.processStartAssoc(xpp, def, parserContext);
                } else if (itemName.equals(VIEW_ACL)) {
                    this.processAccessControlEntry(xpp, parserContext);
                }
            }
        }
    }

    private void processRoot(XmlPullParser xpp, ParserContext parserContext) throws XmlPullParserException, IOException {
        ParentContext parent = new ParentContext(this.getName(xpp), parserContext.dictionaryService, parserContext.importer);
        parserContext.elementStack.push(parent);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Pushed " + parent, parserContext.elementStack.size() - 1));
        }
    }

    private void processMetaData(XmlPullParser xpp, QName metaDataName, ParserContext parserContext) throws XmlPullParserException, IOException {
        MetaDataContext metaData = (MetaDataContext)parserContext.elementStack.peek();
        String value = null;
        int eventType = xpp.next();
        if (eventType == 4) {
            value = xpp.getText();
            eventType = xpp.next();
        }
        if (eventType != 3) {
            throw new ImporterException("Meta data element " + metaDataName + " is missing end tag");
        }
        metaData.setProperty(metaDataName, value);
    }

    private void processStartType(XmlPullParser xpp, TypeDefinition typeDef, ParserContext parserContext) throws XmlPullParserException, IOException {
        String importId;
        ParentContext parent = (ParentContext)parserContext.elementStack.peek();
        NodeContext node = new NodeContext(typeDef.getName(), parent, typeDef);
        String childName = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_CHILD_NAME_ATTR);
        if (childName != null && childName.length() > 0) {
            node.setChildName(childName);
        }
        if ((importId = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_ID_ATTR)) != null && importId.length() > 0) {
            node.setImportId(importId);
        }
        parserContext.elementStack.push(node);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Pushed " + node, parserContext.elementStack.size() - 1));
        }
    }

    private void processStartReference(XmlPullParser xpp, QName refName, ParserContext parserContext) throws XmlPullParserException, IOException {
        String importId;
        NodeRef nodeRef;
        ParentContext parent = (ParentContext)parserContext.elementStack.peek();
        NodeContext node = new NodeContext(refName, parent, null);
        node.setReference(true);
        String idRefAttr = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_IDREF_ATTR);
        String pathRefAttr = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_PATHREF_ATTR);
        String nodeRefAttr = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_NODEREF_ATTR);
        if (idRefAttr != null && idRefAttr.length() > 0 && pathRefAttr != null && pathRefAttr.length() > 0 && nodeRefAttr != null && nodeRefAttr.length() > 0) {
            throw new ImporterException("Only one of idref or pathref or noderef can be specified.");
        }
        if (nodeRefAttr != null) {
            nodeRef = new NodeRef(nodeRefAttr);
            node.setUUID(nodeRef.getId());
        } else if (idRefAttr != null && idRefAttr.length() > 0) {
            nodeRef = this.getImportReference(parserContext, idRefAttr);
            if (nodeRef == null) {
                throw new ImporterException("Cannot find node referenced by id " + idRefAttr);
            }
            node.setUUID(nodeRef.getId());
        } else if (pathRefAttr != null && pathRefAttr.length() > 0) {
            NodeRef referencedRef = parserContext.importer.resolvePath(pathRefAttr);
            if (referencedRef == null) {
                throw new ImporterException("Cannot find node referenced by path " + pathRefAttr);
            }
            node.setUUID(referencedRef.getId());
        }
        String childName = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_CHILD_NAME_ATTR);
        if (childName != null && childName.length() > 0) {
            node.setChildName(childName);
        }
        if ((importId = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_ID_ATTR)) != null && importId.length() > 0) {
            node.setImportId(importId);
        }
        parserContext.elementStack.push(node);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Pushed Reference " + node, parserContext.elementStack.size() - 1));
        }
    }

    private void processAspect(XmlPullParser xpp, AspectDefinition aspectDef, ParserContext parserContext) throws XmlPullParserException, IOException {
        NodeContext node = this.peekNodeContext(parserContext.elementStack);
        node.addAspect(aspectDef);
        int eventType = xpp.next();
        if (eventType != 3) {
            throw new ImporterException("Aspect " + aspectDef.getName() + " definition is not valid - it cannot contain any elements");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Processed aspect " + aspectDef.getName(), parserContext.elementStack.size()));
        }
    }

    private void processACL(XmlPullParser xpp, ParserContext parserContext) {
        Boolean inherit;
        NodeContext node = this.peekNodeContext(parserContext.elementStack);
        String strInherit = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_INHERIT_PERMISSIONS_ATTR);
        if (strInherit != null && !(inherit = Boolean.valueOf(strInherit)).booleanValue()) {
            node.setInheritPermissions(false);
        }
    }

    private void processAccessControlEntry(XmlPullParser xpp, ParserContext parserContext) throws XmlPullParserException, IOException {
        AccessStatus accessStatus;
        NodeContext node = this.peekNodeContext(parserContext.elementStack);
        QName defName = this.getName(xpp);
        if (!defName.equals(VIEW_ACE)) {
            throw new ImporterException("Expected start element " + VIEW_ACE);
        }
        String access = xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_ACCESS_STATUS_ATTR);
        AccessStatus accessStatus2 = accessStatus = access == null ? AccessStatus.ALLOWED : AccessStatus.valueOf(AccessStatus.class, access);
        if (accessStatus == null) {
            throw new ImporterException("Permission access status '" + access + "' is not recognised.");
        }
        String authority = null;
        String permission = null;
        int eventType = xpp.next();
        while (eventType != 3) {
            if (eventType == 2) {
                defName = this.getName(xpp);
                if (defName.equals(VIEW_AUTHORITY)) {
                    eventType = xpp.next();
                    if (eventType != 4) {
                        throw new ImporterException("Element " + VIEW_AUTHORITY + " must have a value");
                    }
                    authority = xpp.getText();
                } else if (defName.equals(VIEW_PERMISSION)) {
                    eventType = xpp.next();
                    if (eventType != 4) {
                        throw new ImporterException("Element " + VIEW_PERMISSION + " must have a value");
                    }
                    permission = xpp.getText();
                } else {
                    throw new ImporterException("Expected start element " + VIEW_AUTHORITY + " or " + VIEW_PERMISSION);
                }
                eventType = xpp.next();
                if (eventType != 3) {
                    throw new ImporterException("Expected end element " + defName);
                }
                QName endDefName = this.getName(xpp);
                if (!defName.equals(endDefName)) {
                    throw new ImporterException("Expected end element " + defName);
                }
            }
            eventType = xpp.next();
        }
        if (authority == null || authority.length() == 0) {
            throw new ImporterException("Authority must be specified");
        }
        if (permission == null || permission.length() == 0) {
            throw new ImporterException("Permisssion must be specified");
        }
        defName = this.getName(xpp);
        if (!defName.equals(VIEW_ACE)) {
            throw new ImporterException("Expected end element " + VIEW_ACE);
        }
        node.addAccessControlEntry(accessStatus, authority, permission);
    }

    private void processProperty(XmlPullParser xpp, QName propertyName, ParserContext parserContext) throws XmlPullParserException, IOException {
        NodeContext node = this.peekNodeContext(parserContext.elementStack);
        String value = "";
        int eventType = xpp.next();
        if (eventType == 4) {
            value = xpp.getText();
            eventType = xpp.next();
        }
        if (eventType == 3) {
            node.addProperty(propertyName, value);
        } else {
            QName name;
            boolean isCollection = false;
            if (eventType == 2 && (name = this.getName(xpp)).equals(VIEW_VALUES_QNAME)) {
                node.addPropertyCollection(propertyName);
                isCollection = true;
                eventType = xpp.next();
                if (eventType == 4) {
                    eventType = xpp.next();
                }
            }
            while (eventType == 2) {
                name = this.getName(xpp);
                if (!name.equals(VIEW_VALUE_QNAME)) {
                    throw new ImporterException("Invalid view structure - expected element " + VIEW_VALUE_QNAME + " for property " + propertyName);
                }
                QName datatype = QName.createQName(xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_DATATYPE_ATTR), this.namespaceService);
                Boolean isNull = Boolean.valueOf(xpp.getAttributeValue("http://www.alfresco.org/view/repository/1.0", VIEW_ISNULL_ATTR));
                String decoratedValue = isNull != false ? null : "";
                eventType = xpp.next();
                if (eventType == 4) {
                    decoratedValue = xpp.getText();
                    eventType = xpp.next();
                }
                if (eventType == 3) {
                    node.addProperty(propertyName, decoratedValue);
                    if (datatype != null) {
                        node.addDatatype(propertyName, this.dictionaryService.getDataType(datatype));
                    }
                } else {
                    throw new ImporterException("Value for property " + propertyName + " has not been defined correctly - missing end tag");
                }
                eventType = xpp.next();
                if (eventType != 4) continue;
                eventType = xpp.next();
            }
            if (eventType != 3) {
                throw new ImporterException("Invalid view structure - property " + propertyName + " definition is invalid");
            }
            if (isCollection) {
                eventType = xpp.next();
                if (eventType == 4) {
                    eventType = xpp.next();
                }
                if (eventType != 3) {
                    throw new ImporterException("Invalid view structure - property " + propertyName + " definition is invalid");
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Processed property " + propertyName, parserContext.elementStack.size()));
        }
    }

    private void processStartAssoc(XmlPullParser xpp, AssociationDefinition assocDef, ParserContext parserContext) throws XmlPullParserException, IOException {
        NodeContext node = this.peekNodeContext(parserContext.elementStack);
        this.importNode(parserContext, node);
        ParentContext parent = new ParentContext(assocDef.getName(), node, assocDef);
        parserContext.elementStack.push(parent);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.indentLog("Pushed " + parent, parserContext.elementStack.size() - 1));
        }
    }

    private void processEndElement(XmlPullParser xpp, ParserContext parserContext) {
        ElementContext element = parserContext.elementStack.peek();
        if (element.getElementName().getLocalName().equals(xpp.getName()) && element.getElementName().getNamespaceURI().equals(xpp.getNamespace())) {
            element = parserContext.elementStack.pop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.indentLog("Popped " + element, parserContext.elementStack.size()));
            }
            if (element instanceof NodeContext) {
                this.processEndType(parserContext, (NodeContext)element);
            } else if (element instanceof ParentContext) {
                this.processEndAssoc(parserContext, (ParentContext)element);
            } else if (element instanceof MetaDataContext) {
                this.processEndMetaData(parserContext, (MetaDataContext)element);
            }
        }
    }

    private void processEndType(ParserContext parserContext, NodeContext node) {
        this.importNode(parserContext, node);
        NodeRef nodeRef = node.getNodeRef();
        node.getImporter().childrenImported(nodeRef);
    }

    private void processEndAssoc(ParserContext parserContext, ParentContext parent) {
    }

    private void processEndMetaData(ParserContext parserContext, MetaDataContext context) {
        context.getImporter().importMetaData(context.getProperties());
    }

    private void importNode(ParserContext parserContext, NodeContext node) {
        if (node.getNodeRef() == null) {
            NodeRef nodeRef = node.getImporter().importNode(node);
            node.setNodeRef(nodeRef);
            String importId = node.getImportId();
            if (importId != null && importId.length() > 0) {
                this.createImportReference(parserContext, importId, nodeRef);
            }
        }
    }

    private void createImportReference(ParserContext parserContext, String importId, NodeRef nodeRef) {
        if (parserContext.importIds.containsKey(importId)) {
            throw new ImporterException("Import id " + importId + " already specified within import file");
        }
        parserContext.importIds.put(importId, nodeRef);
    }

    private NodeRef getImportReference(ParserContext parserContext, String importId) {
        return parserContext.importIds.get(importId);
    }

    private NodeContext peekNodeContext(Stack<ElementContext> contextStack) {
        ElementContext element = contextStack.peek();
        if (element instanceof NodeContext) {
            return (NodeContext)element;
        }
        if (element instanceof NodeItemContext) {
            return ((NodeItemContext)element).getNodeContext();
        }
        throw new ImporterException("Internal error: Failed to retrieve node context");
    }

    private QName getName(XmlPullParser xpp) {
        String uri = xpp.getNamespace();
        if (!this.namespaceService.getURIs().contains(uri)) {
            throw new ImporterException("Namespace URI " + uri + " has not been defined in the Repository dictionary");
        }
        String name = xpp.getName();
        return QName.createQName(uri, name);
    }

    private String indentLog(String msg, int depth) {
        StringBuffer buf = new StringBuffer(1024);
        for (int i = 0; i < depth; ++i) {
            buf.append(' ');
        }
        buf.append(msg);
        return buf.toString();
    }

    private class ParserContext {
        Importer importer;
        DictionaryService dictionaryService;
        Stack<ElementContext> elementStack;
        Map<String, NodeRef> importIds = new HashMap<String, NodeRef>();

        private ParserContext() {
        }
    }
}

