/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Node
implements Serializable {
    private static Log logger = LogFactory.getLog(Node.class);
    private static final String NAMESPACE_BEGIN = "{";
    private static final String CONTENT_DEFAULT_URL = "/download/direct/{0}/{1}/{2}/{3}";
    private static final String CONTENT_PROP_URL = "/download/direct/{0}/{1}/{2}/{3}?property={4}";
    private static final String FOLDER_BROWSE_URL = "/navigate/browse/{0}/{1}/{2}";
    private Node[] children = null;
    private ScriptableQNameMap<String, Node[]> assocs = null;
    private NodeRef nodeRef;
    private String name;
    private QName type;
    private String id;
    private Set<QName> aspects = null;
    private ScriptableQNameMap<String, Serializable> properties = null;
    private ServiceRegistry services = null;
    private NodeService nodeService = null;
    private Boolean isDocument = null;
    private Boolean isContainer = null;
    private String displayPath = null;
    private String mimetype = null;
    private Long size = null;
    private TemplateImageResolver imageResolver = null;
    private Node parent = null;
    private ChildAssociationRef primaryParentAssoc = null;

    public Node(NodeRef nodeRef, ServiceRegistry services, TemplateImageResolver resolver) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = nodeRef;
        this.id = nodeRef.getId();
        this.services = services;
        this.nodeService = services.getNodeService();
        this.imageResolver = resolver;
    }

    public String getId() {
        return this.id;
    }

    public String jsGet_id() {
        return this.getId();
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String jsGet_nodeRef() {
        return this.getNodeRef().toString();
    }

    public QName getType() {
        if (this.type == null) {
            this.type = this.nodeService.getType(this.nodeRef);
        }
        return this.type;
    }

    public String jsGet_type() {
        return this.getType().toString();
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getProperties().get("cm:name");
            if (this.name == null) {
                ChildAssociationRef parentRef = this.nodeService.getPrimaryParent(this.nodeRef);
                this.name = parentRef != null && parentRef.getQName() != null ? parentRef.getQName().getLocalName() : "";
            }
        }
        return this.name;
    }

    public String jsGet_name() {
        return this.getName();
    }

    public void setName(String name) {
        if (name != null) {
            this.getProperties().put(ContentModel.PROP_NAME.toString(), name.toString());
        }
    }

    public void jsSet_name(String name) {
        this.setName(name);
    }

    public Node[] getChildren() {
        if (this.children == null) {
            List<ChildAssociationRef> childRefs = this.nodeService.getChildAssocs(this.nodeRef);
            this.children = new Node[childRefs.size()];
            for (int i = 0; i < childRefs.size(); ++i) {
                Node child;
                this.children[i] = child = new Node(childRefs.get(i).getChildRef(), this.services, this.imageResolver);
            }
        }
        return this.children;
    }

    public Node[] jsGet_children() {
        return this.getChildren();
    }

    public Node childByNamePath(String path) {
        StringBuilder xpath = new StringBuilder(path.length() << 1);
        StringTokenizer t = new StringTokenizer(path, "/");
        while (t.hasMoreTokens()) {
            if (xpath.length() != 0) {
                xpath.append('/');
            }
            xpath.append("*[@cm:name='").append(t.nextToken()).append("']");
        }
        Node[] nodes = this.getChildrenByXPath(xpath.toString(), true);
        return nodes.length != 0 ? nodes[0] : null;
    }

    public Node[] childrenByXPath(String xpath) {
        return this.getChildrenByXPath(xpath, false);
    }

    public Map<String, Node[]> getAssocs() {
        if (this.assocs == null) {
            this.assocs = new ScriptableQNameMap(this.services.getNamespaceService());
            List<AssociationRef> refs = this.nodeService.getTargetAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                Node[] nodes = (Node[])this.assocs.get(qname);
                if (nodes == null) {
                    nodes = new Node[1];
                } else {
                    Node[] newNodes = new Node[nodes.length + 1];
                    System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                    nodes = newNodes;
                }
                nodes[nodes.length - 1] = new Node(ref.getTargetRef(), this.services, this.imageResolver);
                this.assocs.put((Object)ref.getTypeQName().toString(), (Object)nodes);
            }
        }
        return this.assocs;
    }

    public Map<String, Node[]> jsGet_assocs() {
        return this.getAssocs();
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableQNameMap(this.services.getNamespaceService());
            Map<QName, Serializable> props = this.nodeService.getProperties(this.nodeRef);
            for (QName qname : props.keySet()) {
                Serializable propValue = props.get(qname);
                if (propValue instanceof NodeRef) {
                    propValue = new Node((NodeRef)propValue, this.services, this.imageResolver);
                } else if (propValue instanceof ContentData) {
                    propValue = new ScriptContentData((ContentData)propValue, qname);
                }
                this.properties.put((Object)qname.toString(), (Object)propValue);
            }
        }
        return this.properties;
    }

    public Map<String, Object> jsGet_properties() {
        return this.getProperties();
    }

    public boolean isContainer() {
        if (this.isContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isContainer = dd.isSubClass(this.getType(), ContentModel.TYPE_FOLDER) && !dd.isSubClass(this.getType(), ContentModel.TYPE_SYSTEM_FOLDER);
        }
        return this.isContainer;
    }

    public boolean jsGet_isContainer() {
        return this.isContainer();
    }

    public boolean isDocument() {
        if (this.isDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isDocument = dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT);
        }
        return this.isDocument;
    }

    public boolean jsGet_isDocument() {
        return this.isDocument();
    }

    public Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.nodeService.getAspects(this.nodeRef);
        }
        return this.aspects;
    }

    public String[] jsGet_aspects() {
        Set<QName> aspects = this.getAspects();
        String[] result = new String[aspects.size()];
        int count = 0;
        for (QName qname : aspects) {
            result[count++] = qname.toString();
        }
        return result;
    }

    public boolean hasAspect(String aspect) {
        return this.getAspects().contains(this.createQName(aspect));
    }

    public boolean hasPermission(String permission) {
        boolean allowed = false;
        if (permission != null && permission.length() != 0) {
            AccessStatus status = this.services.getPermissionService().hasPermission(this.nodeRef, permission);
            allowed = AccessStatus.ALLOWED == status;
        }
        return allowed;
    }

    public String getDisplayPath() {
        if (this.displayPath == null) {
            try {
                this.displayPath = this.nodeService.getPath(this.nodeRef).toDisplayPath(this.nodeService);
            }
            catch (AccessDeniedException err) {
                this.displayPath = "";
            }
        }
        return this.displayPath;
    }

    public String jsGet_displayPath() {
        return this.getDisplayPath();
    }

    public String getIcon16() {
        if (this.imageResolver != null) {
            if (this.isDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), true);
            }
            return "/images/icons/space_small.gif";
        }
        return "/images/filetypes/_default.gif";
    }

    public String jsGet_icon16() {
        return this.getIcon16();
    }

    public String getIcon32() {
        if (this.imageResolver != null) {
            if (this.isDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), false);
            }
            String icon = (String)this.getProperties().get("app:icon");
            if (icon != null) {
                return "/images/icons/" + icon + ".gif";
            }
            return "/images/icons/space-icon-default.gif";
        }
        return "/images/filetypes32/_default.gif";
    }

    public String jsGet_icon32() {
        return this.getIcon32();
    }

    public boolean isLocked() {
        LockStatus lockStatus;
        boolean locked = false;
        if (this.getAspects().contains(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.services.getLockService().getLockStatus(this.nodeRef)) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            locked = true;
        }
        return locked;
    }

    public boolean jsGet_isLocked() {
        return this.isLocked();
    }

    public Node getParent() {
        NodeRef parentRef;
        if (this.parent == null && (parentRef = this.nodeService.getPrimaryParent(this.nodeRef).getParentRef()) != null) {
            this.parent = new Node(parentRef, this.services, this.imageResolver);
        }
        return this.parent;
    }

    public Node jsGet_parent() {
        return this.getParent();
    }

    public ChildAssociationRef getPrimaryParentAssoc() {
        if (this.primaryParentAssoc == null) {
            this.primaryParentAssoc = this.nodeService.getPrimaryParent(this.nodeRef);
        }
        return this.primaryParentAssoc;
    }

    public ChildAssociationRef jsGet_primaryParentAssoc() {
        return this.getPrimaryParentAssoc();
    }

    public String getContent() {
        String content = "";
        ScriptContentData contentData = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (contentData != null) {
            content = contentData.getContent();
        }
        return content;
    }

    public String jsGet_content() {
        return this.getContent();
    }

    public void setContent(String content) {
        ScriptContentData contentData = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (contentData != null) {
            contentData.setContent(content);
        }
    }

    public void jsSet_content(String content) {
        this.setContent(content);
    }

    public String getUrl() {
        if (this.isDocument()) {
            try {
                return MessageFormat.format(CONTENT_DEFAULT_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId(), StringUtils.replace((String)URLEncoder.encode(this.getName(), "UTF-8"), (String)"+", (String)"%20"));
            }
            catch (UnsupportedEncodingException err) {
                throw new AlfrescoRuntimeException("Failed to encode content URL for node: " + this.nodeRef, (Throwable)err);
            }
        }
        return MessageFormat.format(FOLDER_BROWSE_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId());
    }

    public String jsGet_url() {
        return this.getUrl();
    }

    public String getMimetype() {
        ScriptContentData content;
        if (this.mimetype == null && (content = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.mimetype = content.getMimetype();
        }
        return this.mimetype;
    }

    public String jsGet_mimetype() {
        return this.getMimetype();
    }

    public long getSize() {
        ScriptContentData content;
        if (this.size == null && (content = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.size = content.getSize();
        }
        return this.size != null ? this.size : 0L;
    }

    public long jsGet_size() {
        return this.getSize();
    }

    public TemplateImageResolver getImageResolver() {
        return this.imageResolver;
    }

    public void save() {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(this.getProperties().size());
        for (String key : this.properties.keySet()) {
            Serializable value = (Serializable)this.properties.get(key);
            if (value instanceof Node) {
                value = ((Node)value).getNodeRef();
            } else if (value instanceof ScriptContentData) {
                value = ((ScriptContentData)value).contentData;
            } else if (value instanceof Wrapper) {
                value = (Serializable)((Wrapper)value).unwrap();
            } else if (value instanceof ScriptableObject) {
                ScriptableObject values = (ScriptableObject)value;
                Object[] propIds = values.getIds();
                ArrayList<Serializable> propValues = new ArrayList<Serializable>(propIds.length);
                for (int i = 0; i < propIds.length; ++i) {
                    Object propId = propIds[i];
                    if (!(propId instanceof Integer)) continue;
                    Object val = values.get(((Integer)propId).intValue(), (Scriptable)values);
                    if (val instanceof Wrapper) {
                        val = ((Wrapper)val).unwrap();
                    }
                    if (!(val instanceof Serializable)) continue;
                    propValues.add((Serializable)val);
                }
                value = propValues;
            }
            props.put(this.createQName(key), value);
        }
        this.nodeService.setProperties(this.nodeRef, props);
    }

    public Node createFile(String name) {
        Node node = null;
        try {
            if (name != null && name.length() != 0) {
                FileInfo fileInfo = this.services.getFileFolderService().create(this.nodeRef, name, ContentModel.TYPE_CONTENT);
                node = new Node(fileInfo.getNodeRef(), this.services, this.imageResolver);
            }
        }
        catch (FileExistsException fileErr) {
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return node;
    }

    public Node createFolder(String name) {
        Node node = null;
        try {
            if (name != null && name.length() != 0) {
                FileInfo fileInfo = this.services.getFileFolderService().create(this.nodeRef, name, ContentModel.TYPE_FOLDER);
                node = new Node(fileInfo.getNodeRef(), this.services, this.imageResolver);
            }
        }
        catch (FileExistsException fileErr) {
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return node;
    }

    public Node createNode(String name, String type) {
        Node node = null;
        try {
            if (name != null && name.length() != 0 && type != null && type.length() != 0) {
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef childAssocRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName("http://www.alfresco.org", QName.createValidLocalName(name)), this.createQName(type), props);
                node = new Node(childAssocRef.getChildRef(), this.services, this.imageResolver);
            }
        }
        catch (AccessDeniedException accessErr) {
            // empty catch block
        }
        return node;
    }

    public boolean remove() {
        boolean success = false;
        try {
            this.nodeService.deleteNode(this.nodeRef);
            this.reset();
            success = true;
        }
        catch (AccessDeniedException accessErr) {
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            // empty catch block
        }
        return success;
    }

    public Node copy(Node destination) {
        return this.copy(destination, false);
    }

    public Node copy(Node destination, boolean deepCopy) {
        Node copy = null;
        try {
            if (destination != null) {
                NodeRef copyRef = this.services.getCopyService().copy(this.nodeRef, destination.getNodeRef(), ContentModel.ASSOC_CONTAINS, this.getPrimaryParentAssoc().getQName(), deepCopy);
                copy = new Node(copyRef, this.services, this.imageResolver);
            }
        }
        catch (AccessDeniedException accessErr) {
        }
        catch (InvalidNodeRefException nodeErr) {
            // empty catch block
        }
        return copy;
    }

    public boolean move(Node destination) {
        boolean success = false;
        try {
            if (destination != null) {
                this.primaryParentAssoc = this.nodeService.moveNode(this.nodeRef, destination.getNodeRef(), ContentModel.ASSOC_CONTAINS, this.getPrimaryParentAssoc().getQName());
                this.reset();
                success = true;
            }
        }
        catch (AccessDeniedException accessErr) {
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            // empty catch block
        }
        return success;
    }

    public boolean addAspect(String type) {
        return this.addAspect(type, null);
    }

    public boolean addAspect(String type, Object properties) {
        boolean success = false;
        if (type != null && type.length() != 0) {
            try {
                HashMap<QName, Serializable> aspectProps = null;
                if (properties instanceof ScriptableObject) {
                    ScriptableObject props = (ScriptableObject)properties;
                    Object[] propIds = props.getIds();
                    aspectProps = new HashMap<QName, Serializable>(propIds.length);
                    for (int i = 0; i < propIds.length; ++i) {
                        Object propId = propIds[i];
                        if (!(propId instanceof String)) continue;
                        Object value = props.get((String)propId, (Scriptable)props);
                        if (value instanceof Wrapper) {
                            value = ((Wrapper)value).unwrap();
                        }
                        if (!(value instanceof Serializable)) continue;
                        aspectProps.put(this.createQName((String)propId), (Serializable)value);
                    }
                }
                QName aspectQName = this.createQName(type);
                this.nodeService.addAspect(this.nodeRef, aspectQName, aspectProps);
                this.reset();
                success = true;
            }
            catch (InvalidAspectException aspectErr) {
                // empty catch block
            }
        }
        return success;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf(NAMESPACE_BEGIN) != -1 ? QName.createQName(s) : QName.createQName(s, this.services.getNamespaceService());
        return qname;
    }

    private void reset() {
        this.name = null;
        this.type = null;
        this.properties = null;
        this.aspects = null;
        this.assocs = null;
        this.children = null;
        this.displayPath = null;
        this.isDocument = null;
        this.isContainer = null;
        this.mimetype = null;
        this.size = null;
        this.parent = null;
        this.primaryParentAssoc = null;
    }

    public String toString() {
        if (this.nodeService.exists(this.nodeRef)) {
            return "Node Type: " + this.getType() + "\nNode Properties: " + this.getProperties().toString() + "\nNode Aspects: " + this.getAspects().toString();
        }
        return "Node no longer exists: " + this.nodeRef;
    }

    private Node[] getChildrenByXPath(String xpath, boolean firstOnly) {
        Node[] result = null;
        if (xpath.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing xpath: " + xpath));
            }
            List<NodeRef> nodes = this.services.getSearchService().selectNodes(this.nodeRef, xpath, null, this.services.getNamespaceService(), false);
            if (firstOnly) {
                if (nodes.size() != 0) {
                    result = new Node[]{new Node(nodes.get(0), this.services, this.imageResolver)};
                }
            } else {
                result = new Node[nodes.size()];
                for (int i = 0; i < nodes.size(); ++i) {
                    NodeRef ref = nodes.get(i);
                    result[i] = new Node(ref, this.services, this.imageResolver);
                }
            }
        }
        return result != null ? result : new Node[]{};
    }

    public class ScriptContentData
    implements Serializable {
        private ContentData contentData;
        private QName property;

        public ScriptContentData(ContentData contentData, QName property) {
            this.contentData = contentData;
            this.property = property;
        }

        public String getContent() {
            ContentService contentService = Node.this.services.getContentService();
            ContentReader reader = contentService.getReader(Node.this.nodeRef, this.property);
            return reader != null && reader.exists() ? reader.getContentString() : "";
        }

        public String jsGet_content() {
            return this.getContent();
        }

        public void setContent(String content) {
            ContentService contentService = Node.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(Node.this.nodeRef, this.property, true);
            writer.setMimetype(this.getMimetype());
            writer.putContent(content);
            this.contentData = (ContentData)Node.this.services.getNodeService().getProperty(Node.this.nodeRef, this.property);
        }

        public void jsSet_content(String content) {
            this.setContent(content);
        }

        public String getUrl() {
            try {
                return MessageFormat.format(Node.CONTENT_PROP_URL, Node.this.nodeRef.getStoreRef().getProtocol(), Node.this.nodeRef.getStoreRef().getIdentifier(), Node.this.nodeRef.getId(), StringUtils.replace((String)URLEncoder.encode(Node.this.getName(), "UTF-8"), (String)"+", (String)"%20"), StringUtils.replace((String)URLEncoder.encode(this.property.toString(), "UTF-8"), (String)"+", (String)"%20"));
            }
            catch (UnsupportedEncodingException err) {
                throw new AlfrescoRuntimeException("Failed to encode content URL for node: " + Node.this.nodeRef, (Throwable)err);
            }
        }

        public String jsGet_url() {
            return this.getUrl();
        }

        public long getSize() {
            return this.contentData.getSize();
        }

        public long jsGet_size() {
            return this.getSize();
        }

        public String getMimetype() {
            return this.contentData.getMimetype();
        }

        public String jsGet_mimetype() {
            return this.getMimetype();
        }
    }
}

