/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.Node;
import org.alfresco.repo.jscript.Search;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptException;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptService
implements ScriptService {
    private NodeService nodeService;
    private ContentService contentService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public Object executeScript(String scriptClasspath, Map<String, Object> model) throws ScriptException {
        if (scriptClasspath == null) {
            throw new IllegalArgumentException("Script ClassPath is mandatory.");
        }
        Reader reader = null;
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(scriptClasspath);
            if (stream == null) {
                throw new AlfrescoRuntimeException("Unable to load classpath resource: " + scriptClasspath);
            }
            reader = new InputStreamReader(stream);
            Object object = this.executeScriptImpl(reader, model);
            return object;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptClasspath + "': " + err.getMessage(), err);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioErr) {}
            }
        }
    }

    @Override
    public Object executeScript(NodeRef scriptRef, QName contentProp, Map<String, Object> model) throws ScriptException {
        if (scriptRef == null) {
            throw new IllegalArgumentException("Script NodeRef is mandatory.");
        }
        Reader reader = null;
        try {
            ContentReader cr;
            if (!this.nodeService.exists(scriptRef)) {
                throw new AlfrescoRuntimeException("Script Node does not exist: " + scriptRef);
            }
            if (contentProp == null) {
                contentProp = ContentModel.PROP_CONTENT;
            }
            if ((cr = this.contentService.getReader(scriptRef, contentProp)) == null || !cr.exists()) {
                throw new AlfrescoRuntimeException("Script Node content not found: " + scriptRef);
            }
            reader = new InputStreamReader(cr.getContentInputStream());
            Object object = this.executeScriptImpl(reader, model);
            return object;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptRef.toString() + "': " + err.getMessage(), err);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioErr) {}
            }
        }
    }

    @Override
    public Object executeScriptString(String script, Map<String, Object> model) throws ScriptException {
        if (script == null || script.length() == 0) {
            throw new IllegalArgumentException("Script argument is mandatory.");
        }
        StringReader reader = null;
        try {
            reader = new StringReader(script);
            return this.executeScriptImpl(reader, model);
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute supplied script: " + err.getMessage(), err);
        }
    }

    private Object executeScriptImpl(Reader reader, Map<String, Object> model) throws AlfrescoRuntimeException {
        Context cx = Context.enter();
        try {
            Object result;
            ImporterTopLevel topLevelScope = new ImporterTopLevel(cx);
            ScriptableObject scope = cx.initStandardObjects();
            scope.setParentScope((Scriptable)topLevelScope);
            if (model != null) {
                for (String key : model.keySet()) {
                    Object jsObject = Context.javaToJS((Object)model.get(key), (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)key, (Object)jsObject);
                }
            }
            Object object = result = cx.evaluateReader((Scriptable)scope, reader, "AlfrescoScript", 1, null);
            return object;
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException(err.getMessage(), err);
        }
        finally {
            cx.exit();
        }
    }

    public static Map<String, Object> buildDefaultModel(ServiceRegistry services, NodeRef person, NodeRef companyHome, NodeRef userHome, NodeRef script, NodeRef document, NodeRef space) {
        return RhinoScriptService.buildDefaultModel(services, person, companyHome, userHome, script, document, space, null);
    }

    public static Map<String, Object> buildDefaultModel(ServiceRegistry services, NodeRef person, NodeRef companyHome, NodeRef userHome, NodeRef script, NodeRef document, NodeRef space, TemplateImageResolver resolver) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("companyhome", new Node(companyHome, services, resolver));
        model.put("userhome", new Node(userHome, services, resolver));
        model.put("person", new Node(person, services, resolver));
        if (script != null) {
            model.put("script", new Node(script, services, resolver));
        }
        if (document != null) {
            model.put("document", new Node(document, services, resolver));
        }
        if (space != null) {
            model.put("space", new Node(space, services, resolver));
        }
        model.put("search", new Search(services, companyHome.getStoreRef(), resolver));
        return model;
    }
}

