/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.jscript.Node;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.springframework.context.ApplicationContext;

public class RhinoScriptTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private ScriptService scriptService;
    private static final String TESTSCRIPT_CLASSPATH1 = "org/alfresco/repo/jscript/test_script1.js";
    private static final String TESTSCRIPT1 = "var id = root.id;\r\nout.println(id);\r\nvar name = root.name;\r\nout.println(name);\r\nvar type = root.type;\r\nout.println(type);\r\nvar childList = root.children;\r\nout.println(\"zero index node name: \" + childList[0].name);\r\nout.println(\"name property access: \" + childList[0].properties.name );\r\nvar childByNameNode = root.childByNamePath(\"/\" + childList[0].name);\r\nout.println(\"child by name path: \" + childByNameNode.name);\r\nvar xpathResults = root.childrenByXPath(\"/*\");\r\nout.println(\"children of root from xpath: \" + xpathResults.length);\r\n";

    protected void setUp() throws Exception {
        super.setUp();
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.scriptService = (ScriptService)ctx.getBean("scriptService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        RhinoScriptTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        RhinoScriptTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        BaseNodeServiceTest.loadModel(ctx);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testRhinoIntegration() {
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doWork() throws Exception {
                Context cx = Context.enter();
                try {
                    ScriptableObject scope = cx.initStandardObjects();
                    Object result = cx.evaluateString((Scriptable)scope, "obj = {a:1, b:['x','y']}", "TestJS1", 1, null);
                    Scriptable obj = (Scriptable)scope.get("obj", (Scriptable)scope);
                    Assert.assertNotNull((Object)obj.get("a", obj));
                    Assert.assertEquals((Object)new Double(1.0), (Object)obj.get("a", obj));
                    result = cx.evaluateString((Scriptable)scope, "function f(x) {return x+1} f(7)", "TestJS2", 1, null);
                    Assert.assertEquals((Object)8.0, (Object)Context.toNumber((Object)result));
                }
                catch (Throwable err) {
                    err.printStackTrace();
                    Assert.fail((String)err.getMessage());
                }
                finally {
                    cx.exit();
                }
                return null;
            }
        });
    }

    public void testJSObjectWrapping() {
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doWork() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                Context cx = Context.enter();
                try {
                    ScriptableObject scope = cx.initStandardObjects();
                    Object wrappedOut = Context.javaToJS((Object)System.out, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)"out", (Object)wrappedOut);
                    List<ChildAssociationRef> childAssocs = RhinoScriptTest.this.nodeService.getChildAssocs(root);
                    NodeRef ref1 = childAssocs.get(0).getChildRef();
                    Object wrappedNodeRef = Context.javaToJS((Object)ref1, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)"rootref", (Object)wrappedNodeRef);
                    Object result = cx.evaluateString((Scriptable)scope, "obj = rootref.getId()", "TestJS3", 1, null);
                    Assert.assertEquals((String)ref1.getId(), (String)Context.toString((Object)result));
                    Node node1 = new Node(root, RhinoScriptTest.this.serviceRegistry, null);
                    Object wrappedNode = Context.javaToJS((Object)node1, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)"root", (Object)wrappedNode);
                    result = cx.evaluateString((Scriptable)scope, RhinoScriptTest.TESTSCRIPT1, "TestJS4", 1, null);
                }
                catch (Throwable err) {
                    err.printStackTrace();
                    Assert.fail((String)err.getMessage());
                }
                finally {
                    cx.exit();
                }
                return null;
            }
        });
    }

    public void testScriptService() {
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                StoreRef store = RhinoScriptTest.this.nodeService.createStore("workspace", "rhino_" + System.currentTimeMillis());
                NodeRef root = RhinoScriptTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(RhinoScriptTest.this.nodeService, root);
                try {
                    HashMap<String, Object> model = new HashMap<String, Object>();
                    model.put("out", System.out);
                    Node rootNode = new Node(root, RhinoScriptTest.this.serviceRegistry, null);
                    model.put("root", rootNode);
                    Object result = RhinoScriptTest.this.scriptService.executeScript(RhinoScriptTest.TESTSCRIPT_CLASSPATH1, model);
                    System.out.println("Result from TESTSCRIPT_CLASSPATH1: " + result.toString());
                    Assert.assertTrue((boolean)((Boolean)result));
                    ChildAssociationRef childRef = RhinoScriptTest.this.nodeService.createNode(root, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "script_content"), BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT, null);
                    NodeRef contentNodeRef = childRef.getChildRef();
                    ContentWriter writer = RhinoScriptTest.this.contentService.getWriter(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, true);
                    writer.setMimetype("application/x-javascript");
                    writer.putContent(RhinoScriptTest.TESTSCRIPT1);
                    RhinoScriptTest.this.scriptService.executeScript(contentNodeRef, BaseNodeServiceTest.PROP_QNAME_TEST_CONTENT, model);
                    RhinoScriptTest.this.scriptService.executeScriptString(RhinoScriptTest.TESTSCRIPT1, model);
                }
                catch (Throwable err) {
                    err.printStackTrace();
                    Assert.fail((String)err.getMessage());
                }
                return null;
            }
        });
    }
}

