/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Reader;
import java.io.StringReader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.Node;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class Search {
    private static Log logger = LogFactory.getLog(Search.class);
    private ServiceRegistry services;
    private StoreRef storeRef;
    private TemplateImageResolver imageResolver;

    public Search(ServiceRegistry services, StoreRef storeRef, TemplateImageResolver imageResolver) {
        this.services = services;
        this.storeRef = storeRef;
        this.imageResolver = imageResolver;
    }

    public Node[] luceneSearch(String search) {
        if (search != null && search.length() != 0) {
            return this.query(search);
        }
        return new Node[0];
    }

    public Node[] savedSearch(Node savedSearch) {
        String search = null;
        try {
            SAXReader reader;
            Document document;
            Element rootElement;
            Element queryElement;
            ContentReader content;
            if (savedSearch != null && (content = this.services.getContentService().getReader(savedSearch.getNodeRef(), ContentModel.PROP_CONTENT)) != null && content.exists() && (queryElement = (rootElement = (document = (reader = new SAXReader()).read((Reader)new StringReader(content.getContentString()))).getRootElement()).element("query")) != null) {
                search = queryElement.getText();
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to find or load saved Search: " + savedSearch.getNodeRef(), err);
        }
        return search != null ? this.query(search) : new Node[]{};
    }

    public Node[] savedSearch(String searchRef) {
        if (searchRef != null) {
            return this.savedSearch(new Node(new NodeRef(searchRef), this.services, null));
        }
        return new Node[0];
    }

    private Node[] query(String search) {
        Node[] nodes = null;
        ResultSet results = null;
        try {
            results = this.services.getSearchService().query(this.storeRef, "lucene", search);
            if (results.length() != 0) {
                nodes = new Node[results.length()];
                int count = 0;
                for (ResultSetRow row : results) {
                    NodeRef nodeRef = row.getNodeRef();
                    nodes[count++] = new Node(nodeRef, this.services, this.imageResolver);
                }
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to execute search: " + search, err);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return nodes != null ? nodes : new Node[]{};
    }
}

