/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockServiceImpl
implements LockService {
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private Set<NodeRef> ignoreNodeRefs = new HashSet<NodeRef>();
    private AuthenticationService authenticationService;
    private OwnableService ownableService;
    private SearchService searchService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void initialise() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeCreateVersion"), ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "checkForLock"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeUpdateNode"), ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "checkForLock"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeDeleteNode"), ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "checkForLock"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCopy"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCreateVersion"), ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
    }

    @Override
    public synchronized void lock(NodeRef nodeRef, LockType lockType) {
        this.lock(nodeRef, lockType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lock(NodeRef nodeRef, LockType lockType, int timeToExpire) {
        LockStatus currentLockStatus;
        this.checkForLockApsect(nodeRef);
        String userName = this.getUserName();
        if (lockType == null) {
            lockType = LockType.WRITE_LOCK;
        }
        if (LockStatus.LOCKED.equals((Object)(currentLockStatus = this.getLockStatus(nodeRef, userName)))) {
            throw new UnableToAquireLockException(nodeRef);
        }
        if (LockStatus.NO_LOCK.equals((Object)currentLockStatus) || LockStatus.LOCK_EXPIRED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus)) {
            this.ignoreNodeRefs.add(nodeRef);
            try {
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)userName));
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)lockType.toString()));
                this.setExpiryDate(nodeRef, timeToExpire);
            }
            finally {
                this.ignoreNodeRefs.remove(nodeRef);
            }
        }
    }

    private void setExpiryDate(NodeRef nodeRef, int timeToExpire) {
        Date expiryDate = null;
        if (timeToExpire > 0) {
            expiryDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiryDate);
            calendar.add(13, timeToExpire);
            expiryDate = calendar.getTime();
        }
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE, expiryDate);
    }

    @Override
    public synchronized void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, boolean lockChildren) throws UnableToAquireLockException {
        this.lock(nodeRef, lockType, timeToExpire);
        if (lockChildren) {
            List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.lock(childAssocRef.getChildRef(), lockType, timeToExpire, lockChildren);
            }
        }
    }

    @Override
    public synchronized void lock(Collection<NodeRef> nodeRefs, LockType lockType, int timeToExpire) throws UnableToAquireLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.lock(nodeRef, lockType, timeToExpire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unlock(NodeRef nodeRef) throws UnableToReleaseLockException {
        this.checkForLockApsect(nodeRef);
        this.ignoreNodeRefs.add(nodeRef);
        try {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_OWNER, null);
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_TYPE, null);
        }
        finally {
            this.ignoreNodeRefs.remove(nodeRef);
        }
    }

    @Override
    public synchronized void unlock(NodeRef nodeRef, boolean unlockChildren) throws UnableToReleaseLockException {
        this.unlock(nodeRef);
        if (unlockChildren) {
            List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.unlock(childAssocRef.getChildRef(), unlockChildren);
            }
        }
    }

    @Override
    public synchronized void unlock(Collection<NodeRef> nodeRefs) throws UnableToReleaseLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.unlock(nodeRef);
        }
    }

    @Override
    public LockStatus getLockStatus(NodeRef nodeRef) {
        return this.getLockStatus(nodeRef, this.getUserName());
    }

    private LockStatus getLockStatus(NodeRef nodeRef, String userName) {
        LockStatus result = LockStatus.NO_LOCK;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            String currentUserRef = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
            String owner = this.ownableService.getOwner(nodeRef);
            if (currentUserRef != null) {
                Date expiryDate = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE);
                result = expiryDate != null && expiryDate.before(new Date()) ? LockStatus.LOCK_EXPIRED : (currentUserRef.equals(userName) ? LockStatus.LOCK_OWNER : (owner != null && owner.equals(userName) ? LockStatus.LOCK_OWNER : LockStatus.LOCKED));
            }
        }
        return result;
    }

    @Override
    public LockType getLockType(NodeRef nodeRef) {
        String lockTypeString;
        LockType result = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeString = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
            result = LockType.valueOf(lockTypeString);
        }
        return result;
    }

    private void checkForLockApsect(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
    }

    @Override
    public void checkForLock(NodeRef nodeRef) throws NodeLockedException {
        String userName = this.getUserName();
        if (nodeRef != null && userName != null && !this.ignoreNodeRefs.contains(nodeRef) && !userName.equals(AuthenticationUtil.getSystemUserName())) {
            try {
                LockStatus currentLockStatus = this.getLockStatus(nodeRef, userName);
                LockType lockType = this.getLockType(nodeRef);
                if (LockType.WRITE_LOCK.equals((Object)lockType) && LockStatus.LOCKED.equals((Object)currentLockStatus)) {
                    throw new NodeLockedException(nodeRef);
                }
                if (LockType.READ_ONLY_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                    throw new NodeLockedException(nodeRef);
                }
            }
            catch (AspectMissingException aspectMissingException) {
                // empty catch block
            }
        }
    }

    public void onCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        copyDetails.addAspect(ContentModel.ASPECT_LOCKABLE);
    }

    public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        nodeDetails.addAspect(ContentModel.ASPECT_LOCKABLE);
    }

    private String getUserName() {
        return this.authenticationService.getCurrentUserName();
    }

    @Override
    public List<NodeRef> getLocks(StoreRef storeRef) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeRef> getLocks(StoreRef storeRef, String query) {
        ArrayList<NodeRef> result = new ArrayList();
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(storeRef, "lucene", query);
            result = resultSet.getNodeRefs();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return result;
    }

    @Override
    public List<NodeRef> getLocks(StoreRef storeRef, LockType lockType) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"" + " +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_TYPE.getLocalName() + ":\"" + lockType.toString() + "\"");
    }
}

