/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;

public class LockServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private LockService lockService;
    private AuthenticationService authenticationService;
    private NodeRef parentNode;
    private NodeRef childNode1;
    private NodeRef childNode2;
    private NodeRef noAspectNode;
    private static final String GOOD_USER_NAME = "goodUser";
    private static final String BAD_USER_NAME = "badUser";
    private static final String PWD = "password";
    NodeRef rootNodeRef;
    private StoreRef storeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.authenticationService = (AuthenticationService)this.applicationContext.getBean("authenticationService");
        AuthenticationComponent authComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authComponent.setSystemUserAsCurrentUser();
        HashMap<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>();
        nodeProperties.put(QName.createQName("{test}property1"), (Serializable)((Object)"value1"));
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.parentNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{}ParentNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.parentNode, ContentModel.ASPECT_LOCKABLE, new HashMap<QName, Serializable>());
        HashMap<QName, Serializable> audProps = new HashMap<QName, Serializable>();
        audProps.put(ContentModel.PROP_CREATOR, (Serializable)((Object)"Monkey"));
        this.nodeService.addAspect(this.parentNode, ContentModel.ASPECT_AUDITABLE, audProps);
        LockServiceImplTest.assertNotNull((Object)this.parentNode);
        this.childNode1 = this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CHILDREN, QName.createQName("{}ChildNode1"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.childNode1, ContentModel.ASPECT_LOCKABLE, new HashMap<QName, Serializable>());
        LockServiceImplTest.assertNotNull((Object)this.childNode1);
        this.childNode2 = this.nodeService.createNode(this.parentNode, ContentModel.ASSOC_CHILDREN, QName.createQName("{}ChildNode2"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.childNode2, ContentModel.ASPECT_LOCKABLE, new HashMap<QName, Serializable>());
        LockServiceImplTest.assertNotNull((Object)this.childNode2);
        this.noAspectNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{}noAspectNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        LockServiceImplTest.assertNotNull((Object)this.noAspectNode);
        TestWithUserUtils.createUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.createUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
    }

    public void testLock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCKED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        try {
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
            LockServiceImplTest.fail((String)"The user should not be able to lock the node since it is already locked by another user.");
        }
        catch (UnableToAquireLockException exception) {
            System.out.println(exception.getMessage());
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        try {
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"No error should be thrown when a node is re-locked by the current lock owner.");
        }
        this.lockService.lock(this.noAspectNode, LockType.WRITE_LOCK);
    }

    public void testLockChildren() {
    }

    public void testLockMany() {
    }

    public void testUnlock() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.testLock();
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        try {
            this.lockService.unlock(this.parentNode);
        }
        catch (UnableToReleaseLockException exception) {
            System.out.println(exception.getMessage());
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.unlock(this.parentNode);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        try {
            this.lockService.unlock(this.parentNode);
        }
        catch (Exception exception) {
            LockServiceImplTest.fail((String)"Unlocking an unlocked node should not result in an exception being raised.");
        }
        this.lockService.unlock(this.noAspectNode);
    }

    public void testUnlockChildren() {
    }

    public void testUnlockMany() {
    }

    public void testGetLockStatus() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockStatus lockStatus1 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)lockStatus1));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockStatus lockStatus2 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCKED), (Object)((Object)lockStatus2));
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockStatus lockStatus3 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)lockStatus3));
        this.lockService.getLockStatus(this.noAspectNode);
        LockStatus lockStatus4 = this.lockService.getLockStatus(this.parentNode);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)lockStatus4));
    }

    public void testGetLocks() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        List<NodeRef> locked1 = this.lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull(locked1);
        LockServiceImplTest.assertEquals((int)0, (int)locked1.size());
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        this.lockService.lock(this.childNode1, LockType.WRITE_LOCK);
        this.lockService.lock(this.childNode2, LockType.READ_ONLY_LOCK);
        List<NodeRef> locked2 = this.lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull(locked2);
        LockServiceImplTest.assertEquals((int)3, (int)locked2.size());
        List<NodeRef> locked3 = this.lockService.getLocks(this.storeRef, LockType.WRITE_LOCK);
        LockServiceImplTest.assertNotNull(locked3);
        LockServiceImplTest.assertEquals((int)2, (int)locked3.size());
        List<NodeRef> locked4 = this.lockService.getLocks(this.storeRef, LockType.READ_ONLY_LOCK);
        LockServiceImplTest.assertNotNull(locked4);
        LockServiceImplTest.assertEquals((int)1, (int)locked4.size());
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        List<NodeRef> locked5 = this.lockService.getLocks(this.storeRef);
        LockServiceImplTest.assertNotNull(locked5);
        LockServiceImplTest.assertEquals((int)0, (int)locked5.size());
    }

    public void testGetLockType() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockType lockType1 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)((Object)lockType1));
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK);
        LockType lockType2 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)((Object)lockType2));
        LockServiceImplTest.assertEquals((Object)((Object)LockType.WRITE_LOCK), (Object)((Object)lockType2));
        this.lockService.unlock(this.parentNode);
        LockType lockType3 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNull((Object)((Object)lockType3));
        this.lockService.lock(this.parentNode, LockType.READ_ONLY_LOCK);
        LockType lockType4 = this.lockService.getLockType(this.parentNode);
        LockServiceImplTest.assertNotNull((Object)((Object)lockType4));
        LockServiceImplTest.assertEquals((Object)((Object)LockType.READ_ONLY_LOCK), (Object)((Object)lockType4));
        this.lockService.getLockType(this.noAspectNode);
    }

    public void testTimeToExpire() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCKED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_EXPIRED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_EXPIRED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 0);
        try {
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
            this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
            LockServiceImplTest.fail((String)"Can not update lock info if not lock owner");
        }
        catch (UnableToAquireLockException exception) {
            // empty catch block
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.parentNode, LockType.WRITE_LOCK, 1);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCKED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_EXPIRED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        LockServiceImplTest.assertEquals((Object)((Object)LockStatus.LOCK_EXPIRED), (Object)((Object)this.lockService.getLockStatus(this.parentNode)));
    }
}

