/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class FileFolderPerformanceTester
extends TestCase {
    private static Log logger = LogFactory.getLog(FileFolderPerformanceTester.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private StoreRef storeRef;
    private NodeRef rootFolderRef;
    private File dataFile;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", this.getName() + "_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.rootFolderRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org", this.getName()), ContentModel.TYPE_FOLDER).getChildRef();
        this.dataFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
    }

    public void testSetUp() throws Exception {
        FileFolderPerformanceTester.assertNotNull((Object)this.dataFile);
    }

    private void buildStructure(final NodeRef parentNodeRef, int threadCount, final boolean randomOrder, final int folderCount, final int fileCount, final double[] dumpPoints) {
        int i;
        TransactionUtil.TransactionWork<NodeRef[]> createFoldersWork = new TransactionUtil.TransactionWork<NodeRef[]>(){

            @Override
            public NodeRef[] doWork() throws Exception {
                NodeRef[] folders = new NodeRef[folderCount];
                for (int i = 0; i < folderCount; ++i) {
                    FileInfo folderInfo = FileFolderPerformanceTester.this.fileFolderService.create(parentNodeRef, GUID.generate(), ContentModel.TYPE_FOLDER);
                    folders[i] = folderInfo.getNodeRef();
                }
                return folders;
            }
        };
        final NodeRef[] folders = TransactionUtil.executeInUserTransaction(this.transactionService, createFoldersWork);
        Runnable runnable = new Runnable(){
            private long start;

            public void run() {
                FileFolderPerformanceTester.this.authenticationComponent.setSystemUserAsCurrentUser();
                this.start = System.currentTimeMillis();
                int nextDumpNumber = 0;
                for (int i = 0; i < fileCount; ++i) {
                    double nextDumpCount;
                    double completedCount = i;
                    double d = nextDumpCount = dumpPoints == null || dumpPoints.length == 0 || nextDumpNumber >= dumpPoints.length ? -1.0 : (double)fileCount * dumpPoints[nextDumpNumber];
                    if (nextDumpCount - 0.5 < completedCount && completedCount < nextDumpCount + 0.5) {
                        this.dumpResults(i);
                        ++nextDumpNumber;
                    }
                    List<NodeRef> foldersList = Arrays.asList(folders);
                    if (randomOrder) {
                        Collections.shuffle(foldersList);
                    }
                    for (int j = 0; j < folders.length; ++j) {
                        final NodeRef folderRef = folders[j];
                        TransactionUtil.TransactionWork<FileInfo> createFileWork = new TransactionUtil.TransactionWork<FileInfo>(){

                            @Override
                            public FileInfo doWork() throws Exception {
                                FileInfo fileInfo = FileFolderPerformanceTester.this.fileFolderService.create(folderRef, GUID.generate(), ContentModel.TYPE_CONTENT);
                                NodeRef nodeRef = fileInfo.getNodeRef();
                                ContentWriter writer = FileFolderPerformanceTester.this.fileFolderService.getWriter(nodeRef);
                                writer.putContent(FileFolderPerformanceTester.this.dataFile);
                                return fileInfo;
                            }
                        };
                        TransactionUtil.executeInUserTransaction(FileFolderPerformanceTester.this.transactionService, createFileWork);
                    }
                }
                this.dumpResults(fileCount);
            }

            private void dumpResults(int currentFileCount) {
                long end = System.currentTimeMillis();
                long time = end - this.start;
                double average = (double)time / (double)(folderCount * currentFileCount);
                double percentComplete = (double)currentFileCount / (double)fileCount * 100.0;
                logger.debug((Object)("\n[" + Thread.currentThread().getName() + "] \n" + "   Created " + currentFileCount + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + "): \n" + "   Progress: " + String.format("%9.2f", percentComplete) + " percent complete \n" + "   Average: " + String.format("%10.2f", average) + " ms per file \n" + "   Average: " + String.format("%10.2f", 1000.0 / average) + " files per second"));
            }
        };
        logger.debug((Object)("\nStarting " + threadCount + " threads loading " + fileCount + " files in each of " + folderCount + " folders (" + (randomOrder ? "shuffled" : "in order") + ")."));
        ThreadGroup threadGroup = new ThreadGroup(this.getName());
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(threadGroup, runnable, String.format("FileLoader-%02d", i));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void test_2_ordered_1_10() throws Exception {
        this.buildStructure(this.rootFolderRef, 2, false, 1, 10, null);
    }

    public void test_4_shuffled_100_100() throws Exception {
        this.buildStructure(this.rootFolderRef, 4, true, 100, 100, new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
    }
}

