/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderServiceImpl
implements FileFolderService {
    private static final String XPATH_QUERY_SHALLOW_FILES = "./*[(subtypeOf('" + ContentModel.TYPE_CONTENT + "'))]";
    private static final String XPATH_QUERY_SHALLOW_FOLDERS = "./*[not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "'))]";
    private static final String XPATH_QUERY_SHALLOW_ALL = "./*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "'))]";
    private static final String XPATH_QUERY_DEEP_ALL = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "'))]";
    private static final QueryParameterDefinition[] PARAMS_EMPTY = new QueryParameterDefinition[0];
    private static final QueryParameterDefinition[] PARAMS_ANY_NAME = new QueryParameterDefinition[1];
    private static Log logger = LogFactory.getLog(FileFolderServiceImpl.class);
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private CopyService copyService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private List systemPaths;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setSystemPaths(List<String> systemPaths) {
        this.systemPaths = systemPaths;
    }

    public void init() {
        FileFolderServiceImpl.PARAMS_ANY_NAME[0] = new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, "%");
    }

    private List<FileInfo> toFileInfo(List<NodeRef> nodeRefs) throws InvalidTypeException {
        ArrayList<FileInfo> results = new ArrayList<FileInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            FileInfo fileInfo = this.toFileInfo(nodeRef);
            results.add(fileInfo);
        }
        return results;
    }

    private FileInfo toFileInfo(NodeRef nodeRef) throws InvalidTypeException {
        Map<QName, Serializable> properties = this.nodeService.getProperties(nodeRef);
        QName typeQName = this.nodeService.getType(nodeRef);
        boolean isFolder = this.isFolder(typeQName);
        FileInfoImpl fileInfo = new FileInfoImpl(nodeRef, isFolder, properties);
        return fileInfo;
    }

    private void checkExists(NodeRef parentFolderRef, String name) throws FileExistsException {
        List<FileInfo> existingFileInfos = this.search(parentFolderRef, name, true, true, false);
        if (existingFileInfos.size() > 0) {
            throw new FileExistsException(existingFileInfos.get(0));
        }
    }

    private boolean isFolder(QName typeQName) throws InvalidTypeException {
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                throw new InvalidTypeException("This service should ignore type " + ContentModel.TYPE_SYSTEM_FOLDER);
            }
            return true;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            return false;
        }
        throw new InvalidTypeException("Type is not handled by this service: " + typeQName);
    }

    @Override
    public List<FileInfo> list(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.searchService.selectNodes(contextNodeRef, XPATH_QUERY_SHALLOW_ALL, PARAMS_ANY_NAME, this.namespaceService, false);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for files and folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFiles(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.searchService.selectNodes(contextNodeRef, XPATH_QUERY_SHALLOW_FILES, PARAMS_EMPTY, this.namespaceService, false);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for files: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFolders(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.searchService.selectNodes(contextNodeRef, XPATH_QUERY_SHALLOW_FOLDERS, PARAMS_EMPTY, this.namespaceService, false);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        return this.search(contextNodeRef, namePattern, true, true, includeSubFolders);
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        if (!fileSearch && !folderSearch) {
            return Collections.emptyList();
        }
        QueryParameterDefinition[] params = null;
        if (namePattern != null) {
            namePattern = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_XPATH_LIKE, namePattern);
            params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, namePattern)};
        } else {
            params = PARAMS_ANY_NAME;
        }
        String query = null;
        query = includeSubFolders ? XPATH_QUERY_DEEP_ALL : XPATH_QUERY_SHALLOW_ALL;
        List<NodeRef> nodeRefs = this.searchService.selectNodes(contextNodeRef, query, params, this.namespaceService, false);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        Iterator<FileInfo> iterator = results.iterator();
        while (iterator.hasNext()) {
            FileInfo file = iterator.next();
            if (file.isFolder() && !folderSearch) {
                iterator.remove();
                continue;
            }
            if (file.isFolder() || fileSearch) continue;
            iterator.remove();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deep search: \n   context: " + contextNodeRef + "\n" + "   pattern: " + namePattern + "\n" + "   files: " + fileSearch + "\n" + "   folders: " + folderSearch + "\n" + "   deep: " + includeSubFolders + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.move(sourceNodeRef, null, newName);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo copy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, targetParentRef, newName, false);
    }

    private FileInfo moveOrCopy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName, boolean move) throws FileExistsException, FileNotFoundException {
        FileInfo beforeFileInfo = this.toFileInfo(sourceNodeRef);
        if (newName == null) {
            newName = beforeFileInfo.getName();
        }
        ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(sourceNodeRef);
        if (targetParentRef == null) {
            targetParentRef = assocRef.getParentRef();
        }
        if (targetParentRef.equals(assocRef.getParentRef()) && newName.equals(beforeFileInfo.getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Doing nothing - neither filename or parent has not changed: \n   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   new name: " + newName));
            }
            return beforeFileInfo;
        }
        this.checkExists(targetParentRef, newName);
        QName qname = QName.createQName("http://www.alfresco.org/model/content/1.0", QName.createValidLocalName(newName));
        NodeRef targetNodeRef = null;
        if (move) {
            if (!this.isSystemPath(sourceNodeRef)) {
                ChildAssociationRef newAssocRef = this.nodeService.moveNode(sourceNodeRef, targetParentRef, assocRef.getTypeQName(), qname);
                targetNodeRef = newAssocRef.getChildRef();
            } else {
                targetNodeRef = sourceNodeRef;
            }
        } else {
            targetNodeRef = this.copyService.copy(sourceNodeRef, targetParentRef, assocRef.getTypeQName(), qname, true);
        }
        String currentName = (String)((Object)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_NAME));
        if (!currentName.equals(newName)) {
            this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        }
        FileInfo afterFileInfo = this.toFileInfo(targetNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + (move ? "Moved" : "Copied") + " node: \n" + "   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   after: " + afterFileInfo));
        }
        return afterFileInfo;
    }

    private boolean isSystemPath(NodeRef nodeRef) {
        Path path = this.nodeService.getPath(nodeRef);
        String prefixedPath = path.toPrefixString(this.namespaceService);
        return this.systemPaths.contains(prefixedPath);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        boolean isFolder = false;
        try {
            isFolder = this.isFolder(typeQName);
        }
        catch (InvalidTypeException e) {
            throw new AlfrescoRuntimeException("The type is not supported by this service: " + typeQName);
        }
        this.checkExists(parentNodeRef, name);
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(11);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        if (!isFolder) {
            String mimetype = this.mimetypeService.guessMimetype(name);
            ContentData contentData = new ContentData(null, mimetype, 0L, "UTF-8");
            properties.put(ContentModel.PROP_CONTENT, contentData);
        }
        QName qname = QName.createQName("http://www.alfresco.org/model/content/1.0", QName.createValidLocalName(name));
        ChildAssociationRef assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, qname, typeQName, properties);
        NodeRef nodeRef = assocRef.getChildRef();
        FileInfo fileInfo = this.toFileInfo(nodeRef);
        if (logger.isDebugEnabled()) {
            FileInfo parentFileInfo = this.toFileInfo(parentNodeRef);
            logger.debug((Object)("Created: \n   parent: " + parentFileInfo + "\n" + "   created: " + fileInfo));
        }
        return fileInfo;
    }

    @Override
    public void delete(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public FileInfo makeFolders(NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path element list is empty");
        }
        boolean isFolder = this.isFolder(folderTypeQName);
        if (!isFolder) {
            throw new IllegalArgumentException("Type is invalid to make folders with: " + folderTypeQName);
        }
        NodeRef currentParentRef = parentNodeRef;
        FileInfo lastFileInfo = null;
        for (String pathElement : pathElements) {
            try {
                FileInfo createdFileInfo = this.create(currentParentRef, pathElement, folderTypeQName);
                currentParentRef = createdFileInfo.getNodeRef();
                lastFileInfo = createdFileInfo;
            }
            catch (FileExistsException e) {
                List<FileInfo> fileInfos = this.search(currentParentRef, pathElement, false, true, false);
                if (fileInfos.size() == 0) {
                    throw new AlfrescoRuntimeException("Path element has just been removed: " + pathElement);
                }
                currentParentRef = fileInfos.get(0).getNodeRef();
                lastFileInfo = fileInfos.get(0);
            }
        }
        return lastFileInfo;
    }

    @Override
    public List<FileInfo> getNamePath(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null) {
            rootNodeRef = this.nodeService.getRootNode(nodeRef.getStoreRef());
        }
        try {
            ArrayList<FileInfo> results = new ArrayList<FileInfo>(10);
            Path path = this.nodeService.getPath(nodeRef);
            boolean foundRoot = false;
            for (Path.Element element : path) {
                Path.ChildAssocElement assocElement = (Path.ChildAssocElement)element;
                NodeRef childNodeRef = assocElement.getRef().getChildRef();
                if (childNodeRef.equals(rootNodeRef)) {
                    foundRoot = true;
                    continue;
                }
                if (!foundRoot) continue;
                FileInfo pathInfo = this.toFileInfo(childNodeRef);
                results.add(pathInfo);
            }
            if (!foundRoot || results.size() == 0) {
                throw new FileNotFoundException(nodeRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Built name path for node: \n   root: " + rootNodeRef + "\n" + "   node: " + nodeRef + "\n" + "   path: " + results));
            }
            return results;
        }
        catch (InvalidNodeRefException e) {
            throw new FileNotFoundException(nodeRef);
        }
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements) throws FileNotFoundException {
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path elements list is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        StringBuilder currentPath = new StringBuilder(pathElements.size() * 20);
        int folderCount = pathElements.size() - 1;
        for (int i = 0; i < folderCount; ++i) {
            String pathElement = pathElements.get(i);
            FileInfo pathElementInfo = this.getPathElementInfo(currentPath, rootNodeRef, parentNodeRef, pathElement, true);
            parentNodeRef = pathElementInfo.getNodeRef();
        }
        String pathElement = pathElements.get(pathElements.size() - 1);
        FileInfo result = this.getPathElementInfo(currentPath, rootNodeRef, parentNodeRef, pathElement, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resoved path element: \n   root: " + rootNodeRef + "\n" + "   path: " + currentPath + "\n" + "   node: " + result));
        }
        return result;
    }

    private FileInfo getPathElementInfo(StringBuilder currentPath, NodeRef rootNodeRef, NodeRef parentNodeRef, String pathElement, boolean folderOnly) throws FileNotFoundException {
        currentPath.append("/").append(pathElement);
        boolean includeFiles = !folderOnly;
        List<FileInfo> pathElementInfos = this.search(parentNodeRef, pathElement, includeFiles, true, false);
        if (pathElementInfos.size() == 0) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(folderOnly ? "Folder" : "File or folder").append(" not found: \n").append("   root: ").append(rootNodeRef).append("\n").append("   path: ").append((CharSequence)currentPath);
            throw new FileNotFoundException(sb.toString());
        }
        if (pathElementInfos.size() > 1) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Duplicate file or folder found: \n").append("   root: ").append(rootNodeRef).append("\n").append("   path: ").append((CharSequence)currentPath);
            logger.warn((Object)sb);
        }
        FileInfo pathElementInfo = pathElementInfos.get(0);
        return pathElementInfo;
    }

    @Override
    public FileInfo getFileInfo(NodeRef nodeRef) {
        try {
            return this.toFileInfo(nodeRef);
        }
        catch (InvalidTypeException e) {
            return null;
        }
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content reader for a folder: " + fileInfo);
        }
        return this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content writer for a folder: " + fileInfo);
        }
        return this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
    }

    private static class InvalidTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -310101369475434280L;

        public InvalidTypeException(String msg) {
            super(msg);
        }
    }
}

