/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderServiceImplTest
extends TestCase {
    private static final String IMPORT_VIEW = "filefolder/filefolder-test-import.xml";
    private static final String NAME_L0_FILE_A = "L0- File A";
    private static final String NAME_L0_FILE_B = "L0- File B";
    private static final String NAME_L0_FOLDER_A = "L0- Folder A";
    private static final String NAME_L0_FOLDER_B = "L0- Folder B";
    private static final String NAME_L0_FOLDER_C = "L0- Folder C";
    private static final String NAME_L1_FOLDER_A = "L1- Folder A";
    private static final String NAME_L1_FOLDER_B = "L1- Folder B";
    private static final String NAME_L1_FILE_A = "L1- File A";
    private static final String NAME_L1_FILE_B = "L1- File B";
    private static final String NAME_L1_FILE_C = "L1- File C (%_)";
    private static final String NAME_DUPLICATE = "DUPLICATE";
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private UserTransaction txn;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        StoreRef storeRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingRootNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org", "working root"), ContentModel.TYPE_FOLDER).getChildRef();
        ImporterService importerService = serviceRegistry.getImporterService();
        Location importLocation = new Location(this.workingRootNodeRef);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(IMPORT_VIEW);
        if (is == null) {
            throw new NullPointerException("Test resource not found: filefolder/filefolder-test-import.xml");
        }
        InputStreamReader reader = new InputStreamReader(is);
        importerService.importView(reader, importLocation, null, null);
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void checkFileList(List<FileInfo> files, int expectedFileCount, int expectedFolderCount, String[] expectedNames) {
        int fileCount = 0;
        int folderCount = 0;
        ArrayList<String> check = new ArrayList<String>(8);
        for (String filename : expectedNames) {
            check.add(filename);
        }
        for (FileInfo file : files) {
            if (file.isFolder()) {
                ++folderCount;
            } else {
                ++fileCount;
            }
            check.remove(file.getName());
        }
        FileFolderServiceImplTest.assertTrue((String)("Name list was not exact - remaining: " + check), (check.size() == 0 ? 1 : 0) != 0);
        FileFolderServiceImplTest.assertEquals((String)"Incorrect number of files", (int)expectedFileCount, (int)fileCount);
        FileFolderServiceImplTest.assertEquals((String)"Incorrect number of folders", (int)expectedFolderCount, (int)folderCount);
    }

    public void testShallowFilesAndFoldersList() throws Exception {
        List<FileInfo> files = this.fileFolderService.list(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B, NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 2, 3, expectedNames);
    }

    public void testShallowFilesOnlyList() throws Exception {
        List<FileInfo> files = this.fileFolderService.listFiles(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FILE_A, NAME_L0_FILE_B};
        this.checkFileList(files, 2, 0, expectedNames);
    }

    public void testShallowFoldersOnlyList() throws Exception {
        List<FileInfo> files = this.fileFolderService.listFolders(this.workingRootNodeRef);
        String[] expectedNames = new String[]{NAME_L0_FOLDER_A, NAME_L0_FOLDER_B, NAME_L0_FOLDER_C};
        this.checkFileList(files, 0, 3, expectedNames);
    }

    public void testShallowFileSearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, NAME_L0_FILE_B, true, false, false);
        String[] expectedNames = new String[]{NAME_L0_FILE_B};
        this.checkFileList(files, 1, 0, expectedNames);
    }

    public void testDeepFilesAndFoldersSearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, "?1-*", true, true, true);
        String[] expectedNames = new String[]{NAME_L1_FOLDER_A, NAME_L1_FOLDER_B, NAME_L1_FILE_A, NAME_L1_FILE_B, NAME_L1_FILE_C};
        this.checkFileList(files, 3, 2, expectedNames);
    }

    public void testDeepFilesOnlySearch() throws Exception {
        List<FileInfo> files = this.fileFolderService.search(this.workingRootNodeRef, "?1-*", true, false, true);
        String[] expectedNames = new String[]{NAME_L1_FILE_A, NAME_L1_FILE_B, NAME_L1_FILE_C};
        this.checkFileList(files, 3, 0, expectedNames);
    }

    private FileInfo getByName(String name, boolean isFolder) throws Exception {
        List<FileInfo> results = this.fileFolderService.search(this.workingRootNodeRef, name, !isFolder, isFolder, true);
        if (results.size() > 1) {
            throw new AlfrescoRuntimeException("Name is not unique in hierarchy: \n   name: " + name + "\n" + "   is folder: " + isFolder);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public void testGetByName() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_DUPLICATE, true);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        FileFolderServiceImplTest.assertTrue((boolean)fileInfo.isFolder());
        fileInfo = this.getByName(NAME_DUPLICATE, false);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        FileFolderServiceImplTest.assertFalse((boolean)fileInfo.isFolder());
    }

    public void testRenameNormal() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        String newName = "DUPLICATE - renamed";
        folderInfo = this.fileFolderService.rename(folderInfo.getNodeRef(), newName);
        FileInfo checkInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNull((String)"Folder info should have been renamed away", (Object)checkInfo);
        checkInfo = this.getByName(newName, true);
        FileFolderServiceImplTest.assertNotNull((String)"Folder info for new name is not present", (Object)checkInfo);
    }

    public void testRenameDuplicate() throws Exception {
        FileInfo folderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderInfo);
        String newName = NAME_L0_FILE_A;
        try {
            folderInfo = this.fileFolderService.rename(folderInfo.getNodeRef(), newName);
            FileFolderServiceImplTest.fail((String)"Existing file not detected");
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    public void testMove() throws Exception {
        FileInfo folderToMoveInfo = this.getByName(NAME_L1_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderToMoveInfo);
        NodeRef folderToMoveRef = folderToMoveInfo.getNodeRef();
        this.fileFolderService.move(folderToMoveRef, this.workingRootNodeRef, null);
        List<FileInfo> checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, NAME_L1_FOLDER_A, false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not moved to root", (int)1, (int)checkFileInfos.size());
        try {
            this.fileFolderService.move(folderToMoveRef, null, NAME_L0_FOLDER_A);
            FileFolderServiceImplTest.fail((String)"Existing folder not detected");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
        FileInfo checkFileInfo = this.fileFolderService.move(folderToMoveRef, null, "new name");
        checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, checkFileInfo.getName(), false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not renamed in root", (int)1, (int)checkFileInfos.size());
    }

    public void testCopy() throws Exception {
        FileInfo folderToCopyInfo = this.getByName(NAME_L1_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)folderToCopyInfo);
        NodeRef folderToCopyRef = folderToCopyInfo.getNodeRef();
        folderToCopyInfo = this.fileFolderService.copy(folderToCopyRef, this.workingRootNodeRef, null);
        folderToCopyRef = folderToCopyInfo.getNodeRef();
        List<FileInfo> checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, NAME_L1_FOLDER_A, false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not copied to root", (int)1, (int)checkFileInfos.size());
        try {
            this.fileFolderService.copy(folderToCopyRef, null, NAME_L0_FOLDER_A);
            FileFolderServiceImplTest.fail((String)"Existing folder not detected");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
        FileInfo checkFileInfo = this.fileFolderService.copy(folderToCopyRef, null, "new name");
        checkFileInfos = this.fileFolderService.search(this.workingRootNodeRef, checkFileInfo.getName(), false);
        FileFolderServiceImplTest.assertEquals((String)"Folder not renamed in root", (int)1, (int)checkFileInfos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateFolder() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getNonPropagatingUserTransaction();
        this.txn.begin();
        FileInfo parentFolderInfo = this.getByName(NAME_L0_FOLDER_A, true);
        FileFolderServiceImplTest.assertNotNull((Object)parentFolderInfo);
        NodeRef parentFolderRef = parentFolderInfo.getNodeRef();
        UserTransaction rollbackTxn = null;
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.create(parentFolderRef, NAME_L1_FILE_A, ContentModel.TYPE_CONTENT);
            FileFolderServiceImplTest.fail((String)"Failed to detect duplicate filename");
        }
        catch (FileExistsException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.create(parentFolderRef, "illegal folder", ContentModel.TYPE_SYSTEM_FOLDER);
            FileFolderServiceImplTest.fail((String)"Illegal type not detected");
        }
        catch (RuntimeException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        FileInfo fileInfo = this.fileFolderService.create(parentFolderRef, "newFile", ContentModel.TYPE_CONTENT);
        FileFolderServiceImplTest.assertTrue((String)"Node not created", (boolean)this.nodeService.exists(fileInfo.getNodeRef()));
        FileFolderServiceImplTest.assertFalse((String)"File type expected", (boolean)fileInfo.isFolder());
    }

    public void testCreateFile() throws Exception {
    }

    public void testCreateInRoot() throws Exception {
        this.fileFolderService.create(this.rootNodeRef, "New Folder", ContentModel.TYPE_FOLDER);
    }

    public void testMakeFolders() throws Exception {
        ArrayList<String> namePath = new ArrayList<String>(4);
        namePath.add("A");
        namePath.add("B");
        namePath.add("C");
        namePath.add("D");
        FileInfo lastFileInfo = this.fileFolderService.makeFolders(this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"First makeFolder failed", (Object)lastFileInfo);
        FileInfo lastFileInfoAgain = this.fileFolderService.makeFolders(this.rootNodeRef, namePath, ContentModel.TYPE_FOLDER);
        FileFolderServiceImplTest.assertNotNull((String)"Repeat makeFolders failed", (Object)lastFileInfoAgain);
        FileFolderServiceImplTest.assertEquals((String)"Repeat created new leaf", (Object)lastFileInfo.getNodeRef(), (Object)lastFileInfoAgain.getNodeRef());
        List<FileInfo> checkInfos = this.fileFolderService.search(this.rootNodeRef, "D", false, true, true);
        FileFolderServiceImplTest.assertEquals((String)"Expected to find a result", (int)1, (int)checkInfos.size());
        List<FileInfo> checkPathInfos = this.fileFolderService.getNamePath(this.rootNodeRef, checkInfos.get(0).getNodeRef());
        FileFolderServiceImplTest.assertEquals((String)"Path created is incorrect", (int)namePath.size(), (int)checkPathInfos.size());
        int i = 0;
        for (FileInfo checkInfo : checkPathInfos) {
            FileFolderServiceImplTest.assertEquals((String)"Path mismatch", (String)((String)namePath.get(i)), (String)checkInfo.getName());
            ++i;
        }
    }

    public void testGetNamePath() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        FileFolderServiceImplTest.assertNotNull((Object)fileInfo);
        NodeRef nodeRef = fileInfo.getNodeRef();
        List<FileInfo> infoPaths = this.fileFolderService.getNamePath(this.workingRootNodeRef, nodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Not enough elements", (int)2, (int)infoPaths.size());
        FileFolderServiceImplTest.assertEquals((String)"First level incorrent", (String)NAME_L0_FOLDER_A, (String)infoPaths.get(0).getName());
        FileFolderServiceImplTest.assertEquals((String)"Second level incorrent", (String)NAME_L1_FILE_A, (String)infoPaths.get(1).getName());
        infoPaths = this.fileFolderService.getNamePath(null, nodeRef);
        FileFolderServiceImplTest.assertEquals((String)"Not enough elements", (int)3, (int)infoPaths.size());
        FileFolderServiceImplTest.assertEquals((String)"First level incorrent", (String)this.workingRootNodeRef.getId(), (String)infoPaths.get(0).getName());
        FileFolderServiceImplTest.assertEquals((String)"Second level incorrent", (String)NAME_L0_FOLDER_A, (String)infoPaths.get(1).getName());
        FileFolderServiceImplTest.assertEquals((String)"Third level incorrent", (String)NAME_L1_FILE_A, (String)infoPaths.get(2).getName());
        NodeRef startRef = this.getByName(NAME_L0_FOLDER_B, true).getNodeRef();
        try {
            this.fileFolderService.getNamePath(startRef, nodeRef);
            FileFolderServiceImplTest.fail((String)"Failed to detect non-aligned path from root to target node");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void testResolveNamePath() throws Exception {
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        ArrayList<String> pathElements = new ArrayList<String>(3);
        pathElements.add(NAME_L0_FOLDER_A);
        pathElements.add(NAME_L1_FILE_A);
        FileInfo fileInfoCheck = this.fileFolderService.resolveNamePath(this.workingRootNodeRef, pathElements);
        FileFolderServiceImplTest.assertNotNull((String)"File info not found", (Object)fileInfoCheck);
        FileFolderServiceImplTest.assertEquals((String)"Path not resolved to correct node", (Object)fileInfo.getNodeRef(), (Object)fileInfoCheck.getNodeRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetReaderWriter() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        FileInfo dirInfo = this.getByName(NAME_L0_FOLDER_A, true);
        UserTransaction rollbackTxn = null;
        try {
            rollbackTxn = this.transactionService.getNonPropagatingUserTransaction();
            rollbackTxn.begin();
            this.fileFolderService.getWriter(dirInfo.getNodeRef());
            FileFolderServiceImplTest.fail((String)"Failed to detect content write to folder");
        }
        catch (RuntimeException e) {
        }
        finally {
            rollbackTxn.rollback();
        }
        FileInfo fileInfo = this.getByName(NAME_L1_FILE_A, false);
        ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertNotNull((String)"Writer is null", (Object)writer);
        String content = "ABC";
        writer.putContent(content);
        ContentReader reader = this.fileFolderService.getReader(fileInfo.getNodeRef());
        FileFolderServiceImplTest.assertNotNull((String)"Reader is null", (Object)reader);
        String checkContent = reader.getContentString();
        FileFolderServiceImplTest.assertEquals((String)"Content mismatch", (String)content, (String)checkContent);
    }
}

