/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoImpl
implements FileInfo {
    private NodeRef nodeRef;
    private boolean isFolder;
    private Map<QName, Serializable> properties;

    FileInfoImpl(NodeRef nodeRef, boolean isFolder, Map<QName, Serializable> properties) {
        this.nodeRef = nodeRef;
        this.isFolder = isFolder;
        this.properties = properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FileInfo").append("[name=").append(this.getName()).append(", isFolder=").append(this.isFolder).append(", nodeRef=").append(this.nodeRef).append("]");
        return sb.toString();
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public String getName() {
        return (String)((Object)this.properties.get(ContentModel.PROP_NAME));
    }

    @Override
    public Date getCreatedDate() {
        return DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.properties.get(ContentModel.PROP_CREATED));
    }

    @Override
    public Date getModifiedDate() {
        return DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.properties.get(ContentModel.PROP_MODIFIED));
    }

    @Override
    public ContentData getContentData() {
        return DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.properties.get(ContentModel.PROP_CONTENT));
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        return this.properties;
    }
}

