/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.AssociationPolicyDelegate;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeServiceImpl
implements NodeService {
    private static Log logger = LogFactory.getLog(AbstractNodeServiceImpl.class);
    private String uuid = GUID.generate();
    private PolicyComponent policyComponent;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeCreateStorePolicy> beforeCreateStoreDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnCreateStorePolicy> onCreateStoreDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeCreateNodePolicy> beforeCreateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnCreateNodePolicy> onCreateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeUpdateNodePolicy> beforeUpdateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnUpdateNodePolicy> onUpdateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnUpdatePropertiesPolicy> onUpdatePropertiesDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeDeleteNodePolicy> beforeDeleteNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnDeleteNodePolicy> onDeleteNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeAddAspectPolicy> beforeAddAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnAddAspectPolicy> onAddAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeRemoveAspectPolicy> beforeRemoveAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnRemoveAspectPolicy> onRemoveAspectDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.BeforeCreateChildAssociationPolicy> beforeCreateChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnCreateChildAssociationPolicy> onCreateChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.BeforeDeleteChildAssociationPolicy> beforeDeleteChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnDeleteChildAssociationPolicy> onDeleteChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnCreateAssociationPolicy> onCreateAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnDeleteAssociationPolicy> onDeleteAssociationDelegate;

    protected AbstractNodeServiceImpl() {
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNodeServiceImpl)) {
            return false;
        }
        AbstractNodeServiceImpl that = (AbstractNodeServiceImpl)obj;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public void init() {
        this.beforeCreateStoreDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeCreateStorePolicy.class);
        this.onCreateStoreDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnCreateStorePolicy.class);
        this.beforeCreateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeCreateNodePolicy.class);
        this.onCreateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnCreateNodePolicy.class);
        this.beforeUpdateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeUpdateNodePolicy.class);
        this.onUpdateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnUpdateNodePolicy.class);
        this.onUpdatePropertiesDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnUpdatePropertiesPolicy.class);
        this.beforeDeleteNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeDeleteNodePolicy.class);
        this.onDeleteNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnDeleteNodePolicy.class);
        this.beforeAddAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeAddAspectPolicy.class);
        this.onAddAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnAddAspectPolicy.class);
        this.beforeRemoveAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeRemoveAspectPolicy.class);
        this.onRemoveAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnRemoveAspectPolicy.class);
        this.beforeCreateChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.BeforeCreateChildAssociationPolicy.class);
        this.onCreateChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnCreateChildAssociationPolicy.class);
        this.beforeDeleteChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.class);
        this.onDeleteChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnDeleteChildAssociationPolicy.class);
        this.onCreateAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnCreateAssociationPolicy.class);
        this.onDeleteAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnDeleteAssociationPolicy.class);
    }

    protected void invokeBeforeCreateStore(QName nodeTypeQName, StoreRef storeRef) {
        NodeServicePolicies.BeforeCreateStorePolicy policy = this.beforeCreateStoreDelegate.get(nodeTypeQName);
        policy.beforeCreateStore(nodeTypeQName, storeRef);
    }

    protected void invokeOnCreateStore(NodeRef rootNodeRef) {
        Set<QName> qnames = this.getTypeAndAspectQNames(rootNodeRef);
        NodeServicePolicies.OnCreateStorePolicy policy = this.onCreateStoreDelegate.get(qnames);
        policy.onCreateStore(rootNodeRef);
    }

    protected void invokeBeforeCreateNode(NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, QName childNodeTypeQName) {
        NodeServicePolicies.BeforeCreateNodePolicy policy = this.beforeCreateNodeDelegate.get(parentNodeRef, childNodeTypeQName);
        policy.beforeCreateNode(parentNodeRef, assocTypeQName, assocQName, childNodeTypeQName);
    }

    protected void invokeOnCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef childNodeRef = childAssocRef.getChildRef();
        Set<QName> qnames = this.getTypeAndAspectQNames(childNodeRef);
        NodeServicePolicies.OnCreateNodePolicy policy = this.onCreateNodeDelegate.get(childNodeRef, qnames);
        policy.onCreateNode(childAssocRef);
    }

    protected void invokeBeforeUpdateNode(NodeRef nodeRef) {
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.BeforeUpdateNodePolicy policy = this.beforeUpdateNodeDelegate.get(nodeRef, qnames);
        policy.beforeUpdateNode(nodeRef);
    }

    protected void invokeOnUpdateNode(NodeRef nodeRef) {
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.OnUpdateNodePolicy policy = this.onUpdateNodeDelegate.get(nodeRef, qnames);
        policy.onUpdateNode(nodeRef);
    }

    protected void invokeOnUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (logger.isDebugEnabled()) {
            if (before == null) {
                logger.debug((Object)("The properties are being set for the first time.  (nodeRef=" + nodeRef.toString() + ")"));
            } else if (after == null) {
                logger.debug((Object)("All the properties are being cleared.  (nodeRef=" + nodeRef.toString() + ")"));
            } else {
                logger.debug((Object)("The following properties have been updated:  (nodeRef=" + nodeRef.toString() + ")"));
                for (Map.Entry<QName, Serializable> entry : after.entrySet()) {
                    Serializable beforeValue = before.get(entry.getKey());
                    if (beforeValue == null) {
                        logger.debug((Object)("   - The property " + entry.getKey().toString() + " has been set for the first time."));
                        continue;
                    }
                    if (beforeValue.equals(entry.getValue())) continue;
                    logger.debug((Object)("   - The property " + entry.getKey().toString() + " has been updated."));
                }
            }
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.OnUpdatePropertiesPolicy policy = this.onUpdatePropertiesDelegate.get(nodeRef, qnames);
        policy.onUpdateProperties(nodeRef, before, after);
    }

    protected void invokeBeforeDeleteNode(NodeRef nodeRef) {
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.BeforeDeleteNodePolicy policy = this.beforeDeleteNodeDelegate.get(nodeRef, qnames);
        policy.beforeDeleteNode(nodeRef);
    }

    protected void invokeOnDeleteNode(ChildAssociationRef childAssocRef, QName childNodeTypeQName, Set<QName> childAspectQnames) {
        HashSet<QName> qnames = new HashSet<QName>(childAspectQnames.size() + 1);
        qnames.addAll(childAspectQnames);
        qnames.add(childNodeTypeQName);
        NodeServicePolicies.OnDeleteNodePolicy policy = this.onDeleteNodeDelegate.get(childAssocRef.getChildRef(), qnames);
        policy.onDeleteNode(childAssocRef);
    }

    protected void invokeBeforeAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        NodeServicePolicies.BeforeAddAspectPolicy policy = this.beforeAddAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.beforeAddAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeOnAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        NodeServicePolicies.OnAddAspectPolicy policy = this.onAddAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.onAddAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeBeforeRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        NodeServicePolicies.BeforeRemoveAspectPolicy policy = this.beforeRemoveAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.beforeRemoveAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeOnRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        NodeServicePolicies.OnRemoveAspectPolicy policy = this.onRemoveAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.onRemoveAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeBeforeCreateChildAssociation(NodeRef parentNodeRef, NodeRef childNodeRef, QName assocTypeQName, QName assocQName) {
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.BeforeCreateChildAssociationPolicy policy = this.beforeCreateChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.beforeCreateChildAssociation(parentNodeRef, childNodeRef, assocTypeQName, assocQName);
    }

    protected void invokeOnCreateChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.OnCreateChildAssociationPolicy policy = this.onCreateChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.onCreateChildAssociation(childAssocRef);
    }

    protected void invokeBeforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.BeforeDeleteChildAssociationPolicy policy = this.beforeDeleteChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.beforeDeleteChildAssociation(childAssocRef);
    }

    protected void invokeOnDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.OnDeleteChildAssociationPolicy policy = this.onDeleteChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.onDeleteChildAssociation(childAssocRef);
    }

    protected void invokeOnCreateAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceNodeRef = nodeAssocRef.getSourceRef();
        QName assocTypeQName = nodeAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(sourceNodeRef);
        NodeServicePolicies.OnCreateAssociationPolicy policy = this.onCreateAssociationDelegate.get(sourceNodeRef, qnames, assocTypeQName);
        policy.onCreateAssociation(nodeAssocRef);
    }

    protected void invokeOnDeleteAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceNodeRef = nodeAssocRef.getSourceRef();
        QName assocTypeQName = nodeAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(sourceNodeRef);
        NodeServicePolicies.OnDeleteAssociationPolicy policy = this.onDeleteAssociationDelegate.get(sourceNodeRef, qnames, assocTypeQName);
        policy.onDeleteAssociation(nodeAssocRef);
    }

    protected Set<QName> getTypeAndAspectQNames(NodeRef nodeRef) {
        Set<QName> qnames = null;
        try {
            Set<QName> aspectQNames = this.getAspects(nodeRef);
            QName typeQName = this.getType(nodeRef);
            qnames = new HashSet<QName>(aspectQNames.size() + 1);
            qnames.addAll(aspectQNames);
            qnames.add(typeQName);
        }
        catch (InvalidNodeRefException e) {
            qnames = Collections.emptySet();
        }
        return qnames;
    }

    protected String generateGuid(Map<QName, Serializable> preCreationProperties) {
        String uuid = (String)((Object)preCreationProperties.get(ContentModel.PROP_NODE_UUID));
        if (uuid == null) {
            uuid = GUID.generate();
        } else {
            preCreationProperties.remove(ContentModel.PROP_NODE_UUID);
        }
        return uuid;
    }

    protected void removeReferencableProperties(Map<QName, Serializable> properties) {
        properties.remove(ContentModel.PROP_STORE_PROTOCOL);
        properties.remove(ContentModel.PROP_STORE_IDENTIFIER);
        properties.remove(ContentModel.PROP_NODE_UUID);
        properties.remove(ContentModel.PROP_NODE_DBID);
    }

    protected void addReferencableProperties(NodeRef nodeRef, Long nodeDbId, Map<QName, Serializable> properties) {
        properties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
        properties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        properties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)nodeRef.getId()));
        properties.put(ContentModel.PROP_NODE_DBID, nodeDbId);
        if (properties.get(ContentModel.PROP_NAME) == null) {
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeRef.getId()));
        }
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    @Override
    public final List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    protected PropertyValue makePropertyValue(PropertyDefinition propertyDef, Serializable value) {
        QName propertyTypeQName = null;
        if (propertyDef == null) {
            propertyTypeQName = DataTypeDefinition.ANY;
        } else {
            propertyTypeQName = propertyDef.getDataType().getName();
            boolean isMultiValued = propertyDef.isMultiValued();
            if (isMultiValued && !(value instanceof Collection)) {
                if (value != null) {
                    value = (Serializable)((Object)Collections.singletonList(value));
                }
            } else if (!isMultiValued && value instanceof Collection && !propertyTypeQName.equals(DataTypeDefinition.ANY)) {
                throw new DictionaryException("A single-valued property of this type may not be a collection: \n   Property: " + propertyDef + "\n" + "   Type: " + propertyTypeQName + "\n" + "   Value: " + value);
            }
        }
        try {
            PropertyValue propertyValue = new PropertyValue(propertyTypeQName, value);
            return propertyValue;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   value: " + value + "\n" + "   value type: " + value.getClass(), e);
        }
    }

    protected Serializable makeSerializableValue(PropertyDefinition propertyDef, PropertyValue propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        QName propertyTypeQName = null;
        propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        try {
            Serializable value = propertyValue.getValue(propertyTypeQName);
            return value;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   property value: " + propertyValue, e);
        }
    }
}

