/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.domain.hibernate.NodeImpl;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.hibernate.Session;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNodeServiceTest
extends BaseSpringTest {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "content");
    public static final QName TYPE_QNAME_TEST_MANY_PROPERTIES = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "many-properties");
    public static final QName TYPE_QNAME_EXTENDED_CONTENT = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "extendedcontent");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "titled");
    public static final QName ASPECT_QNAME_TEST_MARKER = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "marker");
    public static final QName ASPECT_QNAME_TEST_MARKER2 = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "marker2");
    public static final QName ASPECT_QNAME_MANDATORY = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "mandatoryaspect");
    public static final QName ASPECT_QNAME_WITH_DEFAULT_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "withDefaultValue");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "title");
    public static final QName PROP_QNAME_TEST_CONTENT = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "content");
    public static final QName PROP_QNAME_BOOLEAN_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "booleanValue");
    public static final QName PROP_QNAME_INTEGER_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "integerValue");
    public static final QName PROP_QNAME_LONG_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "longValue");
    public static final QName PROP_QNAME_FLOAT_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "floatValue");
    public static final QName PROP_QNAME_DOUBLE_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "doubleValue");
    public static final QName PROP_QNAME_STRING_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "stringValue");
    public static final QName PROP_QNAME_DATE_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "dateValue");
    public static final QName PROP_QNAME_SERIALIZABLE_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "serializableValue");
    public static final QName PROP_QNAME_NODEREF_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "nodeRefValue");
    public static final QName PROP_QNAME_QNAME_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "qnameValue");
    public static final QName PROP_QNAME_CONTENT_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "contentValue");
    public static final QName PROP_QNAME_PATH_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "pathValue");
    public static final QName PROP_QNAME_CATEGORY_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "categoryValue");
    public static final QName PROP_QNAME_NULL_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "nullValue");
    public static final QName PROP_QNAME_MULTI_VALUE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "multiValue");
    public static final QName PROP_QNAME_PROP1 = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "prop1");
    public static final QName PROP_QNAME_PROP2 = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "prop2");
    public static final QName ASSOC_TYPE_QNAME_TEST_CHILDREN = ContentModel.ASSOC_CHILDREN;
    public static final QName ASSOC_TYPE_QNAME_TEST_NEXT = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "next");
    public static final QName TYPE_QNAME_TEST_MULTIPLE_TESTER = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "multiple-tester");
    public static final QName PROP_QNAME_STRING_PROP_SINGLE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "stringprop-single");
    public static final QName PROP_QNAME_STRING_PROP_MULTIPLE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "stringprop-multiple");
    public static final QName PROP_QNAME_ANY_PROP_SINGLE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "anyprop-single");
    public static final QName PROP_QNAME_ANY_PROP_MULTIPLE = QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "anyprop-multiple");
    protected PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;
    protected NodeDaoService nodeDaoService;
    protected NodeService nodeService;
    protected NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        this.dictionaryService = BaseNodeServiceTest.loadModel((ApplicationContext)this.applicationContext);
        this.nodeService = this.getNodeService();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
    }

    protected void onTearDownInTransaction() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onTearDownInTransaction();
    }

    public static DictionaryService loadModel(ApplicationContext applicationContext) {
        DictionaryDAO dictionaryDao = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        BaseNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        return dictionary;
    }

    protected abstract NodeService getNodeService();

    public void testSetUp() throws Exception {
        BaseNodeServiceTest.assertNotNull((String)"StoreService not set", (Object)this.nodeService);
        BaseNodeServiceTest.assertNotNull((String)"NodeService not set", (Object)this.nodeService);
        BaseNodeServiceTest.assertNotNull((String)"rootNodeRef not created", (Object)this.rootNodeRef);
    }

    public Map<QName, ChildAssociationRef> buildNodeGraph() throws Exception {
        return BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
    }

    public static Map<QName, ChildAssociationRef> buildNodeGraph(NodeService nodeService, NodeRef rootNodeRef) throws Exception {
        String ns = NAMESPACE;
        QName qname = null;
        ChildAssociationRef assoc = null;
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        HashMap<QName, ChildAssociationRef> ret = new HashMap<QName, ChildAssociationRef>(13);
        qname = QName.createQName(ns, "root_p_n1");
        assoc = nodeService.createNode(rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n1 = assoc.getChildRef();
        qname = QName.createQName(ns, "root_p_n2");
        assoc = nodeService.createNode(rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n2 = assoc.getChildRef();
        properties.clear();
        properties.put(QName.createQName(ns, "animal"), (Serializable)((Object)"monkey"));
        properties.put(QName.createQName(ns, "UPPERANIMAL"), (Serializable)((Object)"MONKEY"));
        properties.put(QName.createQName(ns, "reference"), (Serializable)((Object)n2.toString()));
        properties.put(QName.createQName(ns, "text1"), (Serializable)((Object)"bun"));
        properties.put(QName.createQName(ns, "text2"), (Serializable)((Object)"cake"));
        properties.put(QName.createQName(ns, "text3"), (Serializable)((Object)"biscuit"));
        properties.put(QName.createQName(ns, "text12"), (Serializable)((Object)"bun, cake"));
        properties.put(QName.createQName(ns, "text13"), (Serializable)((Object)"bun, biscuit"));
        properties.put(QName.createQName(ns, "text23"), (Serializable)((Object)"cake, biscuit"));
        properties.put(QName.createQName(ns, "text123"), (Serializable)((Object)"bun, cake, biscuit"));
        ArrayList<String> slist = new ArrayList<String>();
        slist.add("first");
        slist.add("second");
        slist.add("third");
        properties.put(QName.createQName(ns, "mvp"), slist);
        ArrayList<Integer> ilist = new ArrayList<Integer>();
        ilist.add(new Integer(1));
        ilist.add(new Integer(2));
        ilist.add(new Integer(3));
        properties.put(QName.createQName(ns, "mvi"), ilist);
        qname = QName.createQName(ns, "n1_p_n3");
        assoc = nodeService.createNode(n1, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER, properties);
        ret.put(qname, assoc);
        NodeRef n3 = assoc.getChildRef();
        qname = QName.createQName(ns, "n2_p_n4");
        assoc = nodeService.createNode(n2, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n4 = assoc.getChildRef();
        qname = QName.createQName(ns, "n1_n4");
        assoc = nodeService.addChild(n1, n4, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        qname = QName.createQName(ns, "n2_p_n5");
        assoc = nodeService.createNode(n2, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n5 = assoc.getChildRef();
        qname = QName.createQName(ns, "n3_p_n6");
        assoc = nodeService.createNode(n3, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n6 = assoc.getChildRef();
        nodeService.addAspect(n6, ContentModel.ASPECT_ROOT, Collections.<QName, Serializable>emptyMap());
        qname = QName.createQName(ns, "n4_n6");
        assoc = nodeService.addChild(n4, n6, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        qname = QName.createQName(ns, "n5_p_n7");
        assoc = nodeService.createNode(n5, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
        ret.put(qname, assoc);
        NodeRef n7 = assoc.getChildRef();
        properties.clear();
        properties.put(PROP_QNAME_TEST_CONTENT, new ContentData(null, "text/plain", 0L, null));
        properties.put(PROP_QNAME_TEST_TITLE, (Serializable)((Object)"node8"));
        qname = QName.createQName(ns, "n6_p_n8");
        assoc = nodeService.createNode(n6, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, TYPE_QNAME_TEST_CONTENT, properties);
        ret.put(qname, assoc);
        NodeRef n8 = assoc.getChildRef();
        qname = QName.createQName(ns, "n7_n8");
        assoc = nodeService.addChild(n7, n8, ASSOC_TYPE_QNAME_TEST_CHILDREN, qname);
        ret.put(qname, assoc);
        return ret;
    }

    private int countNodesByReference(NodeRef nodeRef) {
        String query = "select count(node.uuid) from " + NodeImpl.class.getName() + " node" + " where" + "    node.uuid = ? and" + "    node.store.key.protocol = ? and" + "    node.store.key.identifier = ?";
        Session session = this.getSession();
        List results = session.createQuery(query).setString(0, nodeRef.getId()).setString(1, nodeRef.getStoreRef().getProtocol()).setString(2, nodeRef.getStoreRef().getIdentifier()).list();
        Integer count = (Integer)results.get(0);
        return count;
    }

    private StoreRef createStore() throws Exception {
        StoreRef storeRef = this.nodeService.createStore("workspace", this.getName() + "_" + System.nanoTime());
        BaseNodeServiceTest.assertNotNull((String)"No reference returned", (Object)storeRef);
        return storeRef;
    }

    public void testCreateStore() throws Exception {
        StoreRef storeRef = this.createStore();
        BaseNodeServiceTest.assertTrue((String)"NodeService reports that store doesn't exist", (boolean)this.nodeService.exists(storeRef));
        NodeRef storeRootNode = this.nodeService.getRootNode(storeRef);
        boolean isRoot = this.nodeService.hasAspect(storeRootNode, ContentModel.ASPECT_ROOT);
        BaseNodeServiceTest.assertTrue((String)"Root node of store does not have root aspect", (boolean)isRoot);
        QName rootType = this.nodeService.getType(storeRootNode);
        BaseNodeServiceTest.assertEquals((String)"Store root node of incorrect type", (Object)ContentModel.TYPE_STOREROOT, (Object)rootType);
    }

    public void testGetStores() throws Exception {
        StoreRef storeRef = this.createStore();
        List<StoreRef> storeRefs = this.nodeService.getStores();
        BaseNodeServiceTest.assertTrue((String)"New store not present is list of stores", (boolean)storeRefs.contains(storeRef));
    }

    public void testExists() throws Exception {
        StoreRef storeRef = this.createStore();
        boolean exists = this.nodeService.exists(storeRef);
        BaseNodeServiceTest.assertEquals((String)"Exists failed", (boolean)true, (boolean)exists);
        StoreRef bogusRef = new StoreRef("What", "the");
        exists = this.nodeService.exists(bogusRef);
        BaseNodeServiceTest.assertEquals((String)"Exists failed", (boolean)false, (boolean)exists);
    }

    public void testGetRootNode() throws Exception {
        StoreRef storeRef = this.createStore();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        BaseNodeServiceTest.assertNotNull((String)"No root node reference returned", (Object)rootNodeRef);
        NodeRef rootNodeRefCheck = this.nodeService.getRootNode(storeRef);
        BaseNodeServiceTest.assertEquals((String)"Root nodes returned different refs", (Object)rootNodeRef, (Object)rootNodeRefCheck);
    }

    public void testCreateNode() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER);
        BaseNodeServiceTest.assertEquals((String)"Assoc type qname not set", (Object)ASSOC_TYPE_QNAME_TEST_CHILDREN, (Object)assocRef.getTypeQName());
        BaseNodeServiceTest.assertEquals((String)"Assoc qname not set", (Object)QName.createQName("pathA"), (Object)assocRef.getQName());
        NodeRef childRef = assocRef.getChildRef();
        QName checkType = this.nodeService.getType(childRef);
        BaseNodeServiceTest.assertEquals((String)"Child node type incorrect", (Object)ContentModel.TYPE_CONTAINER, (Object)checkType);
    }

    public void testCreateNodeWithId() throws Exception {
        String uuid = GUID.generate();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        properties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)uuid));
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER, properties);
        NodeRef expectedNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), uuid);
        NodeRef checkNodeRef = assocRef.getChildRef();
        BaseNodeServiceTest.assertEquals((String)"Failed to create node with a chosen ID", (Object)expectedNodeRef, (Object)checkNodeRef);
    }

    public void testGetType() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        QName type = this.nodeService.getType(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Type mismatch", (Object)ContentModel.TYPE_CONTAINER, (Object)type);
    }

    public void testSetType() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("setTypeTest"), TYPE_QNAME_TEST_CONTENT).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)TYPE_QNAME_TEST_CONTENT, (Object)this.nodeService.getType(nodeRef));
        this.nodeService.setType(nodeRef, TYPE_QNAME_EXTENDED_CONTENT);
        BaseNodeServiceTest.assertEquals((Object)TYPE_QNAME_EXTENDED_CONTENT, (Object)this.nodeService.getType(nodeRef));
    }

    protected void fillProperties(QName qname, Map<QName, Serializable> properties) {
        ClassDefinition classDef = this.dictionaryService.getClass(qname);
        if (classDef == null) {
            throw new RuntimeException("No such class: " + qname);
        }
        Map<QName, PropertyDefinition> propertyDefs = classDef.getProperties();
        for (QName propertyName : propertyDefs.keySet()) {
            Long value = new Long(System.currentTimeMillis());
            properties.put(propertyName, value);
        }
    }

    public void testAspects() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(NAMESPACE, "test-container"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(20);
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        Map<QName, Serializable> propertiesBefore = this.nodeService.getProperties(nodeRef);
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, properties);
        Map<QName, Serializable> propertiesAfter = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Aspect properties not added", (int)(propertiesBefore.size() + 2), (int)propertiesAfter.size());
        Set<QName> aspects = this.nodeService.getAspects(nodeRef);
        BaseNodeServiceTest.assertTrue((String)"Titled aspect not present", (boolean)aspects.contains(ASPECT_QNAME_TEST_TITLED));
        boolean hasAspect = this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        BaseNodeServiceTest.assertTrue((String)"Aspect not confirmed to be on node", (boolean)hasAspect);
        this.nodeService.removeAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        hasAspect = this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED);
        BaseNodeServiceTest.assertFalse((String)"Aspect not removed from node", (boolean)hasAspect);
        propertiesAfter = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Aspect properties not removed", (int)propertiesBefore.size(), (int)propertiesAfter.size());
    }

    public void testCreateNodeNoProperties() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("path1"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        int count = this.countNodesByReference(nodeRef);
        BaseNodeServiceTest.assertEquals((String)"Unexpected number of nodes present", (int)1, (int)count);
    }

    public void testCreateNodeWithProperties() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(TYPE_QNAME_TEST_CONTENT, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("MyContent"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef nodeRef = assocRef.getChildRef();
        BaseNodeServiceTest.assertTrue((String)"Titled aspect not present", (boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
    }

    public void testCascadeDelete() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        NodeRef n3Ref = assocRefs.get(QName.createQName(NAMESPACE, "n1_p_n3")).getChildRef();
        NodeRef n4Ref = assocRefs.get(QName.createQName(NAMESPACE, "n2_p_n4")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName(NAMESPACE, "n3_p_n6")).getChildRef();
        NodeRef n7Ref = assocRefs.get(QName.createQName(NAMESPACE, "n5_p_n7")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        BaseNodeServiceTest.assertEquals((String)"n6 not present", (int)1, (int)this.countNodesByReference(n6Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 not present", (int)1, (int)this.countNodesByReference(n8Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 primary parent association not present on n3", (int)1, (int)this.countChildrenOfNode(n3Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 secondary parent association not present on n4", (int)1, (int)this.countChildrenOfNode(n4Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 secondary parent association not present on n7", (int)1, (int)this.countChildrenOfNode(n7Ref));
        this.nodeService.deleteNode(n6Ref);
        this.setComplete();
        this.endTransaction();
        BaseNodeServiceTest.assertEquals((String)"n6 not directly deleted", (int)0, (int)this.countNodesByReference(n6Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 not cascade deleted", (int)0, (int)this.countNodesByReference(n8Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 primary parent association not removed from n3", (int)0, (int)this.countChildrenOfNode(n3Ref));
        BaseNodeServiceTest.assertEquals((String)"n6 secondary parent association not removed from n4", (int)0, (int)this.countChildrenOfNode(n4Ref));
        BaseNodeServiceTest.assertEquals((String)"n8 secondary parent association not removed from n7", (int)0, (int)this.countChildrenOfNode(n7Ref));
    }

    public void testDelete() throws Exception {
        ArrayList<NodeRef> deletedNodeRefs = new ArrayList<NodeRef>(5);
        BadOnDeleteNodePolicy policy = new BadOnDeleteNodePolicy(this.nodeService, deletedNodeRefs);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteNode"), policy, (Behaviour)new JavaBehaviour(policy, "onDeleteNode"));
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        NodeRef n1Ref = assocRefs.get(QName.createQName(NAMESPACE, "root_p_n1")).getChildRef();
        NodeRef n3Ref = assocRefs.get(QName.createQName(NAMESPACE, "n1_p_n3")).getChildRef();
        NodeRef n4Ref = assocRefs.get(QName.createQName(NAMESPACE, "n2_p_n4")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName(NAMESPACE, "n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        this.nodeService.deleteNode(n1Ref);
        BaseNodeServiceTest.assertEquals((String)"Node not directly deleted", (int)0, (int)this.countNodesByReference(n1Ref));
        BaseNodeServiceTest.assertEquals((String)"Node not cascade deleted", (int)0, (int)this.countNodesByReference(n3Ref));
        BaseNodeServiceTest.assertEquals((String)"Node incorrectly cascade deleted", (int)1, (int)this.countNodesByReference(n4Ref));
        BaseNodeServiceTest.assertEquals((String)"Node not cascade deleted", (int)0, (int)this.countNodesByReference(n6Ref));
        BaseNodeServiceTest.assertEquals((String)"Node not cascade deleted", (int)0, (int)this.countNodesByReference(n8Ref));
        this.setComplete();
        this.endTransaction();
    }

    private int countChildrenOfNode(NodeRef nodeRef) {
        String query = "select node.childAssocs from " + NodeImpl.class.getName() + " node" + " where node.uuid = ? and node.store.key.protocol = ? and node.store.key.identifier = ?";
        Session session = this.getSession();
        List results = session.createQuery(query).setString(0, nodeRef.getId()).setString(1, nodeRef.getStoreRef().getProtocol()).setString(2, nodeRef.getStoreRef().getIdentifier()).list();
        int count = results.size();
        return count;
    }

    public void testAddBogusChild() throws Exception {
        NodeRef bogusChildRef = new NodeRef(this.rootNodeRef.getStoreRef(), "BOGUS");
        try {
            this.nodeService.addChild(this.rootNodeRef, bogusChildRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("BOGUS_PATH"));
            BaseNodeServiceTest.fail((String)"Failed to detect invalid child node reference");
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            // empty catch block
        }
    }

    public void testAddChild() throws Exception {
        NodeRef childNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER).getChildRef();
        int countBefore = this.countChildrenOfNode(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((String)"Root children count incorrect", (int)1, (int)countBefore);
        this.nodeService.addChild(this.rootNodeRef, childNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathB"));
        int countAfter = this.countChildrenOfNode(this.rootNodeRef);
        BaseNodeServiceTest.assertEquals((String)"Root children count incorrect", (int)2, (int)countAfter);
        try {
            this.nodeService.addChild(childNodeRef, this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("backToRoot"));
            BaseNodeServiceTest.fail((String)"Failed to detect cyclic child relationship during addition of child");
        }
        catch (CyclicChildRelationshipException e) {
            // empty catch block
        }
    }

    public void testRemoveChildByRef() throws Exception {
        NodeRef parentRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("parent_child"), ContentModel.TYPE_CONTAINER).getChildRef();
        ChildAssociationRef pathARef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER);
        NodeRef childARef = pathARef.getChildRef();
        ChildAssociationRef pathBRef = this.nodeService.addChild(parentRef, childARef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathB"));
        ChildAssociationRef pathCRef = this.nodeService.addChild(parentRef, childARef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathC"));
        AssociationRef pathDRef = this.nodeService.createAssociation(parentRef, childARef, ASSOC_TYPE_QNAME_TEST_NEXT);
        this.nodeService.removeChild(parentRef, childARef);
        BaseNodeServiceTest.assertFalse((String)"Primary child not deleted", (boolean)this.nodeService.exists(childARef));
        BaseNodeServiceTest.assertEquals((String)"Child assocs not removed", (int)0, (int)this.nodeService.getChildAssocs(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, new RegexQNamePattern(".*", "path*")).size());
        BaseNodeServiceTest.assertEquals((String)"Node assoc not removed", (int)0, (int)this.nodeService.getTargetAssocs(parentRef, RegexQNamePattern.MATCH_ALL).size());
    }

    public void testAddAndRemoveChild() throws Exception {
        ChildAssociationRef pathARef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER);
        NodeRef childRef = pathARef.getChildRef();
        this.nodeService.addChild(this.rootNodeRef, pathARef.getChildRef(), pathARef.getTypeQName(), pathARef.getQName());
        this.nodeService.removeChild(this.rootNodeRef, childRef);
    }

    public void testProperties() throws Exception {
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("playThing"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = assocRef.getChildRef();
        QName qnameProperty1 = QName.createQName("PROPERTY1");
        String valueProperty1 = "VALUE1";
        QName qnameProperty2 = QName.createQName("PROPERTY2");
        String valueProperty2 = "VALUE2";
        QName qnameProperty3 = QName.createQName("PROPERTY3");
        QName qnameProperty4 = QName.createQName("PROPERTY4");
        Map<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        properties.put(qnameProperty1, (Serializable)((Object)valueProperty1));
        this.nodeService.setProperties(nodeRef, properties);
        this.nodeService.setProperty(nodeRef, qnameProperty2, (Serializable)((Object)valueProperty2));
        this.nodeService.setProperty(nodeRef, qnameProperty3, null);
        this.nodeService.setProperty(nodeRef, qnameProperty4, (Serializable)((Object)TestEnum.TEST_ONE));
        this.getSession().flush();
        this.getSession().clear();
        AlfrescoTransactionSupport.flush();
        Map<QName, Serializable> checkMap = this.nodeService.getProperties(nodeRef);
        BaseNodeServiceTest.assertNotNull((String)"Properties were not set/retrieved", checkMap);
        BaseNodeServiceTest.assertNotNull((String)"Name property not set automatically", (Object)checkMap.get(ContentModel.PROP_NAME));
        BaseNodeServiceTest.assertEquals((String)"Name property to set to ID of node", (Object)nodeRef.getId(), (Object)checkMap.get(ContentModel.PROP_NAME));
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)valueProperty1, (Object)checkMap.get(qnameProperty1));
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)valueProperty2, (Object)checkMap.get(qnameProperty2));
        BaseNodeServiceTest.assertTrue((String)"Null property not persisted", (boolean)checkMap.containsKey(qnameProperty3));
        BaseNodeServiceTest.assertNull((String)"Null value not persisted correctly", (Object)checkMap.get(qnameProperty3));
        BaseNodeServiceTest.assertEquals((String)"Enum property not retrieved", (Object)((Object)TestEnum.TEST_ONE), (Object)checkMap.get(qnameProperty4));
        Serializable valueCheck = this.nodeService.getProperty(nodeRef, qnameProperty2);
        BaseNodeServiceTest.assertNotNull((String)"Property value not set", (Object)valueCheck);
        BaseNodeServiceTest.assertEquals((String)"Property value incorrect", (Object)"VALUE2", (Object)valueCheck);
        try {
            this.nodeService.setProperty(nodeRef, qnameProperty2, null);
        }
        catch (IllegalArgumentException e) {
            BaseNodeServiceTest.fail((String)"Null property values are allowed");
        }
        try {
            properties = this.nodeService.getProperties(nodeRef);
            properties.put(qnameProperty1, null);
            this.nodeService.setProperties(nodeRef, properties);
        }
        catch (IllegalArgumentException e) {
            BaseNodeServiceTest.fail((String)"Null property values are allowed in the map");
        }
    }

    public void testSerializableProperties() throws Exception {
        ContentData contentData = new ContentData(null, null, 0L, null);
        QName qname = PROP_QNAME_CONTENT_VALUE;
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(17);
        properties.put(PROP_QNAME_CONTENT_VALUE, contentData);
        properties.put(PROP_QNAME_SERIALIZABLE_VALUE, qname);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), ContentModel.TYPE_CONTAINER, properties).getChildRef();
        this.flushAndClear();
        Map<QName, Serializable> checkProperties = this.nodeService.getProperties(nodeRef);
        Serializable checkPropertyContentData = checkProperties.get(PROP_QNAME_CONTENT_VALUE);
        Serializable checkPropertyQname = checkProperties.get(PROP_QNAME_SERIALIZABLE_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Serialization/deserialization of ContentData failed", (boolean)(checkPropertyContentData instanceof ContentData));
        BaseNodeServiceTest.assertTrue((String)"Serialization/deserialization failed", (boolean)(checkPropertyQname instanceof QName));
    }

    public void testMultiProp() throws Exception {
        QName undeclaredPropQName = QName.createQName(NAMESPACE, this.getName());
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), TYPE_QNAME_TEST_MULTIPLE_TESTER).getChildRef();
        this.setComplete();
        this.endTransaction();
        ArrayList<String> values = new ArrayList<String>(1);
        values.add("ABC");
        values.add("DEF");
        this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, (Serializable)((Object)"ABC"));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, values);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, (Serializable)((Object)"ABC"));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, values);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
        this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
        this.nodeService.setProperty(nodeRef, undeclaredPropQName, (Serializable)((Object)"ABC"));
        this.nodeService.setProperty(nodeRef, undeclaredPropQName, values);
        try {
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, values);
        }
        catch (DictionaryException e) {
            // empty catch block
        }
    }

    public void testPropertyTypes() throws Exception {
        ArrayList<String> listProperty = new ArrayList<String>(2);
        listProperty.add("ABC");
        listProperty.add("DEF");
        Path pathProperty = new Path();
        pathProperty.append(new Path.SelfElement()).append(new Path.AttributeElement(TYPE_QNAME_TEST_CONTENT));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(17);
        properties.put(PROP_QNAME_BOOLEAN_VALUE, Boolean.valueOf(true));
        properties.put(PROP_QNAME_INTEGER_VALUE, Integer.valueOf(123));
        properties.put(PROP_QNAME_LONG_VALUE, Long.valueOf(123L));
        properties.put(PROP_QNAME_FLOAT_VALUE, Float.valueOf(123.0f));
        properties.put(PROP_QNAME_DOUBLE_VALUE, Double.valueOf(123.0));
        properties.put(PROP_QNAME_STRING_VALUE, (Serializable)((Object)"123.0"));
        properties.put(PROP_QNAME_DATE_VALUE, new Date());
        properties.put(PROP_QNAME_SERIALIZABLE_VALUE, (Serializable)((Object)"456"));
        properties.put(PROP_QNAME_NODEREF_VALUE, this.rootNodeRef);
        properties.put(PROP_QNAME_QNAME_VALUE, TYPE_QNAME_TEST_CONTENT);
        properties.put(PROP_QNAME_PATH_VALUE, pathProperty);
        properties.put(PROP_QNAME_CONTENT_VALUE, new ContentData("url", "text/plain", 88L, "UTF-8"));
        properties.put(PROP_QNAME_CATEGORY_VALUE, this.rootNodeRef);
        properties.put(PROP_QNAME_NULL_VALUE, null);
        properties.put(PROP_QNAME_MULTI_VALUE, listProperty);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pathA"), TYPE_QNAME_TEST_MANY_PROPERTIES, properties).getChildRef();
        this.flushAndClear();
        Map<QName, Serializable> checkProperties = this.nodeService.getProperties(nodeRef);
        for (QName qname : properties.keySet()) {
            Serializable value = (Serializable)properties.get(qname);
            Serializable checkValue = checkProperties.get(qname);
            BaseNodeServiceTest.assertEquals((String)("Property mismatch - " + qname), (Object)value, (Object)checkValue);
        }
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_VALUE, (Serializable)((Object)"GHI"));
        Serializable checkProperty = this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_VALUE);
        BaseNodeServiceTest.assertTrue((String)"Property not converted to a Collection", (boolean)(checkProperty instanceof Collection));
        BaseNodeServiceTest.assertTrue((String)"Collection doesn't contain value", (boolean)((Collection)((Object)checkProperty)).contains("GHI"));
    }

    public void testGetReferencableProperties() throws Exception {
        Serializable wsProtocol = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_STORE_PROTOCOL);
        Serializable wsIdentifier = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_STORE_IDENTIFIER);
        Serializable nodeUuid = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_UUID);
        Serializable nodeDbId = this.nodeService.getProperty(this.rootNodeRef, ContentModel.PROP_NODE_DBID);
        BaseNodeServiceTest.assertNotNull((String)"Workspace Protocol property not present", (Object)wsProtocol);
        BaseNodeServiceTest.assertNotNull((String)"Workspace Identifier property not present", (Object)wsIdentifier);
        BaseNodeServiceTest.assertNotNull((String)"Node UUID property not present", (Object)nodeUuid);
        BaseNodeServiceTest.assertNotNull((String)"Node DB ID property not present", (Object)nodeDbId);
        BaseNodeServiceTest.assertEquals((String)"Workspace Protocol property incorrect", (Object)this.rootNodeRef.getStoreRef().getProtocol(), (Object)wsProtocol);
        BaseNodeServiceTest.assertEquals((String)"Workspace Identifier property incorrect", (Object)this.rootNodeRef.getStoreRef().getIdentifier(), (Object)wsIdentifier);
        BaseNodeServiceTest.assertEquals((String)"Node UUID property incorrect", (Object)this.rootNodeRef.getId(), (Object)nodeUuid);
        Map<QName, Serializable> properties = this.nodeService.getProperties(this.rootNodeRef);
        BaseNodeServiceTest.assertTrue((String)"Workspace Protocol property not present in map", (boolean)properties.containsKey(ContentModel.PROP_STORE_PROTOCOL));
        BaseNodeServiceTest.assertTrue((String)"Workspace Identifier property not present in map", (boolean)properties.containsKey(ContentModel.PROP_STORE_IDENTIFIER));
        BaseNodeServiceTest.assertTrue((String)"Node UUID property not present in map", (boolean)properties.containsKey(ContentModel.PROP_NODE_UUID));
        BaseNodeServiceTest.assertTrue((String)"Node DB ID property not present in map", (boolean)properties.containsKey(ContentModel.PROP_NODE_DBID));
    }

    public void testGetParentAssocs() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n3pn6Ref = assocRefs.get(QName.createQName(NAMESPACE, "n3_p_n6"));
        ChildAssociationRef n5pn7Ref = assocRefs.get(QName.createQName(NAMESPACE, "n5_p_n7"));
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8"));
        ChildAssociationRef n7n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n7_n8"));
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        List<ChildAssociationRef> parentAssocs = this.nodeService.getParentAssocs(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of parents", (int)2, (int)parentAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)parentAssocs.contains(n6pn8Ref));
        BaseNodeServiceTest.assertTrue((String)"Expected assoc not found", (boolean)parentAssocs.contains(n7n8Ref));
        ChildAssociationRef primaryParentAssocCheck = this.nodeService.getPrimaryParent(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary parent assoc not retrieved", (Object)n6pn8Ref, (Object)primaryParentAssocCheck);
        ChildAssociationRef rootNodePrimaryAssoc = this.nodeService.getPrimaryParent(this.rootNodeRef);
        BaseNodeServiceTest.assertNull((String)"Expected null primary parent for root node", (Object)rootNodePrimaryAssoc.getParentRef());
        List<ChildAssociationRef> parentAssocRefsByQName = this.nodeService.getParentAssocs(n8Ref, RegexQNamePattern.MATCH_ALL, QName.createQName(NAMESPACE, "n7_n8"));
        BaseNodeServiceTest.assertEquals((String)"Expected to get exactly one match", (int)1, (int)parentAssocRefsByQName.size());
        List<ChildAssociationRef> childAssocRefsByTypeQName = this.nodeService.getChildAssocs(n8Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, RegexQNamePattern.MATCH_ALL);
    }

    public void testGetChildAssocs() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName(NAMESPACE, "root_p_n1")).getChildRef();
        ChildAssociationRef n1pn3Ref = assocRefs.get(QName.createQName(NAMESPACE, "n1_p_n3"));
        ChildAssociationRef n1n4Ref = assocRefs.get(QName.createQName(NAMESPACE, "n1_n4"));
        List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(n1Ref);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of children", (int)2, (int)childAssocRefs.size());
        BaseNodeServiceTest.assertEquals((String)"First child added to n1 was primary to n3: Order of refs is wrong", (Object)n1pn3Ref, (Object)childAssocRefs.get(0));
        BaseNodeServiceTest.assertEquals((String)"Second child added to n1 was to n4: Order of refs is wrong", (Object)n1n4Ref, (Object)childAssocRefs.get(1));
        this.nodeService.setChildAssociationIndex(n1pn3Ref, 1);
        this.nodeService.setChildAssociationIndex(n1n4Ref, 0);
        childAssocRefs = this.nodeService.getChildAssocs(n1Ref);
        BaseNodeServiceTest.assertEquals((String)"Order of refs is wrong", (Object)n1pn3Ref, (Object)childAssocRefs.get(1));
        BaseNodeServiceTest.assertEquals((String)"Order of refs is wrong", (Object)n1n4Ref, (Object)childAssocRefs.get(0));
        List<ChildAssociationRef> childAssocRefsByQName = this.nodeService.getChildAssocs(n1Ref, RegexQNamePattern.MATCH_ALL, QName.createQName(NAMESPACE, "n1_p_n3"));
        BaseNodeServiceTest.assertEquals((String)"Expected to get exactly one match", (int)1, (int)childAssocRefsByQName.size());
        List<ChildAssociationRef> childAssocRefsByTypeQName = this.nodeService.getChildAssocs(n1Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, RegexQNamePattern.MATCH_ALL);
    }

    public void testMoveNode() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n2pn4Ref = assocRefs.get(QName.createQName(NAMESPACE, "n2_p_n4"));
        ChildAssociationRef n5pn7Ref = assocRefs.get(QName.createQName(NAMESPACE, "n5_p_n7"));
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8"));
        NodeRef n4Ref = n2pn4Ref.getChildRef();
        NodeRef n5Ref = n5pn7Ref.getParentRef();
        NodeRef n6Ref = n6pn8Ref.getParentRef();
        NodeRef n8Ref = n6pn8Ref.getChildRef();
        ChildAssociationRef assocRef = this.nodeService.moveNode(n8Ref, n5Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(NAMESPACE, "n5_p_n8"));
        List<ChildAssociationRef> n6ChildRefs = this.nodeService.getChildAssocs(n6Ref, RegexQNamePattern.MATCH_ALL, QName.createQName(NAMESPACE, "n6_p_n8"));
        BaseNodeServiceTest.assertEquals((String)"Primary child assoc is still present", (int)0, (int)n6ChildRefs.size());
        ChildAssociationRef checkRef = this.nodeService.getPrimaryParent(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary assoc incorrent", (Object)assocRef, (Object)checkRef);
        try {
            this.nodeService.moveNode(n4Ref, n6Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(NAMESPACE, "n6_p_n4"));
            BaseNodeServiceTest.fail((String)"Failed to detect cyclic relationship during move");
        }
        catch (CyclicChildRelationshipException e) {
            // empty catch block
        }
    }

    private AssociationRef createAssociation() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(TYPE_QNAME_TEST_CONTENT, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, "N1"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef sourceRef = childAssocRef.getChildRef();
        childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, "N2"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef targetRef = childAssocRef.getChildRef();
        AssociationRef assocRef = this.nodeService.createAssociation(sourceRef, targetRef, ASSOC_TYPE_QNAME_TEST_NEXT);
        return assocRef;
    }

    public void testDuplicateAssociationDetection() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        try {
            this.nodeService.createAssociation(sourceRef, targetRef, qname);
            BaseNodeServiceTest.fail((String)"Duplicate assocation not detected");
        }
        catch (AssociationExistsException e) {
            // empty catch block
        }
    }

    public void testCreateAndRemoveAssociation() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(5);
        this.fillProperties(TYPE_QNAME_TEST_CONTENT, properties);
        this.fillProperties(ASPECT_QNAME_TEST_TITLED, properties);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName(null, "N3"), TYPE_QNAME_TEST_CONTENT, properties);
        NodeRef anotherTargetRef = childAssocRef.getChildRef();
        AssociationRef anotherAssocRef = this.nodeService.createAssociation(sourceRef, anotherTargetRef, ASSOC_TYPE_QNAME_TEST_NEXT);
        List<AssociationRef> assocs = this.nodeService.getTargetAssocs(sourceRef, ASSOC_TYPE_QNAME_TEST_NEXT);
        for (AssociationRef assoc : assocs) {
            this.nodeService.removeAssociation(assoc.getSourceRef(), assoc.getTargetRef(), assoc.getTypeQName());
        }
    }

    public void testGetTargetAssocs() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        List<AssociationRef> targetAssocs = this.nodeService.getTargetAssocs(sourceRef, qname);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of targets", (int)1, (int)targetAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Target not found", (boolean)targetAssocs.contains(assocRef));
    }

    public void testGetSourceAssocs() throws Exception {
        AssociationRef assocRef = this.createAssociation();
        NodeRef sourceRef = assocRef.getSourceRef();
        NodeRef targetRef = assocRef.getTargetRef();
        QName qname = assocRef.getTypeQName();
        List<AssociationRef> sourceAssocs = this.nodeService.getSourceAssocs(targetRef, qname);
        BaseNodeServiceTest.assertEquals((String)"Incorrect number of source assocs", (int)1, (int)sourceAssocs.size());
        BaseNodeServiceTest.assertTrue((String)"Source not found", (boolean)sourceAssocs.contains(assocRef));
    }

    public void testGetPath() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        Path path = this.nodeService.getPath(n8Ref);
        BaseNodeServiceTest.assertEquals((String)"Primary path incorrect", (String)"/{http://www.alfresco.org/test/BaseNodeServiceTest}root_p_n1/{http://www.alfresco.org/test/BaseNodeServiceTest}n1_p_n3/{http://www.alfresco.org/test/BaseNodeServiceTest}n3_p_n6/{http://www.alfresco.org/test/BaseNodeServiceTest}n6_p_n8", (String)path.toString());
    }

    public void testGetPaths() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName(NAMESPACE, "root_p_n1")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName(NAMESPACE, "n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        List<Path> paths = this.nodeService.getPaths(this.rootNodeRef, false);
        BaseNodeServiceTest.assertEquals((String)"Root node must have exactly 1 path", (int)1, (int)paths.size());
        Path rootPath = paths.toArray(new Path[1])[0];
        BaseNodeServiceTest.assertNotNull((String)"Root node path must have 1 element", (Object)rootPath.last());
        BaseNodeServiceTest.assertEquals((String)"Root node path must have 1 element", (Object)rootPath.first(), (Object)rootPath.last());
        paths = this.nodeService.getPaths(n8Ref, false);
        BaseNodeServiceTest.assertEquals((String)"Incorrect path count", (int)5, (int)paths.size());
        for (Path path : paths) {
            for (Path.Element element : path) {
                BaseNodeServiceTest.assertTrue((String)"Path element of incorrect type", (boolean)(element instanceof Path.ChildAssocElement));
                Path.ChildAssocElement childAssocElement = (Path.ChildAssocElement)element;
                ChildAssociationRef ref = childAssocElement.getRef();
                if (childAssocElement != path.first()) {
                    BaseNodeServiceTest.assertNotNull((String)"Parent node ref not set", (Object)ref.getParentRef());
                    BaseNodeServiceTest.assertNotNull((String)"QName not set", (Object)ref.getQName());
                }
                BaseNodeServiceTest.assertNotNull((String)"Child node ref not set", (Object)ref.getChildRef());
            }
        }
        paths = this.nodeService.getPaths(n8Ref, true);
        BaseNodeServiceTest.assertEquals((String)"Incorrect path count", (int)1, (int)paths.size());
        try {
            this.nodeService.addChild(n6Ref, n1Ref, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("n6_n1"));
            this.nodeService.getPaths(n6Ref, false);
            BaseNodeServiceTest.fail((String)"Cyclic relationship not detected");
        }
        catch (CyclicChildRelationshipException e) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
    }

    public void testPrimaryPathCascadeDelete() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        NodeRef n1Ref = assocRefs.get(QName.createQName(NAMESPACE, "root_p_n1")).getChildRef();
        NodeRef n6Ref = assocRefs.get(QName.createQName(NAMESPACE, "n3_p_n6")).getChildRef();
        NodeRef n8Ref = assocRefs.get(QName.createQName(NAMESPACE, "n6_p_n8")).getChildRef();
        this.nodeService.deleteNode(n1Ref);
        BaseNodeServiceTest.assertFalse((String)"n6 not cascade deleted", (boolean)this.nodeService.exists(n6Ref));
        BaseNodeServiceTest.assertFalse((String)"n8 not cascade deleted", (boolean)this.nodeService.exists(n8Ref));
    }

    public void testDefaultValues() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("testDefaultValues"), TYPE_QNAME_EXTENDED_CONTENT).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)"defaultValue", (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP1));
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_WITH_DEFAULT_VALUE, null);
        BaseNodeServiceTest.assertEquals((Object)"defaultValue", (Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_PROP2));
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
        props.put(PROP_QNAME_PROP1, (Serializable)((Object)"notDefaultValue"));
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("testDefaultValues"), TYPE_QNAME_EXTENDED_CONTENT, props).getChildRef();
        BaseNodeServiceTest.assertEquals((Object)"notDefaultValue", (Object)this.nodeService.getProperty(nodeRef2, PROP_QNAME_PROP1));
        HashMap<QName, Serializable> prop2 = new HashMap<QName, Serializable>(1);
        prop2.put(PROP_QNAME_PROP2, (Serializable)((Object)"notDefaultValue"));
        this.nodeService.addAspect(nodeRef2, ASPECT_QNAME_WITH_DEFAULT_VALUE, prop2);
        BaseNodeServiceTest.assertEquals((Object)"notDefaultValue", (Object)this.nodeService.getProperty(nodeRef2, PROP_QNAME_PROP2));
    }

    public void testMandatoryAspects() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("testDefaultValues"), TYPE_QNAME_TEST_CONTENT).getChildRef();
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_TITLED));
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_MANDATORY));
        this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_MARKER, null);
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER));
        BaseNodeServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_QNAME_TEST_MARKER2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void garbageCollect() throws Exception {
        for (int i = 0; i < 50; ++i) {
            Runtime.getRuntime().gc();
            BaseNodeServiceTest baseNodeServiceTest = this;
            synchronized (baseNodeServiceTest) {
                ((Object)((Object)this)).wait(20L);
                continue;
            }
        }
    }

    private void reportFlushPerformance(String msg, Map<QName, ChildAssociationRef> lastNodeGraph, int testCount, long startBytes, long startTime) throws Exception {
        long endTime = System.nanoTime();
        double deltaTime = (double)(endTime - startTime) / 1.0E9;
        System.out.println(msg + "\n" + "   Build and flushed " + testCount + " node graphs: \n" + "   total time: " + deltaTime + "s \n" + "   average: " + (double)testCount / deltaTime + " graphs/s");
        this.garbageCollect();
        long endBytes = Runtime.getRuntime().freeMemory();
        double diffBytes = startBytes - endBytes;
        System.out.println("   total bytes: " + diffBytes / 1024.0 / 1024.0 + " MB \n" + "   average: " + diffBytes / (double)testCount / 1024.0 + " kb/graph");
        int assocsPerGraph = lastNodeGraph.size();
        int nodesPerGraph = 0;
        for (ChildAssociationRef assoc : lastNodeGraph.values()) {
            if (!assoc.getQName().toString().contains("_p_")) continue;
            ++nodesPerGraph;
        }
        int totalAssocs = assocsPerGraph * testCount;
        int totalNodes = nodesPerGraph * testCount;
        System.out.println("   assocs per graph: " + assocsPerGraph + "\n" + "   nodes per graph: " + nodesPerGraph + "\n" + "   total nodes: " + totalNodes + "\n" + "   total assocs: " + totalAssocs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestEnum {
        TEST_ONE,
        TEST_TWO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BadOnDeleteNodePolicy
    implements NodeServicePolicies.OnDeleteNodePolicy,
    NodeServicePolicies.BeforeDeleteNodePolicy {
        private NodeService nodeService;
        private List<NodeRef> deletedNodeRefs;

        public BadOnDeleteNodePolicy(NodeService nodeService, List<NodeRef> deletedNodeRefs) {
            this.nodeService = nodeService;
            this.deletedNodeRefs = deletedNodeRefs;
        }

        @Override
        public void beforeDeleteNode(NodeRef nodeRef) {
            ChildAssociationRef assocRef = this.nodeService.createNode(nodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("pre-delete new child"), ContentModel.TYPE_CONTAINER);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_BOOLEAN_VALUE, (Serializable)((Object)"true"));
            this.nodeService.addAspect(nodeRef, ASPECT_QNAME_TEST_TITLED, null);
        }

        @Override
        public void onDeleteNode(ChildAssociationRef childAssocRef) {
            this.deletedNodeRefs.add(childAssocRef.getChildRef());
            NodeRef parentRef = childAssocRef.getParentRef();
            NodeRef childRef = childAssocRef.getChildRef();
            ChildAssociationRef assocRef = this.nodeService.createNode(parentRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("post-delete new child"), ContentModel.TYPE_CONTAINER);
        }
    }
}

