/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.ChildAssoc;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.NodeAssoc;
import org.alfresco.repo.domain.NodeStatus;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.node.AbstractNodeServiceImpl;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreExistsException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbNodeServiceImpl
extends AbstractNodeServiceImpl {
    private static Log logger = LogFactory.getLog(DbNodeServiceImpl.class);
    private DictionaryService dictionaryService;
    private NodeDaoService nodeDaoService;
    private StoreArchiveMap storeArchiveMap = new StoreArchiveMap();

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeDaoService(NodeDaoService nodeDaoService) {
        this.nodeDaoService = nodeDaoService;
    }

    public void setStoreArchiveMap(StoreArchiveMap storeArchiveMap) {
        this.storeArchiveMap = storeArchiveMap;
    }

    private Node getNodeNotNull(NodeRef nodeRef) throws InvalidNodeRefException {
        Node unchecked = this.nodeDaoService.getNode(nodeRef);
        if (unchecked == null) {
            throw new InvalidNodeRefException("Node does not exist: " + nodeRef, nodeRef);
        }
        return unchecked;
    }

    @Override
    public boolean exists(StoreRef storeRef) {
        Store store = this.nodeDaoService.getStore(storeRef.getProtocol(), storeRef.getIdentifier());
        boolean exists = store != null;
        return exists;
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        Node node = this.nodeDaoService.getNode(nodeRef);
        boolean exists = node != null;
        return exists;
    }

    @Override
    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        NodeStatus nodeStatus = this.nodeDaoService.getNodeStatus(nodeRef, false);
        if (nodeStatus == null) {
            return null;
        }
        return new NodeRef.Status(nodeStatus.getChangeTxnId(), nodeStatus.isDeleted());
    }

    @Override
    public List<StoreRef> getStores() {
        List<Store> stores = this.nodeDaoService.getStores();
        ArrayList<StoreRef> storeRefs = new ArrayList<StoreRef>(stores.size());
        for (Store store : stores) {
            storeRefs.add(store.getStoreRef());
        }
        return storeRefs;
    }

    @Override
    public StoreRef createStore(String protocol, String identifier) {
        StoreRef storeRef = new StoreRef(protocol, identifier);
        Store store = this.nodeDaoService.getStore(protocol, identifier);
        if (store != null) {
            throw new StoreExistsException("Unable to create a store that already exists: " + storeRef, storeRef);
        }
        this.invokeBeforeCreateStore(ContentModel.TYPE_STOREROOT, storeRef);
        store = this.nodeDaoService.createStore(protocol, identifier);
        Node rootNode = store.getRootNode();
        this.addAspect(rootNode.getNodeRef(), ContentModel.ASPECT_ROOT, Collections.<QName, Serializable>emptyMap());
        this.invokeOnCreateStore(rootNode.getNodeRef());
        if (!store.getStoreRef().equals(storeRef)) {
            throw new RuntimeException("Incorrect store reference");
        }
        return storeRef;
    }

    @Override
    public NodeRef getRootNode(StoreRef storeRef) throws InvalidStoreRefException {
        Store store = this.nodeDaoService.getStore(storeRef.getProtocol(), storeRef.getIdentifier());
        if (store == null) {
            throw new InvalidStoreRefException("Store does not exist", storeRef);
        }
        Node node = store.getRootNode();
        if (node == null) {
            throw new InvalidStoreRefException("Store does not have a root node", storeRef);
        }
        NodeRef nodeRef = node.getNodeRef();
        return nodeRef;
    }

    @Override
    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        return this.createNode(parentRef, assocTypeQName, assocQName, nodeTypeQName, null);
    }

    @Override
    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) {
        Assert.notNull((Object)parentRef);
        Assert.notNull((Object)assocTypeQName);
        Assert.notNull((Object)assocQName);
        properties = properties == null ? new HashMap<QName, Serializable>() : new HashMap<QName, Serializable>(properties);
        this.invokeBeforeUpdateNode(parentRef);
        this.invokeBeforeCreateNode(parentRef, assocTypeQName, assocQName, nodeTypeQName);
        StoreRef storeRef = parentRef.getStoreRef();
        Store store = this.nodeDaoService.getStore(storeRef.getProtocol(), storeRef.getIdentifier());
        if (store == null) {
            throw new RuntimeException("No store found for parent node: " + parentRef);
        }
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(nodeTypeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(nodeTypeQName);
        }
        String newId = this.generateGuid(properties);
        Node node = this.nodeDaoService.newNode(store, newId, nodeTypeQName);
        Node parentNode = this.getNodeNotNull(parentRef);
        ChildAssoc childAssoc = this.nodeDaoService.newChildAssoc(parentNode, node, true, assocTypeQName, assocQName);
        ChildAssociationRef childAssocRef = childAssoc.getChildAssocRef();
        this.addDefaultPropertyValues(nodeTypeDef, properties);
        this.addDefaultAspects(nodeTypeDef, node, childAssocRef.getChildRef(), properties);
        Map<QName, Serializable> propertiesBefore = this.getProperties(childAssocRef.getChildRef());
        Map<QName, Serializable> propertiesAfter = null;
        if (properties.size() > 0) {
            propertiesAfter = this.setPropertiesImpl(childAssocRef.getChildRef(), properties);
        }
        this.invokeOnCreateNode(childAssocRef);
        this.invokeOnUpdateNode(parentRef);
        if (propertiesAfter != null) {
            this.invokeOnUpdateProperties(childAssocRef.getChildRef(), propertiesBefore, propertiesAfter);
        }
        return childAssocRef;
    }

    private void addDefaultAspects(ClassDefinition classDefinition, Node node, NodeRef nodeRef, Map<QName, Serializable> properties) {
        List<AspectDefinition> defaultAspectDefs = classDefinition.getDefaultAspects();
        Set<QName> nodeAspects = node.getAspects();
        for (AspectDefinition defaultAspectDef : defaultAspectDefs) {
            this.invokeBeforeAddAspect(nodeRef, defaultAspectDef.getName());
            nodeAspects.add(defaultAspectDef.getName());
            this.addDefaultPropertyValues(defaultAspectDef, properties);
            this.invokeOnAddAspect(nodeRef, defaultAspectDef.getName());
            this.addDefaultAspects(defaultAspectDef, node, nodeRef, properties);
        }
    }

    private void addDefaultPropertyValues(ClassDefinition classDefinition, Map<QName, Serializable> properties) {
        for (Map.Entry<QName, Serializable> entry : classDefinition.getDefaultValues().entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            Serializable value = entry.getValue();
            PropertyDefinition prop = this.dictionaryService.getProperty(entry.getKey());
            if (prop == null) continue;
            if (DataTypeDefinition.BOOLEAN.equals(prop.getDataType().getName()) && value instanceof String) {
                if (((String)((Object)value)).toUpperCase().equals("TRUE")) {
                    value = Boolean.TRUE;
                } else if (((String)((Object)value)).toUpperCase().equals("FALSE")) {
                    value = Boolean.FALSE;
                }
            }
            properties.put(entry.getKey(), value);
        }
    }

    @Override
    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) throws InvalidNodeRefException {
        Assert.notNull((Object)nodeToMoveRef);
        Assert.notNull((Object)newParentRef);
        Assert.notNull((Object)assocTypeQName);
        Assert.notNull((Object)assocQName);
        Node nodeToMove = this.getNodeNotNull(nodeToMoveRef);
        Node newParentNode = this.getNodeNotNull(newParentRef);
        ChildAssoc oldAssoc = this.nodeDaoService.getPrimaryParentAssoc(nodeToMove);
        ChildAssociationRef oldAssocRef = oldAssoc.getChildAssocRef();
        Node oldParentNode = oldAssoc.getParent();
        boolean movingStore = !nodeToMoveRef.getStoreRef().equals(newParentRef.getStoreRef());
        QName nodeToMoveTypeQName = nodeToMove.getTypeQName();
        Set<QName> nodeToMoveAspects = nodeToMove.getAspects();
        if (movingStore) {
            this.invokeBeforeDeleteNode(nodeToMoveRef);
            this.invokeBeforeCreateNode(newParentRef, assocTypeQName, assocQName, nodeToMoveTypeQName);
        } else {
            this.invokeBeforeDeleteChildAssociation(oldAssocRef);
            this.invokeBeforeCreateChildAssociation(newParentRef, nodeToMoveRef, assocTypeQName, assocQName);
            this.invokeBeforeUpdateNode(oldParentNode.getNodeRef());
            this.invokeBeforeUpdateNode(newParentRef);
        }
        this.nodeDaoService.deleteChildAssoc(oldAssoc, false);
        ChildAssoc newAssoc = this.nodeDaoService.newChildAssoc(newParentNode, nodeToMove, true, assocTypeQName, assocQName);
        if (movingStore) {
            Store newStore = newParentNode.getStore();
            this.moveNodeToStore(nodeToMove, newStore);
            nodeToMoveRef = nodeToMove.getNodeRef();
        }
        this.getPaths(nodeToMoveRef, false);
        if (movingStore) {
            this.invokeOnDeleteNode(oldAssocRef, nodeToMoveTypeQName, nodeToMoveAspects);
            this.invokeOnCreateNode(newAssoc.getChildAssocRef());
        } else {
            this.invokeOnCreateChildAssociation(newAssoc.getChildAssocRef());
            this.invokeOnDeleteChildAssociation(oldAssoc.getChildAssocRef());
            this.invokeOnUpdateNode(oldParentNode.getNodeRef());
            this.invokeOnUpdateNode(newParentRef);
        }
        this.nodeDaoService.recordChangeId(nodeToMoveRef);
        return newAssoc.getChildAssocRef();
    }

    @Override
    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) {
        Node childNode;
        Node parentNode = this.getNodeNotNull(childAssocRef.getParentRef());
        ChildAssoc assoc = this.nodeDaoService.getChildAssoc(parentNode, childNode = this.getNodeNotNull(childAssocRef.getChildRef()), childAssocRef.getTypeQName(), childAssocRef.getQName());
        if (assoc == null) {
            throw new InvalidChildAssociationRefException("Unable to set child association index: \n   assoc: " + childAssocRef + "\n" + "   index: " + index, childAssocRef);
        }
        assoc.setIndex(index);
    }

    @Override
    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        return node.getTypeQName();
    }

    @Override
    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(typeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(typeQName);
        }
        this.invokeBeforeUpdateNode(nodeRef);
        Node node = this.getNodeNotNull(nodeRef);
        node.setTypeQName(typeQName);
        Map<QName, Serializable> properties = this.getProperties(nodeRef);
        this.addDefaultAspects(nodeTypeDef, node, nodeRef, properties);
        this.setProperties(nodeRef, properties);
        this.invokeOnUpdateNode(nodeRef);
    }

    @Override
    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new InvalidAspectException("The aspect is invalid: " + aspectTypeQName, aspectTypeQName);
        }
        this.invokeBeforeUpdateNode(nodeRef);
        this.invokeBeforeAddAspect(nodeRef, aspectTypeQName);
        Node node = this.getNodeNotNull(nodeRef);
        Map<QName, Serializable> nodeProperties = this.getProperties(nodeRef);
        if (aspectProperties != null) {
            nodeProperties.putAll(aspectProperties);
        }
        this.addDefaultPropertyValues(aspectDef, nodeProperties);
        this.addDefaultAspects(aspectDef, node, nodeRef, nodeProperties);
        this.setProperties(nodeRef, nodeProperties);
        if (node.getAspects().add(aspectTypeQName)) {
            this.invokeOnUpdateNode(nodeRef);
            this.invokeOnAddAspect(nodeRef, aspectTypeQName);
            this.nodeDaoService.recordChangeId(nodeRef);
        }
    }

    @Override
    public void removeAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        this.invokeBeforeUpdateNode(nodeRef);
        this.invokeBeforeRemoveAspect(nodeRef, aspectTypeQName);
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new InvalidAspectException(aspectTypeQName);
        }
        Node node = this.getNodeNotNull(nodeRef);
        boolean removed = node.getAspects().remove(aspectTypeQName);
        if (removed) {
            Map<QName, PropertyValue> nodeProperties = node.getProperties();
            Map<QName, PropertyDefinition> propertyDefs = aspectDef.getProperties();
            for (QName propertyName : propertyDefs.keySet()) {
                nodeProperties.remove(propertyName);
            }
            this.invokeOnUpdateNode(nodeRef);
            this.invokeOnRemoveAspect(nodeRef, aspectTypeQName);
            this.nodeDaoService.recordChangeId(nodeRef);
        }
    }

    @Override
    public boolean hasAspect(NodeRef nodeRef, QName aspectRef) throws InvalidNodeRefException, InvalidAspectException {
        Node node = this.getNodeNotNull(nodeRef);
        Set<QName> aspectQNames = node.getAspects();
        boolean hasAspect = aspectQNames.contains(aspectRef);
        return hasAspect;
    }

    @Override
    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        Set<QName> aspectQNames = node.getAspects();
        HashSet<QName> ret = new HashSet<QName>(aspectQNames.size());
        ret.addAll(aspectQNames);
        return ret;
    }

    @Override
    public void deleteNode(NodeRef nodeRef) {
        this.invokeBeforeDeleteNode(nodeRef);
        Node node = this.getNodeNotNull(nodeRef);
        ChildAssociationRef childAssocRef = this.getPrimaryParent(nodeRef);
        QName nodeTypeQName = node.getTypeQName();
        Set<QName> nodeAspectQNames = node.getAspects();
        StoreRef storeRef = nodeRef.getStoreRef();
        StoreRef archiveStoreRef = this.storeArchiveMap.getArchiveMap().get(storeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(node.getTypeQName());
        if (typeDef == null || !typeDef.isArchive() || archiveStoreRef == null) {
            this.nodeDaoService.deleteNode(node, true);
        } else {
            this.archiveNode(nodeRef, archiveStoreRef);
        }
        this.invokeOnDeleteNode(childAssocRef, nodeTypeQName, nodeAspectQNames);
    }

    @Override
    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName assocQName) {
        this.invokeBeforeUpdateNode(parentRef);
        this.invokeBeforeCreateChildAssociation(parentRef, childRef, assocTypeQName, assocQName);
        if (!parentRef.getStoreRef().equals(childRef.getStoreRef())) {
            throw new InvalidNodeRefException("Parent and child nodes must belong to the same store: \n   parent: " + parentRef + "\n" + "   child: " + childRef, childRef);
        }
        Node parentNode = this.getNodeNotNull(parentRef);
        Node childNode = this.getNodeNotNull(childRef);
        ChildAssoc assoc = this.nodeDaoService.newChildAssoc(parentNode, childNode, false, assocTypeQName, assocQName);
        ChildAssociationRef assocRef = assoc.getChildAssocRef();
        NodeRef childNodeRef = assocRef.getChildRef();
        this.getPaths(childNodeRef, false);
        this.invokeOnCreateChildAssociation(assocRef);
        this.invokeOnUpdateNode(parentRef);
        return assoc.getChildAssocRef();
    }

    @Override
    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        Node parentNode = this.getNodeNotNull(parentRef);
        Node childNode = this.getNodeNotNull(childRef);
        Long childNodeId = childNode.getId();
        ChildAssociationRef primaryAssocRef = null;
        Collection<ChildAssoc> assocs = parentNode.getChildAssocs();
        assocs = new HashSet<ChildAssoc>(assocs);
        for (ChildAssoc assoc : assocs) {
            if (!assoc.getChild().getId().equals(childNodeId)) continue;
            ChildAssociationRef assocRef = assoc.getChildAssocRef();
            if (assoc.getIsPrimary()) {
                primaryAssocRef = assocRef;
                continue;
            }
            this.invokeBeforeDeleteChildAssociation(assocRef);
            this.nodeDaoService.deleteChildAssoc(assoc, true);
            this.invokeOnDeleteChildAssociation(assocRef);
        }
        if (primaryAssocRef != null) {
            this.deleteNode(primaryAssocRef.getChildRef());
        }
        this.invokeOnUpdateNode(parentRef);
    }

    @Override
    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        Map<QName, PropertyValue> nodeProperties = node.getProperties();
        HashMap<QName, Serializable> ret = new HashMap<QName, Serializable>(nodeProperties.size());
        for (Map.Entry<QName, PropertyValue> entry : nodeProperties.entrySet()) {
            QName propertyQName = entry.getKey();
            PropertyValue propertyValue = entry.getValue();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            Serializable value = this.makeSerializableValue(propertyDef, propertyValue);
            ret.put(propertyQName, value);
        }
        this.addReferencableProperties(nodeRef, node.getId(), ret);
        return ret;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        if (qname.equals(ContentModel.PROP_STORE_PROTOCOL)) {
            return nodeRef.getStoreRef().getProtocol();
        }
        if (qname.equals(ContentModel.PROP_STORE_IDENTIFIER)) {
            return nodeRef.getStoreRef().getIdentifier();
        }
        if (qname.equals(ContentModel.PROP_NODE_UUID)) {
            return nodeRef.getId();
        }
        Node node = this.getNodeNotNull(nodeRef);
        if (qname.equals(ContentModel.PROP_NODE_DBID)) {
            return node.getId();
        }
        Map<QName, PropertyValue> properties = node.getProperties();
        PropertyValue propertyValue = properties.get(qname);
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
        Serializable value = this.makeSerializableValue(propertyDef, propertyValue);
        return value;
    }

    @Override
    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        this.invokeBeforeUpdateNode(nodeRef);
        Map<QName, Serializable> propertiesBefore = this.getProperties(nodeRef);
        Map<QName, Serializable> propertiesAfter = this.setPropertiesImpl(nodeRef, properties);
        this.invokeOnUpdateNode(nodeRef);
        this.invokeOnUpdateProperties(nodeRef, propertiesBefore, propertiesAfter);
    }

    private Map<QName, Serializable> setPropertiesImpl(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        if (properties == null) {
            throw new IllegalArgumentException("Properties may not be null");
        }
        this.removeReferencableProperties(properties);
        Node node = this.getNodeNotNull(nodeRef);
        Map<QName, PropertyValue> nodeProperties = node.getProperties();
        nodeProperties.clear();
        for (QName propertyQName : properties.keySet()) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            Serializable value = properties.get(propertyQName);
            PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
            nodeProperties.put(propertyQName, propertyValue);
        }
        this.nodeDaoService.recordChangeId(nodeRef);
        return Collections.unmodifiableMap(properties);
    }

    @Override
    public void setProperty(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        Assert.notNull((Object)qname);
        this.invokeBeforeUpdateNode(nodeRef);
        Map<QName, Serializable> propertiesBefore = this.getProperties(nodeRef);
        Map<QName, Serializable> propertiesAfter = this.setPropertyImpl(nodeRef, qname, value);
        this.invokeOnUpdateNode(nodeRef);
        this.invokeOnUpdateProperties(nodeRef, propertiesBefore, propertiesAfter);
    }

    public Map<QName, Serializable> setPropertyImpl(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        Map<QName, PropertyValue> properties = node.getProperties();
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
        PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
        properties.put(qname, propertyValue);
        this.nodeDaoService.recordChangeId(nodeRef);
        return this.getProperties(nodeRef);
    }

    public Collection<NodeRef> getParents(NodeRef nodeRef) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        Collection<ChildAssoc> parentAssocs = node.getParentAssocs();
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(parentAssocs.size());
        for (ChildAssoc assoc : parentAssocs) {
            Node parentNode = assoc.getParent();
            results.add(parentNode.getNodeRef());
        }
        return results;
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        Node node = this.getNodeNotNull(nodeRef);
        Collection<ChildAssoc> parentAssocs = node.getParentAssocs();
        if (parentAssocs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(parentAssocs.size());
        for (ChildAssoc assoc : parentAssocs) {
            if (!qnamePattern.isMatch(assoc.getQname()) || !typeQNamePattern.isMatch(assoc.getTypeQName())) continue;
            results.add(assoc.getChildAssocRef());
        }
        return results;
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        Node node = this.getNodeNotNull(nodeRef);
        Collection<ChildAssoc> childAssocs = node.getChildAssocs();
        if (childAssocs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ChildAssoc> orderedList = new ArrayList<ChildAssoc>(childAssocs);
        Collections.sort(orderedList);
        ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(childAssocs.size());
        int nthSibling = 0;
        for (ChildAssoc assoc : orderedList) {
            if (!qnamePattern.isMatch(assoc.getQname()) || !typeQNamePattern.isMatch(assoc.getTypeQName())) continue;
            ChildAssociationRef assocRef = assoc.getChildAssocRef();
            assocRef.setNthSibling(nthSibling);
            ++nthSibling;
            results.add(assoc.getChildAssocRef());
        }
        return results;
    }

    @Override
    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        ChildAssoc assoc = this.nodeDaoService.getPrimaryParentAssoc(node);
        ChildAssociationRef assocRef = null;
        assocRef = assoc == null ? new ChildAssociationRef(null, null, null, nodeRef) : assoc.getChildAssocRef();
        return assocRef;
    }

    @Override
    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        this.invokeBeforeUpdateNode(sourceRef);
        Node sourceNode = this.getNodeNotNull(sourceRef);
        Node targetNode = this.getNodeNotNull(targetRef);
        NodeAssoc assoc = this.nodeDaoService.getNodeAssoc(sourceNode, targetNode, assocTypeQName);
        if (assoc != null) {
            throw new AssociationExistsException(sourceRef, targetRef, assocTypeQName);
        }
        assoc = this.nodeDaoService.newNodeAssoc(sourceNode, targetNode, assocTypeQName);
        AssociationRef assocRef = assoc.getNodeAssocRef();
        this.invokeOnUpdateNode(sourceRef);
        this.invokeOnCreateAssociation(assocRef);
        return assocRef;
    }

    @Override
    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException {
        Node targetNode;
        Node sourceNode = this.getNodeNotNull(sourceRef);
        NodeAssoc assoc = this.nodeDaoService.getNodeAssoc(sourceNode, targetNode = this.getNodeNotNull(targetRef), assocTypeQName);
        if (assoc == null) {
            return;
        }
        AssociationRef assocRef = assoc.getNodeAssocRef();
        this.invokeBeforeUpdateNode(sourceRef);
        this.nodeDaoService.deleteNodeAssoc(assoc);
        this.invokeOnUpdateNode(sourceRef);
        this.invokeOnDeleteAssociation(assocRef);
    }

    @Override
    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) throws InvalidNodeRefException {
        Node sourceNode = this.getNodeNotNull(sourceRef);
        Collection<NodeAssoc> assocs = sourceNode.getTargetNodeAssocs();
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocs.size());
        for (NodeAssoc assoc : assocs) {
            if (!qnamePattern.isMatch(assoc.getTypeQName())) continue;
            nodeAssocRefs.add(assoc.getNodeAssocRef());
        }
        return nodeAssocRefs;
    }

    @Override
    public List<AssociationRef> getSourceAssocs(NodeRef targetRef, QNamePattern qnamePattern) throws InvalidNodeRefException {
        Node sourceNode = this.getNodeNotNull(targetRef);
        Collection<NodeAssoc> assocs = sourceNode.getSourceNodeAssocs();
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocs.size());
        for (NodeAssoc assoc : assocs) {
            if (!qnamePattern.isMatch(assoc.getTypeQName())) continue;
            nodeAssocRefs.add(assoc.getNodeAssocRef());
        }
        return nodeAssocRefs;
    }

    private void prependPaths(Node currentNode, Path currentPath, Collection<Path> completedPaths, Stack<ChildAssoc> assocStack, boolean primaryOnly) throws CyclicChildRelationshipException {
        NodeRef currentNodeRef = currentNode.getNodeRef();
        Collection<ChildAssoc> parentAssocs = currentNode.getParentAssocs();
        boolean hasParents = parentAssocs.size() > 0;
        boolean isRoot = this.hasAspect(currentNodeRef, ContentModel.ASPECT_ROOT);
        boolean isStoreRoot = currentNode.getTypeQName().equals(ContentModel.TYPE_STOREROOT);
        if (!(!isRoot || primaryOnly && hasParents)) {
            ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, this.getRootNode(currentNode.getNodeRef().getStoreRef()));
            Path pathToSave = new Path();
            Path.ChildAssocElement first = null;
            for (Path.Element element : currentPath) {
                if (first == null) {
                    first = (Path.ChildAssocElement)element;
                    continue;
                }
                pathToSave.append(element);
            }
            if (first != null) {
                ChildAssociationRef updateAssocRef = new ChildAssociationRef(isStoreRoot ? ContentModel.ASSOC_CHILDREN : first.getRef().getTypeQName(), this.getRootNode(currentNode.getNodeRef().getStoreRef()), first.getRef().getQName(), first.getRef().getChildRef());
                Path.ChildAssocElement newFirst = new Path.ChildAssocElement(updateAssocRef);
                pathToSave.prepend(newFirst);
            }
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            pathToSave.prepend(element);
            completedPaths.add(pathToSave);
        }
        if (parentAssocs.size() == 0 && !isRoot) {
            throw new RuntimeException("Node without parents does not have root aspect: " + currentNodeRef);
        }
        for (ChildAssoc assoc : parentAssocs) {
            if (assocStack.contains(assoc)) {
                throw new CyclicChildRelationshipException("Cyclic parent-child relationship detected: \n   current node: " + currentNode + "\n" + "   current path: " + currentPath + "\n" + "   next assoc: " + assoc, assoc);
            }
            if (primaryOnly && !assoc.getIsPrimary()) continue;
            NodeRef parentRef = assoc.getParent().getNodeRef();
            QName qname = assoc.getQname();
            NodeRef childRef = assoc.getChild().getNodeRef();
            boolean isPrimary = assoc.getIsPrimary();
            ChildAssociationRef assocRef = new ChildAssociationRef(assoc.getTypeQName(), parentRef, qname, childRef, isPrimary, -1);
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            Path path = new Path();
            path.append(currentPath);
            path.prepend(element);
            Node parentNode = assoc.getParent();
            assocStack.push(assoc);
            this.prependPaths(parentNode, path, completedPaths, assocStack, primaryOnly);
            assocStack.pop();
        }
    }

    @Override
    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        List<Path> paths = this.getPaths(nodeRef, true);
        if (paths.size() == 1) {
            return paths.get(0);
        }
        throw new RuntimeException("Primary path count not checked");
    }

    @Override
    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        Node node = this.getNodeNotNull(nodeRef);
        ArrayList<Path> paths = new ArrayList<Path>(primaryOnly ? 1 : 10);
        Path currentPath = new Path();
        Stack<ChildAssoc> assocStack = new Stack<ChildAssoc>();
        this.prependPaths(node, currentPath, paths, assocStack, primaryOnly);
        if (primaryOnly && paths.size() != 1) {
            throw new RuntimeException("Node has " + paths.size() + " primary paths: " + nodeRef);
        }
        return paths;
    }

    private void archiveNode(NodeRef nodeRef, StoreRef archiveStoreRef) {
        Node node = this.getNodeNotNull(nodeRef);
        ChildAssoc primaryParentAssoc = this.nodeDaoService.getPrimaryParentAssoc(node);
        Set<QName> aspects = node.getAspects();
        aspects.add(ContentModel.ASPECT_ARCHIVED);
        Map<QName, PropertyValue> properties = node.getProperties();
        PropertyValue archivedByProperty = this.makePropertyValue(this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_BY), (Serializable)((Object)AuthenticationUtil.getCurrentUserName()));
        properties.put(ContentModel.PROP_ARCHIVED_BY, archivedByProperty);
        PropertyValue archivedDateProperty = this.makePropertyValue(this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_DATE), new Date());
        properties.put(ContentModel.PROP_ARCHIVED_DATE, archivedDateProperty);
        PropertyValue archivedPrimaryParentNodeRefProperty = this.makePropertyValue(this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC), primaryParentAssoc.getChildAssocRef());
        properties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC, archivedPrimaryParentNodeRefProperty);
        PropertyValue originalOwnerProperty = properties.get(ContentModel.PROP_OWNER);
        PropertyValue originalCreatorProperty = properties.get(ContentModel.PROP_CREATOR);
        if (originalOwnerProperty != null || originalCreatorProperty != null) {
            properties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER, originalOwnerProperty != null ? originalOwnerProperty : originalCreatorProperty);
        }
        aspects.add(ContentModel.ASPECT_OWNABLE);
        PropertyValue newOwnerProperty = this.makePropertyValue(this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER), (Serializable)((Object)AuthenticationUtil.getCurrentUserName()));
        properties.put(ContentModel.PROP_OWNER, newOwnerProperty);
        NodeRef archiveStoreRootNodeRef = this.getRootNode(archiveStoreRef);
        this.moveNode(nodeRef, archiveStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org/model/system/1.0", "archivedItem"));
        Map<Long, Node> nodesById = this.getNodeHierarchy(node, null);
        for (Node nodeToArchive : nodesById.values()) {
            this.archiveAssocs(nodeToArchive, nodesById);
        }
        nodeRef = node.getNodeRef();
    }

    private void moveNodeToStore(Node node, Store store) {
        Map<Long, Node> nodesById = this.getNodeHierarchy(node, null);
        for (Node nodeToMove : nodesById.values()) {
            NodeRef oldNodeRef = nodeToMove.getNodeRef();
            nodeToMove.setStore(store);
            NodeRef newNodeRef = nodeToMove.getNodeRef();
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            NodeStatus oldNodeStatus = this.nodeDaoService.getNodeStatus(oldNodeRef, true);
            oldNodeStatus.setNode(null);
            oldNodeStatus.setChangeTxnId(txnId);
            NodeStatus newNodeStatus = this.nodeDaoService.getNodeStatus(newNodeRef, true);
            newNodeStatus.setNode(nodeToMove);
            newNodeStatus.setChangeTxnId(txnId);
        }
    }

    private Map<Long, Node> getNodeHierarchy(Node node, Map<Long, Node> nodesById) {
        Long id;
        if (nodesById == null) {
            nodesById = new HashMap<Long, Node>(23);
        }
        if (nodesById.containsKey(id = node.getId())) {
            logger.warn((Object)("Circular hierarchy found including node " + id));
            return nodesById;
        }
        nodesById.put(id, node);
        Collection<ChildAssoc> childAssocs = node.getChildAssocs();
        for (ChildAssoc childAssoc : childAssocs) {
            if (!childAssoc.getIsPrimary()) continue;
            Node primaryChild = childAssoc.getChild();
            nodesById = this.getNodeHierarchy(primaryChild, nodesById);
        }
        return nodesById;
    }

    private void archiveAssocs(Node node, Map<Long, Node> nodesById) {
        PropertyValue propertyValue;
        ArrayList<ChildAssoc> childAssocsToDelete = new ArrayList<ChildAssoc>(5);
        ArrayList<ChildAssociationRef> archivedChildAssocRefs = new ArrayList<ChildAssociationRef>(5);
        for (ChildAssoc assoc : node.getChildAssocs()) {
            Long relatedNodeId = assoc.getChild().getId();
            if (nodesById.containsKey(relatedNodeId)) continue;
            childAssocsToDelete.add(assoc);
            archivedChildAssocRefs.add(assoc.getChildAssocRef());
        }
        ArrayList<ChildAssociationRef> archivedParentAssocRefs = new ArrayList<ChildAssociationRef>(5);
        for (ChildAssoc assoc : node.getParentAssocs()) {
            Long relatedNodeId = assoc.getParent().getId();
            if (nodesById.containsKey(relatedNodeId) || assoc.getIsPrimary()) continue;
            childAssocsToDelete.add(assoc);
            archivedParentAssocRefs.add(assoc.getChildAssocRef());
        }
        ArrayList<NodeAssoc> nodeAssocsToDelete = new ArrayList<NodeAssoc>(5);
        ArrayList<AssociationRef> archivedSourceAssocRefs = new ArrayList<AssociationRef>(5);
        for (NodeAssoc assoc : node.getSourceNodeAssocs()) {
            Long l = assoc.getSource().getId();
            if (nodesById.containsKey(l)) continue;
            nodeAssocsToDelete.add(assoc);
            archivedSourceAssocRefs.add(assoc.getNodeAssocRef());
        }
        ArrayList<AssociationRef> archivedTargetAssocRefs = new ArrayList<AssociationRef>(5);
        for (NodeAssoc nodeAssoc : node.getTargetNodeAssocs()) {
            Long relatedNodeId = nodeAssoc.getTarget().getId();
            if (nodesById.containsKey(relatedNodeId)) continue;
            nodeAssocsToDelete.add(nodeAssoc);
            archivedTargetAssocRefs.add(nodeAssoc.getNodeAssocRef());
        }
        for (ChildAssoc childAssoc : childAssocsToDelete) {
            this.nodeDaoService.deleteChildAssoc(childAssoc, false);
        }
        for (NodeAssoc nodeAssoc : nodeAssocsToDelete) {
            this.nodeDaoService.deleteNodeAssoc(nodeAssoc);
        }
        node.getAspects().add(ContentModel.ASPECT_ARCHIVED_ASSOCS);
        Map<QName, PropertyValue> properties = node.getProperties();
        if (archivedParentAssocRefs.size() > 0) {
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_PARENT_ASSOCS);
            propertyValue = this.makePropertyValue(propertyDefinition, archivedParentAssocRefs);
            properties.put(ContentModel.PROP_ARCHIVED_PARENT_ASSOCS, propertyValue);
        }
        if (archivedChildAssocRefs.size() > 0) {
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_CHILD_ASSOCS);
            propertyValue = this.makePropertyValue(propertyDefinition, archivedChildAssocRefs);
            properties.put(ContentModel.PROP_ARCHIVED_CHILD_ASSOCS, propertyValue);
        }
        if (archivedSourceAssocRefs.size() > 0) {
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS);
            propertyValue = this.makePropertyValue(propertyDefinition, archivedSourceAssocRefs);
            properties.put(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS, propertyValue);
        }
        if (archivedTargetAssocRefs.size() > 0) {
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS);
            propertyValue = this.makePropertyValue(propertyDefinition, archivedTargetAssocRefs);
            properties.put(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS, propertyValue);
        }
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        StoreRef archiveStoreRef = this.storeArchiveMap.getArchiveMap().get(storeRef);
        if (archiveStoreRef == null) {
            return null;
        }
        return this.getRootNode(archiveStoreRef);
    }

    @Override
    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        Node archivedNode = this.getNodeNotNull(archivedNodeRef);
        Set<QName> aspects = archivedNode.getAspects();
        Map<QName, PropertyValue> properties = archivedNode.getProperties();
        if (!aspects.contains(ContentModel.ASPECT_ARCHIVED)) {
            throw new AlfrescoRuntimeException("The node to archive is not an archive node");
        }
        ChildAssociationRef originalPrimaryParentAssocRef = (ChildAssociationRef)this.makeSerializableValue(this.dictionaryService.getProperty(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC), properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC));
        PropertyValue originalOwnerProperty = properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        aspects.remove(ContentModel.ASPECT_ARCHIVED);
        properties.remove(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        properties.remove(ContentModel.PROP_ARCHIVED_BY);
        properties.remove(ContentModel.PROP_ARCHIVED_DATE);
        properties.remove(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        if (originalOwnerProperty != null) {
            aspects.add(ContentModel.ASPECT_OWNABLE);
            properties.put(ContentModel.PROP_OWNER, originalOwnerProperty);
        }
        if (destinationParentNodeRef == null) {
            destinationParentNodeRef = originalPrimaryParentAssocRef.getParentRef();
        }
        if (assocTypeQName == null) {
            assocTypeQName = originalPrimaryParentAssocRef.getTypeQName();
        }
        if (assocQName == null) {
            assocQName = originalPrimaryParentAssocRef.getQName();
        }
        this.moveNode(archivedNodeRef, destinationParentNodeRef, assocTypeQName, assocQName);
        Map<Long, Node> restoredNodesById = this.getNodeHierarchy(archivedNode, null);
        for (Node restoredNode : restoredNodesById.values()) {
            this.restoreAssocs(restoredNode);
        }
        NodeRef restoredNodeRef = archivedNode.getNodeRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Restored node: \n   original noderef: " + archivedNodeRef + "\n" + "   restored noderef: " + restoredNodeRef + "\n" + "   new parent: " + destinationParentNodeRef));
        }
        return restoredNodeRef;
    }

    private void restoreAssocs(Node node) {
        Collection targetAssocRefs;
        Collection sourceAssocRefs;
        Collection childAssocRefs;
        NodeRef nodeRef = node.getNodeRef();
        Map<QName, PropertyValue> properties = node.getProperties();
        Collection parentAssocRefs = (Collection)((Object)this.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_PARENT_ASSOCS));
        if (parentAssocRefs != null) {
            for (ChildAssociationRef assocRef : parentAssocRefs) {
                NodeRef parentNodeRef = assocRef.getParentRef();
                if (!this.exists(parentNodeRef)) continue;
                Node parentNode = this.getNodeNotNull(parentNodeRef);
                this.nodeDaoService.newChildAssoc(parentNode, node, assocRef.isPrimary(), assocRef.getTypeQName(), assocRef.getQName());
            }
            properties.remove(ContentModel.PROP_ARCHIVED_PARENT_ASSOCS);
        }
        if ((childAssocRefs = (Collection)((Object)this.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_CHILD_ASSOCS))) != null) {
            for (ChildAssociationRef assocRef : childAssocRefs) {
                NodeRef childNodeRef = assocRef.getChildRef();
                if (!this.exists(childNodeRef)) continue;
                Node childNode = this.getNodeNotNull(childNodeRef);
                this.nodeDaoService.newChildAssoc(node, childNode, assocRef.isPrimary(), assocRef.getTypeQName(), assocRef.getQName());
            }
            properties.remove(ContentModel.PROP_ARCHIVED_CHILD_ASSOCS);
        }
        if ((sourceAssocRefs = (Collection)((Object)this.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS))) != null) {
            for (AssociationRef assocRef : sourceAssocRefs) {
                NodeRef sourceNodeRef = assocRef.getSourceRef();
                if (!this.exists(sourceNodeRef)) continue;
                Node sourceNode = this.getNodeNotNull(sourceNodeRef);
                this.nodeDaoService.newNodeAssoc(sourceNode, node, assocRef.getTypeQName());
            }
            properties.remove(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS);
        }
        if ((targetAssocRefs = (Collection)((Object)this.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_TARGET_ASSOCS))) != null) {
            for (AssociationRef assocRef : targetAssocRefs) {
                NodeRef targetNodeRef = assocRef.getTargetRef();
                if (!this.exists(targetNodeRef)) continue;
                Node targetNode = this.getNodeNotNull(targetNodeRef);
                this.nodeDaoService.newNodeAssoc(node, targetNode, assocRef.getTypeQName());
            }
            properties.remove(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS);
        }
        node.getAspects().remove(ContentModel.ASPECT_ARCHIVED_ASSOCS);
    }
}

