/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.NodeStatus;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbNodeServiceImplTest
extends BaseNodeServiceTest {
    private TransactionService txnService;
    private NodeDaoService nodeDaoService;

    @Override
    protected NodeService getNodeService() {
        return (NodeService)this.applicationContext.getBean("NodeService");
    }

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.txnService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeDaoService = (NodeDaoService)this.applicationContext.getBean("nodeDaoService");
    }

    public void testLazyLoadIssue() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        this.setComplete();
        this.endTransaction();
        UserTransaction userTransaction = this.txnService.getUserTransaction();
        try {
            userTransaction.begin();
            ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "n6_p_n8"));
            NodeRef n6Ref = n6pn8Ref.getParentRef();
            NodeRef n8Ref = n6pn8Ref.getChildRef();
            this.nodeService.deleteNode(n8Ref);
            List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(n6Ref);
            for (ChildAssociationRef assoc : assocs) {
            }
            userTransaction.commit();
        }
        catch (Exception e) {
            try {
                userTransaction.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testNodeStatus() throws Throwable {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "n6_p_n8"));
        final NodeRef n6Ref = n6pn8Ref.getParentRef();
        final NodeRef n8Ref = n6pn8Ref.getChildRef();
        final Map<QName, Serializable> properties = this.nodeService.getProperties(n6Ref);
        this.setComplete();
        this.endTransaction();
        TransactionUtil.TransactionWork<Object> changePropertiesWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                DbNodeServiceImplTest.this.nodeService.setProperty(n6Ref, ContentModel.PROP_CREATED, new Date());
                return null;
            }
        };
        this.executeAndCheck(n6Ref, changePropertiesWork);
        TransactionUtil.TransactionWork<Object> addAspectWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                DbNodeServiceImplTest.this.nodeService.addAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER, null);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, addAspectWork);
        TransactionUtil.TransactionWork<Object> removeAspectWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                DbNodeServiceImplTest.this.nodeService.removeAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, removeAspectWork);
        TransactionUtil.TransactionWork<Object> moveNodeWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                DbNodeServiceImplTest.this.nodeService.moveNode(n6Ref, DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "moved"));
                return null;
            }
        };
        this.executeAndCheck(n6Ref, moveNodeWork);
        TransactionUtil.TransactionWork<Object> deleteNodeWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                DbNodeServiceImplTest.this.nodeService.deleteNode(n6Ref);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, deleteNodeWork);
        TransactionUtil.TransactionWork<Object> checkCascadeWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                NodeStatus n6Status = DbNodeServiceImplTest.this.nodeDaoService.getNodeStatus(n6Ref, false);
                if (!n6Status.isDeleted()) {
                    throw new RuntimeException("Deleted node does not have deleted status");
                }
                NodeStatus n8Status = DbNodeServiceImplTest.this.nodeDaoService.getNodeStatus(n8Ref, false);
                if (!n8Status.isDeleted()) {
                    throw new RuntimeException("Cascade-deleted node does not have deleted status");
                }
                return null;
            }
        };
        TransactionUtil.executeInUserTransaction(this.txnService, checkCascadeWork);
        TransactionUtil.TransactionWork<Object> checkRecreateWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                properties.put(ContentModel.PROP_STORE_PROTOCOL, n6Ref.getStoreRef().getProtocol());
                properties.put(ContentModel.PROP_STORE_IDENTIFIER, n6Ref.getStoreRef().getIdentifier());
                properties.put(ContentModel.PROP_NODE_UUID, n6Ref.getId());
                DbNodeServiceImplTest.this.nodeService.createNode(DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "recreated-n6"), ContentModel.TYPE_CONTAINER, properties);
                return null;
            }
        };
        TransactionUtil.executeInUserTransaction(this.txnService, checkRecreateWork);
    }

    private void executeAndCheck(NodeRef nodeRef, TransactionUtil.TransactionWork<Object> work) throws Throwable {
        UserTransaction txn = this.txnService.getUserTransaction();
        txn.begin();
        NodeRef.Status currentStatus = this.nodeService.getNodeStatus(nodeRef);
        DbNodeServiceImplTest.assertNotNull((Object)currentStatus);
        String currentTxnId = AlfrescoTransactionSupport.getTransactionId();
        DbNodeServiceImplTest.assertNotNull((Object)currentTxnId);
        DbNodeServiceImplTest.assertNotSame((Object)currentTxnId, (Object)currentStatus.getChangeTxnId());
        try {
            work.doWork();
            NodeRef.Status newStatus = this.nodeService.getNodeStatus(nodeRef);
            DbNodeServiceImplTest.assertNotNull((Object)newStatus);
            DbNodeServiceImplTest.assertEquals((String)"Change didn't update status", (String)currentTxnId, (String)newStatus.getChangeTxnId());
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testGetContentDataStringValues() throws Exception {
        ContentData contentData = new ContentData("abc", "text/plain", 0L, null);
        this.nodeService.setProperty(this.rootNodeRef, QName.createQName("http://www.alfresco.org/test/BaseNodeServiceTest", "random"), contentData);
        List<String> contentDataStrings = this.nodeDaoService.getContentDataStrings();
        DbNodeServiceImplTest.assertNotNull(contentDataStrings);
        DbNodeServiceImplTest.assertTrue((String)"ContentData not represented as a String in results", (boolean)contentDataStrings.contains(contentData.toString()));
    }
}

