/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.ChildAssoc;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.NodeAssoc;
import org.alfresco.repo.domain.NodeKey;
import org.alfresco.repo.domain.NodeStatus;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.domain.StoreKey;
import org.alfresco.repo.domain.hibernate.ChildAssocImpl;
import org.alfresco.repo.domain.hibernate.NodeAssocImpl;
import org.alfresco.repo.domain.hibernate.NodeImpl;
import org.alfresco.repo.domain.hibernate.NodeStatusImpl;
import org.alfresco.repo.domain.hibernate.StoreImpl;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionalDao;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.hibernate.ObjectDeletedException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateNodeDaoServiceImpl
extends HibernateDaoSupport
implements NodeDaoService,
TransactionalDao {
    private static final String QUERY_GET_ALL_STORES = "store.GetAllStores";
    private static final String QUERY_GET_CONTENT_DATA_STRINGS = "node.GetContentDataStrings";
    private String uuid = GUID.generate();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HibernateNodeDaoServiceImpl)) {
            return false;
        }
        HibernateNodeDaoServiceImpl that = (HibernateNodeDaoServiceImpl)obj;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean isDirty() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.isDirty();
            }
        };
        return (Boolean)this.getHibernateTemplate().execute(callback);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public List<Store> getStores() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(HibernateNodeDaoServiceImpl.QUERY_GET_ALL_STORES);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }

    @Override
    public Store createStore(String protocol, String identifier) {
        Store store = this.getStore(protocol, identifier);
        if (store != null) {
            throw new RuntimeException("A store already exists: \n   protocol: " + protocol + "\n" + "   identifier: " + identifier + "\n" + "   store: " + store);
        }
        store = new StoreImpl();
        store.setKey(new StoreKey(protocol, identifier));
        this.getHibernateTemplate().save((Object)store);
        Node rootNode = this.newNode(store, GUID.generate(), ContentModel.TYPE_STOREROOT);
        store.setRootNode(rootNode);
        return store;
    }

    @Override
    public Store getStore(String protocol, String identifier) {
        StoreKey storeKey = new StoreKey(protocol, identifier);
        Store store = (Store)this.getHibernateTemplate().get(StoreImpl.class, (Serializable)storeKey);
        return store;
    }

    @Override
    public NodeStatus getNodeStatus(NodeRef nodeRef, boolean create) {
        NodeKey nodeKey = new NodeKey(nodeRef);
        NodeStatus status = null;
        try {
            status = (NodeStatus)this.getHibernateTemplate().get(NodeStatusImpl.class, (Serializable)nodeKey);
        }
        catch (DataAccessException e) {
            if (e.contains(ObjectDeletedException.class)) {
                return null;
            }
            throw e;
        }
        if (status == null && create) {
            status = new NodeStatusImpl();
            status.setKey(nodeKey);
            status.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
            this.getHibernateTemplate().save((Object)status);
        }
        return status;
    }

    @Override
    public void recordChangeId(NodeRef nodeRef) {
        NodeKey key = new NodeKey(nodeRef);
        NodeStatus status = (NodeStatus)this.getHibernateTemplate().get(NodeStatusImpl.class, (Serializable)key);
        if (status == null) {
            return;
        }
        status.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
    }

    @Override
    public Node newNode(Store store, String uuid, QName nodeTypeQName) throws InvalidTypeException {
        NodeKey key = new NodeKey(store.getKey(), uuid);
        NodeStatus status = (NodeStatus)this.getHibernateTemplate().get(NodeStatusImpl.class, (Serializable)key);
        if (status == null) {
            status = new NodeStatusImpl();
            status.setKey(key);
        } else if (status.getChangeTxnId().equals(AlfrescoTransactionSupport.getTransactionId())) {
            this.getHibernateTemplate().flush();
        }
        NodeImpl node = new NodeImpl();
        node.setStore(store);
        node.setUuid(uuid);
        node.setTypeQName(nodeTypeQName);
        this.getHibernateTemplate().save((Object)node);
        status.setNode(node);
        status.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
        this.getHibernateTemplate().save((Object)status);
        return node;
    }

    @Override
    public Node getNode(NodeRef nodeRef) {
        NodeStatus status = this.getNodeStatus(nodeRef, false);
        if (status == null) {
            return null;
        }
        Node node = status.getNode();
        return node;
    }

    @Override
    public void deleteNode(Node node, boolean cascade) {
        Collection<ChildAssoc> parentAssocs = node.getParentAssocs();
        parentAssocs = new ArrayList<ChildAssoc>(parentAssocs);
        for (ChildAssoc assoc : parentAssocs) {
            this.deleteChildAssoc(assoc, false);
        }
        Collection<ChildAssoc> childAssocs = node.getChildAssocs();
        childAssocs = new ArrayList<ChildAssoc>(childAssocs);
        for (ChildAssoc assoc : childAssocs) {
            this.deleteChildAssoc(assoc, cascade);
        }
        Collection<NodeAssoc> targetAssocs = node.getTargetNodeAssocs();
        targetAssocs = new ArrayList<NodeAssoc>(targetAssocs);
        for (NodeAssoc assoc : targetAssocs) {
            this.deleteNodeAssoc(assoc);
        }
        Collection<NodeAssoc> sourceAssocs = node.getSourceNodeAssocs();
        sourceAssocs = new ArrayList<NodeAssoc>(sourceAssocs);
        for (NodeAssoc assoc : sourceAssocs) {
            this.deleteNodeAssoc(assoc);
        }
        NodeRef nodeRef = node.getNodeRef();
        NodeStatus nodeStatus = this.getNodeStatus(nodeRef, true);
        nodeStatus.setNode(null);
        nodeStatus.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
        this.getHibernateTemplate().delete((Object)node);
    }

    @Override
    public ChildAssoc newChildAssoc(Node parentNode, Node childNode, boolean isPrimary, QName assocTypeQName, QName qname) {
        ChildAssocImpl assoc = new ChildAssocImpl();
        assoc.setTypeQName(assocTypeQName);
        assoc.setIsPrimary(isPrimary);
        assoc.setQname(qname);
        assoc.buildAssociation(parentNode, childNode);
        this.getHibernateTemplate().save((Object)assoc);
        return assoc;
    }

    @Override
    public ChildAssoc getChildAssoc(Node parentNode, Node childNode, QName assocTypeQName, QName qname) {
        ChildAssociationRef childAssocRef = new ChildAssociationRef(assocTypeQName, parentNode.getNodeRef(), qname, childNode.getNodeRef());
        Collection<ChildAssoc> assocs = parentNode.getChildAssocs();
        for (ChildAssoc assoc : assocs) {
            if (!assoc.getChildAssocRef().equals(childAssocRef)) continue;
            return assoc;
        }
        return null;
    }

    @Override
    public void deleteChildAssoc(ChildAssoc assoc, boolean cascade) {
        Node childNode = assoc.getChild();
        assoc.removeAssociation();
        this.getHibernateTemplate().delete((Object)assoc);
        if (cascade && assoc.getIsPrimary()) {
            this.deleteNode(childNode, cascade);
        }
    }

    @Override
    public ChildAssoc getPrimaryParentAssoc(Node node) {
        Collection<ChildAssoc> parentAssocs = node.getParentAssocs();
        ChildAssoc primaryAssoc = null;
        for (ChildAssoc assoc : parentAssocs) {
            if (!assoc.getIsPrimary()) continue;
            if (primaryAssoc != null) {
                throw new DataIntegrityViolationException("Multiple primary associations: \n   child: " + node + "\n" + "   first primary assoc: " + primaryAssoc + "\n" + "   second primary assoc: " + assoc);
            }
            primaryAssoc = assoc;
        }
        if (primaryAssoc == null) {
            Store store = node.getStore();
            Node rootNode = store.getRootNode();
            if (rootNode == null) {
                throw new DataIntegrityViolationException("Store has no root node: \n   store: " + store);
            }
            if (!rootNode.equals(node)) {
                throw new DataIntegrityViolationException("Non-root node has no primary parent: \n   child: " + node);
            }
        }
        return primaryAssoc;
    }

    @Override
    public NodeAssoc newNodeAssoc(Node sourceNode, Node targetNode, QName assocTypeQName) {
        NodeAssocImpl assoc = new NodeAssocImpl();
        assoc.setTypeQName(assocTypeQName);
        assoc.buildAssociation(sourceNode, targetNode);
        this.getHibernateTemplate().save((Object)assoc);
        return assoc;
    }

    @Override
    public NodeAssoc getNodeAssoc(Node sourceNode, Node targetNode, QName assocTypeQName) {
        AssociationRef nodeAssocRef = new AssociationRef(sourceNode.getNodeRef(), assocTypeQName, targetNode.getNodeRef());
        Collection<NodeAssoc> assocs = sourceNode.getTargetNodeAssocs();
        for (NodeAssoc assoc : assocs) {
            if (!assoc.getNodeAssocRef().equals(nodeAssocRef)) continue;
            return assoc;
        }
        return null;
    }

    @Override
    public void deleteNodeAssoc(NodeAssoc assoc) {
        assoc.removeAssociation();
        this.getHibernateTemplate().delete((Object)assoc);
    }

    @Override
    public List<String> getContentDataStrings() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(HibernateNodeDaoServiceImpl.QUERY_GET_CONTENT_DATA_STRINGS);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }
}

