/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.node.index.IndexRecovery;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtsIndexRecoveryComponent
implements IndexRecovery {
    private static Log logger = LogFactory.getLog(FtsIndexRecoveryComponent.class);
    private TransactionService transactionService;
    private FullTextSearchIndexer ftsIndexer;
    private NodeService nodeService;
    private List<StoreRef> storeRefs = new ArrayList<StoreRef>(2);

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setFtsIndexer(FullTextSearchIndexer ftsIndexer) {
        this.ftsIndexer = ftsIndexer;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStores(List<String> storeRefStrings) {
        this.storeRefs.clear();
        for (String storeRefStr : storeRefStrings) {
            StoreRef storeRef = new StoreRef(storeRefStr);
            this.storeRefs.add(storeRef);
        }
    }

    @Override
    public void reindex() {
        TransactionUtil.TransactionWork<Object> reindexWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                for (StoreRef storeRef : FtsIndexRecoveryComponent.this.storeRefs) {
                    if (!FtsIndexRecoveryComponent.this.nodeService.exists(storeRef)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Skipping reindex of non-existent store: " + storeRef));
                        continue;
                    }
                    FtsIndexRecoveryComponent.this.ftsIndexer.requiresIndex(storeRef);
                }
                return null;
            }
        };
        TransactionUtil.executeInUserTransaction(this.transactionService, reindexWork);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Prompted FTS index on stores: " + this.storeRefs));
        }
    }
}

