/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.NodeStatus;
import org.alfresco.repo.node.index.IndexRecovery;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullIndexRecoveryComponent
extends HibernateDaoSupport
implements IndexRecovery {
    public static final String QUERY_GET_NEXT_CHANGE_TXN_IDS = "node.GetNextChangeTxnIds";
    public static final String QUERY_GET_CHANGED_NODE_STATUSES = "node.GetChangedNodeStatuses";
    public static final String QUERY_GET_DELETED_NODE_STATUSES = "node.GetDeletedNodeStatuses";
    public static final String QUERY_GET_CHANGED_NODE_STATUSES_COUNT = "node.GetChangedNodeStatusesCount";
    private static final String START_TXN_ID = "000";
    private static Log logger = LogFactory.getLog(FullIndexRecoveryComponent.class);
    private static boolean started = false;
    private static String currentTxnId = "000";
    private boolean killThread = false;
    private TransactionService transactionService;
    private Indexer indexer;
    private FullTextSearchIndexer ftsIndexer;
    private SearchService searcher;
    private NodeService nodeService;
    private List<StoreRef> storeRefs = new ArrayList<StoreRef>(2);
    private boolean executeFullRecovery = false;
    private boolean runContinuously = false;
    private long waitTime = 1000L;
    private CacheMode l2CacheMode = CacheMode.REFRESH;

    public static String getCurrentTransactionId() {
        return currentTxnId;
    }

    public FullIndexRecoveryComponent() {
        Runnable shutdownRunnable = new Runnable(){

            public void run() {
                FullIndexRecoveryComponent.this.killThread = true;
            }
        };
        Thread shutdownThread = new Thread(shutdownRunnable);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public static boolean isStarted() {
        return started;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setFtsIndexer(FullTextSearchIndexer ftsIndexer) {
        this.ftsIndexer = ftsIndexer;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStores(List<String> storeRefStrings) {
        this.storeRefs.clear();
        for (String storeRefStr : storeRefStrings) {
            StoreRef storeRef = new StoreRef(storeRefStr);
            this.storeRefs.add(storeRef);
        }
    }

    public void setExecuteFullRecovery(boolean executeFullRecovery) {
        this.executeFullRecovery = executeFullRecovery;
    }

    public void setRunContinuously(boolean runContinuously) {
        this.runContinuously = runContinuously;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public void setL2CacheMode(String l2CacheModeStr) {
        if (l2CacheModeStr.equals("GET")) {
            this.l2CacheMode = CacheMode.GET;
        } else if (l2CacheModeStr.equals("IGNORE")) {
            this.l2CacheMode = CacheMode.IGNORE;
        } else if (l2CacheModeStr.equals("NORMAL")) {
            this.l2CacheMode = CacheMode.NORMAL;
        } else if (l2CacheModeStr.equals("PUT")) {
            this.l2CacheMode = CacheMode.PUT;
        } else if (l2CacheModeStr.equals("REFRESH")) {
            this.l2CacheMode = CacheMode.REFRESH;
        } else {
            throw new IllegalArgumentException("Unrecognised Hibernate L2 cache mode: " + l2CacheModeStr);
        }
    }

    @Override
    public synchronized void reindex() {
        if (started) {
            throw new AlfrescoRuntimeException("Only one FullIndexRecoveryComponent may be used per VM and it may only be called once");
        }
        started = true;
        TransactionUtil.TransactionWork<Object> ftsReindexWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                for (StoreRef storeRef : FullIndexRecoveryComponent.this.storeRefs) {
                    if (!FullIndexRecoveryComponent.this.nodeService.exists(storeRef)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Skipping reindex of non-existent store: " + storeRef));
                        continue;
                    }
                    FullIndexRecoveryComponent.this.ftsIndexer.requiresIndex(storeRef);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Prompted FTS index on stores: " + FullIndexRecoveryComponent.this.storeRefs));
                }
                return null;
            }
        };
        TransactionUtil.executeInNonPropagatingUserTransaction(this.transactionService, ftsReindexWork);
        if (!this.executeFullRecovery) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Full index recovery is off - quitting");
            }
        } else {
            currentTxnId = START_TXN_ID;
            ReindexRunner runnable = new ReindexRunner();
            Thread reindexThread = new Thread(runnable);
            reindexThread.setDaemon(true);
            reindexThread.setPriority(1);
            reindexThread.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Full index recovery thread started: \n   continuous: " + this.runContinuously + "\n" + "   stores: " + this.storeRefs));
            }
        }
    }

    private int reindexMissingContent() {
        int count = 0;
        for (StoreRef storeRef : this.storeRefs) {
            count += this.reindexMissingContent(storeRef);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reindexMissingContent(StoreRef storeRef) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(storeRef);
        String query = "TEXT:nicm";
        sp.setLanguage("lucene");
        sp.setQuery(query);
        ResultSet results = null;
        try {
            results = this.searcher.query(sp);
            int count = 0;
            List<ChildAssociationRef> assocRefs = results.getChildAssocRefs();
            for (ChildAssociationRef assocRef : assocRefs) {
                final NodeRef childNodeRef = assocRef.getChildRef();
                TransactionUtil.TransactionWork<Object> reindexWork = new TransactionUtil.TransactionWork<Object>(){

                    @Override
                    public Object doWork() {
                        FullIndexRecoveryComponent.this.indexer.updateNode(childNodeRef);
                        return null;
                    }
                };
                TransactionUtil.executeInNonPropagatingUserTransaction(this.transactionService, reindexWork);
                ++count;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reindexed missing content: \n   store: " + storeRef + "\n" + "   node count: " + count));
            }
            int n = count;
            return n;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private List<String> reindexNodes() {
        List<String> txnsToCheck = this.getNextChangeTxnIds(currentTxnId);
        for (String changeTxnId : txnsToCheck) {
            this.reindexNodes(changeTxnId);
        }
        return txnsToCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexNodes(final String changeTxnId) {
        TransactionUtil.TransactionWork<Object> reindexWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                ReindexCallback callback = new ReindexCallback(changeTxnId);
                FullIndexRecoveryComponent.this.getHibernateTemplate().execute((HibernateCallback)callback);
                return null;
            }
        };
        try {
            TransactionUtil.executeInNonPropagatingUserTransaction(this.transactionService, reindexWork);
        }
        catch (Throwable e) {
            logger.error((Object)("Transaction reindex failed: \n   txn: " + changeTxnId), e);
        }
        finally {
            currentTxnId = changeTxnId;
        }
    }

    public List<String> getNextChangeTxnIds(final String currentTxnId) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(FullIndexRecoveryComponent.QUERY_GET_NEXT_CHANGE_TXN_IDS);
                query.setString("currentTxnId", currentTxnId).setReadOnly(true);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }

    public int getChangedNodeStatusesCount(final StoreRef storeRef, final String changeTxnId) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(FullIndexRecoveryComponent.QUERY_GET_CHANGED_NODE_STATUSES_COUNT);
                query.setString("storeProtocol", storeRef.getProtocol()).setString("storeIdentifier", storeRef.getIdentifier()).setString("changeTxnId", changeTxnId).setReadOnly(true);
                return query.uniqueResult();
            }
        };
        Integer changeCount = (Integer)this.getHibernateTemplate().execute(callback);
        return changeCount;
    }

    public List<NodeStatus> getChangedNodeStatuses(final StoreRef storeRef, final String changeTxnId) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(FullIndexRecoveryComponent.QUERY_GET_CHANGED_NODE_STATUSES);
                query.setString("storeProtocol", storeRef.getProtocol()).setString("storeIdentifier", storeRef.getIdentifier()).setString("changeTxnId", changeTxnId).setReadOnly(true);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }

    public List<NodeStatus> getDeletedNodeStatuses(final StoreRef storeRef, final String changeTxnId) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(FullIndexRecoveryComponent.QUERY_GET_DELETED_NODE_STATUSES);
                query.setString("storeProtocol", storeRef.getProtocol()).setString("storeIdentifier", storeRef.getIdentifier()).setString("changeTxnId", changeTxnId).setReadOnly(true);
                return query.list();
            }
        };
        List queryResults = (List)this.getHibernateTemplate().execute(callback);
        return queryResults;
    }

    private class ReindexCallback
    implements HibernateCallback {
        private final String changeTxnId;

        public ReindexCallback(String changeTxnId) {
            this.changeTxnId = changeTxnId;
        }

        public Object doInHibernate(Session session) {
            FullIndexRecoveryComponent.this.getSession().setCacheMode(FullIndexRecoveryComponent.this.l2CacheMode);
            for (StoreRef storeRef : FullIndexRecoveryComponent.this.storeRefs) {
                if (!FullIndexRecoveryComponent.this.nodeService.exists(storeRef)) continue;
                this.reindexNodes(storeRef, this.changeTxnId);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reindexNodes(StoreRef storeRef, String changeTxnId) {
            SearchParameters sp = new SearchParameters();
            sp.addStore(storeRef);
            String query = "TX:\"" + changeTxnId + "\"";
            sp.setLanguage("lucene");
            sp.setQuery(query);
            ResultSet results = null;
            try {
                results = FullIndexRecoveryComponent.this.searcher.query(sp);
                if (results.length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Transaction present in index - no indexing required: \n   store: " + storeRef + "\n" + "   txn: " + changeTxnId));
                    }
                    return;
                }
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
            int changedCount = FullIndexRecoveryComponent.this.getChangedNodeStatusesCount(storeRef, changeTxnId);
            if (changedCount == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transaction only has deletions - no indexing required: \n   store: " + storeRef + "\n" + "   txn: " + changeTxnId));
                }
                return;
            }
            List<NodeStatus> deletedNodeStatuses = FullIndexRecoveryComponent.this.getDeletedNodeStatuses(storeRef, changeTxnId);
            for (NodeStatus status : deletedNodeStatuses) {
                NodeRef nodeRef = new NodeRef(storeRef, status.getKey().getGuid());
                ChildAssociationRef assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                FullIndexRecoveryComponent.this.indexer.deleteNode(assocRef);
            }
            List<NodeStatus> changedNodeStatuses = FullIndexRecoveryComponent.this.getChangedNodeStatuses(storeRef, changeTxnId);
            for (NodeStatus status : changedNodeStatuses) {
                NodeRef nodeRef = new NodeRef(storeRef, status.getKey().getGuid());
                ChildAssociationRef primaryAssocRef = FullIndexRecoveryComponent.this.nodeService.getPrimaryParent(nodeRef);
                FullIndexRecoveryComponent.this.indexer.createNode(primaryAssocRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction reindexed: \n   store: " + storeRef + "\n" + "   txn: " + changeTxnId + "\n" + "   deletions: " + deletedNodeStatuses.size() + "\n" + "   modifications: " + changedNodeStatuses.size()));
            }
        }
    }

    private class ReindexRunner
    implements Runnable {
        private ReindexRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!FullIndexRecoveryComponent.this.killThread) {
                try {
                    List txnsIndexed = FullIndexRecoveryComponent.this.reindexNodes();
                    int missingContentCount = FullIndexRecoveryComponent.this.reindexMissingContent();
                    if (txnsIndexed.size() == 0 && !FullIndexRecoveryComponent.this.runContinuously) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Thread quitting - no more available indexing to do: \n   last txn: " + FullIndexRecoveryComponent.getCurrentTransactionId()));
                        }
                        break;
                    }
                    FullIndexRecoveryComponent fullIndexRecoveryComponent = FullIndexRecoveryComponent.this;
                    synchronized (fullIndexRecoveryComponent) {
                        FullIndexRecoveryComponent.this.wait(FullIndexRecoveryComponent.this.waitTime);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Throwable e) {
                    if (FullIndexRecoveryComponent.this.killThread) continue;
                    logger.error((Object)"Reindex failure", e);
                }
            }
        }
    }
}

