/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.index.FullIndexRecoveryComponent;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class FullIndexRecoveryComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private FullIndexRecoveryComponent indexRecoverer;
    private NodeService nodeService;
    private TransactionService txnService;
    private Indexer indexer;
    private List<StoreRef> storeRefs;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.indexRecoverer = (FullIndexRecoveryComponent)ctx.getBean("indexRecoveryComponent");
        this.txnService = (TransactionService)ctx.getBean("transactionComponent");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.indexer = (Indexer)ctx.getBean("indexerComponent");
        TransactionUtil.TransactionWork<List<StoreRef>> createStoresWork = new TransactionUtil.TransactionWork<List<StoreRef>>(){

            @Override
            public List<StoreRef> doWork() throws Exception {
                ArrayList<StoreRef> storeRefs = new ArrayList<StoreRef>(2);
                storeRefs.add(FullIndexRecoveryComponentTest.this.nodeService.createStore("workspace", FullIndexRecoveryComponentTest.this.getName() + System.nanoTime()));
                storeRefs.add(FullIndexRecoveryComponentTest.this.nodeService.createStore("workspace", FullIndexRecoveryComponentTest.this.getName() + System.nanoTime()));
                return storeRefs;
            }
        };
        this.storeRefs = TransactionUtil.executeInUserTransaction(this.transactionService, createStoresWork);
    }

    public void testNothing() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xtestReindexing() throws Exception {
        if (FullIndexRecoveryComponent.isStarted()) {
            return;
        }
        final ArrayList<String> storeRefStrings = new ArrayList<String>(2);
        TransactionUtil.TransactionWork<String> dropNodeIndexWork = new TransactionUtil.TransactionWork<String>(){

            @Override
            public String doWork() {
                for (StoreRef storeRef : FullIndexRecoveryComponentTest.this.storeRefs) {
                    try {
                        NodeRef rootNodeRef = FullIndexRecoveryComponentTest.this.nodeService.getRootNode(storeRef);
                        ChildAssociationRef assocRef = FullIndexRecoveryComponentTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName("http://www.alfresco.org", "unindexedChild" + System.currentTimeMillis()), ContentModel.TYPE_BASE);
                        FullIndexRecoveryComponentTest.this.indexer.deleteNode(assocRef);
                        storeRefStrings.add(storeRef.toString());
                    }
                    catch (InvalidStoreRefException invalidStoreRefException) {}
                }
                return AlfrescoTransactionSupport.getTransactionId();
            }
        };
        String txnId = TransactionUtil.executeInNonPropagatingUserTransaction(this.txnService, dropNodeIndexWork);
        this.indexRecoverer.setExecuteFullRecovery(true);
        this.indexRecoverer.setStores(storeRefStrings);
        this.indexRecoverer.reindex();
        try {
            this.indexRecoverer.reindex();
            FullIndexRecoveryComponentTest.fail((String)"Reindexer failed to prevent reindex from being called twice");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String lastProcessedTxnId = null;
        for (int i = 0; i < 60 && !(lastProcessedTxnId = FullIndexRecoveryComponent.getCurrentTransactionId()).equals(txnId); ++i) {
            FullIndexRecoveryComponentTest fullIndexRecoveryComponentTest = this;
            synchronized (fullIndexRecoveryComponentTest) {
                ((Object)((Object)this)).wait(1000L);
                continue;
            }
        }
        FullIndexRecoveryComponentTest.assertEquals((String)"Index transaction not up to date", (String)txnId, (String)lastProcessedTxnId);
    }
}

