/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.Indexer;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class NodeIndexer
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdateNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy {
    private PolicyComponent policyComponent;
    private Indexer indexer;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateNode"), this, (Behaviour)new JavaBehaviour(this, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteNode"), this, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onCreateChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onDeleteChildAssociation"));
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.indexer.createNode(childAssocRef);
    }

    public void onUpdateNode(NodeRef nodeRef) {
        this.indexer.updateNode(nodeRef);
    }

    public void onDeleteNode(ChildAssociationRef childAssocRef) {
        this.indexer.deleteNode(childAssocRef);
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef) {
        this.indexer.createChildRelationship(childAssocRef);
    }

    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        this.indexer.deleteChildRelationship(childAssocRef);
    }
}

