/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.util.perf.PerformanceMonitor;

public class NodeIndexerTest
extends BaseNodeServiceTest {
    private SearchService searchService;
    private static StoreRef localStoreRef;
    private static NodeRef localRootNode;

    protected NodeService getNodeService() {
        return (NodeService)this.applicationContext.getBean("NodeService");
    }

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.searchService = (SearchService)this.applicationContext.getBean("searchService");
        if (localStoreRef == null) {
            localStoreRef = this.nodeService.createStore("workspace", "Test_Persisted" + System.currentTimeMillis());
            localRootNode = this.nodeService.getRootNode(localStoreRef);
        }
    }

    public void testCommitQueryData() throws Exception {
        this.rootNodeRef = localRootNode;
        this.buildNodeGraph();
        this.setComplete();
    }

    public void testQuery() throws Exception {
        this.rootNodeRef = localRootNode;
        ResultSet results = this.searchService.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"test:root_p_n1\"", null, null);
        NodeIndexerTest.assertEquals((int)1, (int)results.length());
        results.close();
    }

    public void testLikeAndContains() throws Exception {
        this.rootNodeRef = localRootNode;
        DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver(null);
        namespacePrefixResolver.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        namespacePrefixResolver.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        namespacePrefixResolver.registerNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        PerformanceMonitor selectNodesPerf = new PerformanceMonitor(((Object)((Object)this)).getClass().getSimpleName(), "selectNodes");
        PerformanceMonitor selectPropertiesPerf = new PerformanceMonitor(((Object)((Object)this)).getClass().getSimpleName(), "selectProperties");
        selectNodesPerf.start();
        List<NodeRef> answer = this.searchService.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'm_nkey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'm%key')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'monk__')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'monk%')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'monk\\%')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)0, (int)answer.size());
        selectNodesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[contains('monkey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectPropertiesPerf.start();
        List<Serializable> result = this.searchService.selectProperties(this.rootNodeRef, "//@*[contains('monkey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)2, (int)result.size());
        selectPropertiesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[contains('mon?ey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectPropertiesPerf.start();
        result = this.searchService.selectProperties(this.rootNodeRef, "//@*[contains('mon?ey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)2, (int)result.size());
        selectPropertiesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[contains('m*y')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectPropertiesPerf.start();
        result = this.searchService.selectProperties(this.rootNodeRef, "//@*[contains('mon*')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)2, (int)result.size());
        selectPropertiesPerf.stop();
        selectNodesPerf.start();
        answer = this.searchService.selectNodes(this.rootNodeRef, "//*[contains('*nkey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)1, (int)answer.size());
        selectNodesPerf.stop();
        selectPropertiesPerf.start();
        result = this.searchService.selectProperties(this.rootNodeRef, "//@*[contains('?onkey')]", null, namespacePrefixResolver, false);
        NodeIndexerTest.assertEquals((int)2, (int)result.size());
        selectPropertiesPerf.stop();
    }
}

