/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssocTargetRoleIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AssocTargetRoleIntegrityEvent.class);

    public AssocTargetRoleIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef sourceNodeRef, QName assocTypeQName, QName assocName) {
        super(nodeService, dictionaryService, sourceNodeRef, assocTypeQName, assocName);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        NodeRef sourceNodeRef = this.getNodeRef();
        QName assocTypeQName = this.getTypeQName();
        QName assocQName = this.getQName();
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Association Type: " + assocTypeQName);
            eventResults.add(result);
            return;
        }
        if (assocQName == null) {
            throw new IllegalArgumentException("The association qualified name must be supplied");
        }
        if (!assocDef.isChild()) {
            throw new UnsupportedOperationException("This operation is only relevant to child associations");
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        this.checkAssocQNameRegex(eventResults, childAssocDef, assocQName);
        this.checkAssocQNameDuplicate(eventResults, childAssocDef, sourceNodeRef, assocQName);
    }

    protected void checkAssocQNameRegex(List<IntegrityRecord> eventResults, ChildAssociationDefinition assocDef, QName assocQName) {
        RegexQNamePattern rolePattern;
        QName assocRoleQName = assocDef.getTargetRoleName();
        if (assocRoleQName != null && !(rolePattern = new RegexQNamePattern(assocRoleQName.toString())).isMatch(assocQName)) {
            IntegrityRecord result = new IntegrityRecord("The association name does not match the allowed role names: \n   Association: " + assocDef + "\n" + "   Allowed roles: " + rolePattern + "\n" + "   Name assigned: " + assocRoleQName);
            eventResults.add(result);
        }
    }

    protected void checkAssocQNameDuplicate(List<IntegrityRecord> eventResults, ChildAssociationDefinition assocDef, NodeRef sourceNodeRef, QName assocQName) {
        if (assocDef.getDuplicateChildNamesAllowed()) {
            return;
        }
        QName assocTypeQName = assocDef.getName();
        try {
            List<ChildAssociationRef> childAssocs = this.nodeService.getChildAssocs(sourceNodeRef, assocTypeQName, assocQName);
            if (childAssocs.size() > 1) {
                IntegrityRecord result = new IntegrityRecord("Duplicate child associations are not allowed: \n   Association: " + assocDef + "\n" + "   Name: " + assocQName);
                eventResults.add(result);
            }
        }
        catch (InvalidNodeRefException e) {
            // empty catch block
        }
    }
}

