/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssocTargetTypeIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AssocTargetTypeIntegrityEvent.class);

    public AssocTargetTypeIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef targetNodeRef, QName assocTypeQName) {
        super(nodeService, dictionaryService, targetNodeRef, assocTypeQName, null);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        QName assocTypeQName = this.getTypeQName();
        NodeRef targetNodeRef = this.getNodeRef();
        QName targetNodeTypeQName = this.getNodeType(targetNodeRef);
        if (targetNodeTypeQName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring integrity check - node gone: \n   event: " + this));
            }
            return;
        }
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Target Node Type: " + targetNodeTypeQName + "\n" + "   Association Type: " + assocTypeQName);
            eventResults.add(result);
            return;
        }
        this.checkTargetType(eventResults, assocDef, targetNodeRef, targetNodeTypeQName);
    }

    protected void checkTargetType(List<IntegrityRecord> eventResults, AssociationDefinition assocDef, NodeRef targetNodeRef, QName targetNodeTypeQName) {
        ClassDefinition targetDef = assocDef.getTargetClass();
        if (targetDef instanceof TypeDefinition) {
            if (!this.dictionaryService.isSubClass(targetNodeTypeQName, targetDef.getName())) {
                IntegrityRecord result = new IntegrityRecord("The association target type is incorrect: \n   Association: " + assocDef + "\n" + "   Required Target Type: " + targetDef.getName() + "\n" + "   Actual Target Type: " + targetNodeTypeQName);
                eventResults.add(result);
            }
        } else if (targetDef instanceof AspectDefinition) {
            Set<QName> targetAspects = this.nodeService.getAspects(targetNodeRef);
            boolean found = false;
            for (QName targetAspectTypeQName : targetAspects) {
                if (!this.dictionaryService.isSubClass(targetAspectTypeQName, targetDef.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                IntegrityRecord result = new IntegrityRecord("The association target is missing the aspect required for this association: \n   Association: " + assocDef + "\n" + "   Required Target Aspect: " + targetDef.getName() + "\n" + "   Actual Target Aspects: " + targetAspects);
                eventResults.add(result);
            }
        } else {
            IntegrityRecord result = new IntegrityRecord("Unknown ClassDefinition subclass on the target definition: \n   Association: " + assocDef + "\n" + "   Source Definition: " + targetDef.getName());
            eventResults.add(result);
        }
    }
}

