/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompleteNodeTagger
extends TransactionListenerAdapter
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy {
    private static Log logger = LogFactory.getLog(IncompleteNodeTagger.class);
    private static final String KEY_NODE_SET = "IncompleteNodeTagger.NodeSet";
    private PolicyComponent policyComponent;
    private DictionaryService dictionaryService;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        PropertyCheck.mandatory("IncompleteNodeTagger", "dictionaryService", this.dictionaryService);
        PropertyCheck.mandatory("IncompleteNodeTagger", "nodeService", this.nodeService);
        PropertyCheck.mandatory("IncompleteNodeTagger", "policyComponent", this.policyComponent);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), this, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onRemoveAspect"), this, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
    }

    private Set<NodeRef> getNodeSet() {
        return (Set)AlfrescoTransactionSupport.getResource(KEY_NODE_SET);
    }

    private void save(NodeRef nodeRef) {
        AlfrescoTransactionSupport.bindListener(this);
        Set<NodeRef> nodeRefs = this.getNodeSet();
        if (nodeRefs == null) {
            nodeRefs = new HashSet<NodeRef>(31, 0.75f);
            AlfrescoTransactionSupport.bindResource(KEY_NODE_SET, nodeRefs);
        }
        nodeRefs.add(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added node reference to set: " + nodeRef));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.save(nodeRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.save(nodeRef);
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (aspectTypeQName.equals(ContentModel.ASPECT_INCOMPLETE) && logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring aspect addition: " + ContentModel.ASPECT_INCOMPLETE));
        }
        this.save(nodeRef);
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (aspectTypeQName.equals(ContentModel.ASPECT_INCOMPLETE) && logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring aspect removal: " + ContentModel.ASPECT_INCOMPLETE));
        }
        this.save(nodeRef);
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        Set<NodeRef> nodeRefs = this.getNodeSet();
        AlfrescoTransactionSupport.unbindResource(KEY_NODE_SET);
        for (NodeRef nodeRef : nodeRefs) {
            if (!this.nodeService.exists(nodeRef)) continue;
            this.processNode(nodeRef);
        }
    }

    private void processNode(NodeRef nodeRef) {
        boolean isTagged = this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE);
        Map<QName, Serializable> nodeProperties = this.nodeService.getProperties(nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
        if (typeDef == null) {
            throw new AlfrescoRuntimeException("Node type is not recognised: " + nodeTypeQName);
        }
        Collection<PropertyDefinition> propertyDefs = typeDef.getProperties().values();
        boolean classPropertiesOK = this.checkProperties(propertyDefs, nodeProperties);
        if (!classPropertiesOK) {
            this.addOrRemoveTag(nodeRef, true, isTagged);
            return;
        }
        Set<QName> aspectTypeQNames = this.nodeService.getAspects(nodeRef);
        for (QName aspectTypeQName : aspectTypeQNames) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
            propertyDefs = aspectDef.getProperties().values();
            boolean aspectPropertiesOK = this.checkProperties(propertyDefs, nodeProperties);
            if (aspectPropertiesOK) continue;
            this.addOrRemoveTag(nodeRef, true, isTagged);
            return;
        }
        this.addOrRemoveTag(nodeRef, false, isTagged);
    }

    private boolean checkProperties(Collection<PropertyDefinition> propertyDefs, Map<QName, Serializable> properties) {
        for (PropertyDefinition propertyDef : propertyDefs) {
            if (!propertyDef.isMandatory() || propertyDef.isMandatoryEnforced() || properties.get(propertyDef.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void addOrRemoveTag(NodeRef nodeRef, boolean addTag, boolean isTagged) {
        if (addTag && !isTagged) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Tagged node as INCOMPLETE: " + nodeRef));
            }
        } else if (!addTag && isTagged) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Untagged node as INCOMPLETE: " + nodeRef));
            }
        }
    }
}

