/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.InputStream;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.integrity.IncompleteNodeTagger;
import org.alfresco.repo.node.integrity.IntegrityTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncompleteNodeTaggerTest
extends TestCase {
    private static Log logger = LogFactory.getLog(IncompleteNodeTaggerTest.class);
    private IncompleteNodeTagger tagger;
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private PropertyMap properties;
    private UserTransaction txn;
    private AuthenticationComponent authenticationComponent;

    public void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)IntegrityTest.ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/node/integrity/IntegrityTest_model.xml");
        IncompleteNodeTaggerTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        this.tagger = (IncompleteNodeTagger)IntegrityTest.ctx.getBean("incompleteNodeTagger");
        this.serviceRegistry = (ServiceRegistry)IntegrityTest.ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.authenticationComponent = (AuthenticationComponent)IntegrityTest.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        this.txn = transactionService.getUserTransaction();
        this.txn.begin();
        StoreRef storeRef = new StoreRef("workspace", this.getName());
        if (!this.nodeService.exists(storeRef)) {
            this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.properties = new PropertyMap();
        this.properties.put(IntegrityTest.TEST_PROP_TEXT_C, "abc");
    }

    public void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.txn.rollback();
    }

    private NodeRef createNode(String name, QName type, PropertyMap properties) {
        return this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org/test/IntegrityTest", name), type, properties).getChildRef();
    }

    public void testSetUp() throws Exception {
        IncompleteNodeTaggerTest.assertNotNull((String)"IncompleteNodeTagger not created", (Object)this.tagger);
    }

    private void checkTagging(NodeRef nodeRef, boolean mustBeTagged) {
        this.tagger.beforeCommit(false);
        IncompleteNodeTaggerTest.assertEquals((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE), (boolean)mustBeTagged);
    }

    public void testCreateWithoutProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_PROPERTIES, null);
        this.checkTagging(nodeRef, true);
    }

    public void testCreateWithProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_PROPERTIES, this.properties);
        this.checkTagging(nodeRef, false);
    }
}

