/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.AspectsIntegrityEvent;
import org.alfresco.repo.node.integrity.AssocSourceMultiplicityIntegrityEvent;
import org.alfresco.repo.node.integrity.AssocSourceTypeIntegrityEvent;
import org.alfresco.repo.node.integrity.AssocTargetMultiplicityIntegrityEvent;
import org.alfresco.repo.node.integrity.AssocTargetRoleIntegrityEvent;
import org.alfresco.repo.node.integrity.AssocTargetTypeIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.repo.node.integrity.PropertiesIntegrityEvent;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityChecker
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnCreateAssociationPolicy,
NodeServicePolicies.OnDeleteAssociationPolicy {
    private static Log logger = LogFactory.getLog(IntegrityChecker.class);
    private static final String KEY_EVENT_SET = "IntegrityChecker.EventSet";
    private PolicyComponent policyComponent;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private boolean enabled = true;
    private boolean failOnViolation = false;
    private int maxErrorsPerTransaction = 10;
    private boolean traceOn = false;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTraceOn(boolean traceOn) {
        this.traceOn = traceOn;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public void setMaxErrorsPerTransaction(int maxLogNumberPerTransaction) {
        this.maxErrorsPerTransaction = maxLogNumberPerTransaction;
    }

    public void init() {
        PropertyCheck.mandatory("IntegrityChecker", "dictionaryService", this.dictionaryService);
        PropertyCheck.mandatory("IntegrityChecker", "nodeService", this.nodeService);
        PropertyCheck.mandatory("IntegrityChecker", "policyComponent", this.policyComponent);
        if (this.enabled) {
            this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
            this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
            this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteNode"), this, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
            this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), this, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
            this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onRemoveAspect"), this, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
            this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onCreateChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
            this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteChildAssociation"), this, (Behaviour)new JavaBehaviour(this, "onDeleteChildAssociation"));
            this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onCreateAssociation"), this, (Behaviour)new JavaBehaviour(this, "onCreateAssociation"));
            this.policyComponent.bindAssociationBehaviour(QName.createQName("http://www.alfresco.org", "onDeleteAssociation"), this, (Behaviour)new JavaBehaviour(this, "onDeleteAssociation"));
        }
    }

    private void save(IntegrityEvent event) {
        IntegrityEvent existingEvent;
        if (this.traceOn) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] trace = t.getStackTrace();
            event.addTrace(trace);
        }
        AlfrescoTransactionSupport.bindIntegrityChecker(this);
        HashMap<IntegrityEvent, IntegrityEvent> events = (HashMap<IntegrityEvent, IntegrityEvent>)AlfrescoTransactionSupport.getResource(KEY_EVENT_SET);
        if (events == null) {
            events = new HashMap<IntegrityEvent, IntegrityEvent>(113, 0.75f);
            AlfrescoTransactionSupport.bindResource(KEY_EVENT_SET, events);
        }
        if ((existingEvent = (IntegrityEvent)events.get(event)) != null) {
            if (this.traceOn) {
                existingEvent.getTraces().addAll(event.getTraces());
            }
        } else {
            events.put(event, event);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + (existingEvent != null ? "Event already present in" : "Added event to") + " event set: \n" + "   event: " + event));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef childRef = childAssocRef.getChildRef();
        AbstractIntegrityEvent event = null;
        event = new PropertiesIntegrityEvent(this.nodeService, this.dictionaryService, childRef);
        this.save(event);
        this.onCreateChildAssociation(childAssocRef);
        event = new AspectsIntegrityEvent(this.nodeService, this.dictionaryService, childRef);
        this.save(event);
        QName childNodeTypeQName = this.nodeService.getType(childRef);
        ClassDefinition nodeTypeDef = this.dictionaryService.getClass(childNodeTypeQName);
        if (nodeTypeDef == null) {
            throw new DictionaryException("The node type is not recognized: " + childNodeTypeQName);
        }
        Map<QName, AssociationDefinition> childAssocDefs = nodeTypeDef.getAssociations();
        for (AssociationDefinition assocDef : childAssocDefs.values()) {
            QName assocTypeQName = assocDef.getName();
            event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, childRef, assocTypeQName, false);
            this.save(event);
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        PropertiesIntegrityEvent event = null;
        event = new PropertiesIntegrityEvent(this.nodeService, this.dictionaryService, nodeRef);
        this.save(event);
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef) {
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        AbstractIntegrityEvent event = null;
        event = new PropertiesIntegrityEvent(this.nodeService, this.dictionaryService, nodeRef);
        this.save(event);
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new DictionaryException("The aspect type is not recognized: " + aspectTypeQName);
        }
        Map<QName, AssociationDefinition> assocDefs = aspectDef.getAssociations();
        for (AssociationDefinition assocDef : assocDefs.values()) {
            QName assocTypeQName = assocDef.getName();
            event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, nodeRef, assocTypeQName, false);
            this.save(event);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        AspectsIntegrityEvent event = null;
        event = new AspectsIntegrityEvent(this.nodeService, this.dictionaryService, nodeRef);
        this.save(event);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef) {
        AbstractIntegrityEvent event = null;
        event = new AssocSourceTypeIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getParentRef(), childAssocRef.getTypeQName());
        this.save(event);
        event = new AssocTargetTypeIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getChildRef(), childAssocRef.getTypeQName());
        this.save(event);
        event = new AssocSourceMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getChildRef(), childAssocRef.getTypeQName(), false);
        this.save(event);
        event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), false);
        this.save(event);
        event = new AssocTargetRoleIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
        this.save(event);
    }

    @Override
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        AbstractIntegrityEvent event = null;
        event = new AssocSourceMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getChildRef(), childAssocRef.getTypeQName(), true);
        this.save(event);
        event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), true);
        this.save(event);
    }

    @Override
    public void onCreateAssociation(AssociationRef nodeAssocRef) {
        AbstractIntegrityEvent event = null;
        event = new AssocSourceTypeIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getSourceRef(), nodeAssocRef.getTypeQName());
        this.save(event);
        event = new AssocTargetTypeIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getTargetRef(), nodeAssocRef.getTypeQName());
        this.save(event);
        event = new AssocSourceMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getTargetRef(), nodeAssocRef.getTypeQName(), false);
        this.save(event);
        event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getSourceRef(), nodeAssocRef.getTypeQName(), false);
        this.save(event);
    }

    @Override
    public void onDeleteAssociation(AssociationRef nodeAssocRef) {
        AbstractIntegrityEvent event = null;
        event = new AssocSourceMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getTargetRef(), nodeAssocRef.getTypeQName(), true);
        this.save(event);
        event = new AssocTargetMultiplicityIntegrityEvent(this.nodeService, this.dictionaryService, nodeAssocRef.getSourceRef(), nodeAssocRef.getTypeQName(), true);
        this.save(event);
    }

    public void checkIntegrity() throws IntegrityException {
        if (!this.enabled) {
            return;
        }
        List<IntegrityRecord> failures = this.processAllEvents();
        AlfrescoTransactionSupport.unbindResource(KEY_EVENT_SET);
        if (failures.isEmpty()) {
            return;
        }
        int failureCount = failures.size();
        StringBuilder sb = new StringBuilder(300 * failureCount);
        sb.append("Found ").append(failureCount).append(" integrity violations");
        if (this.maxErrorsPerTransaction < failureCount) {
            sb.append(" - first ").append(this.maxErrorsPerTransaction);
        }
        sb.append(":");
        int count = 0;
        for (IntegrityRecord failure : failures) {
            if (++count > this.maxErrorsPerTransaction) break;
            sb.append("\n").append(failure);
        }
        if (this.failOnViolation) {
            logger.error((Object)sb.toString());
            throw new IntegrityException(failures);
        }
        logger.warn((Object)sb.toString());
    }

    private List<IntegrityRecord> processAllEvents() {
        ArrayList<IntegrityRecord> allIntegrityResults = new ArrayList<IntegrityRecord>(0);
        Map events = (Map)AlfrescoTransactionSupport.getResource(KEY_EVENT_SET);
        if (events == null) {
            return allIntegrityResults;
        }
        ArrayList<IntegrityRecord> integrityRecords = new ArrayList<IntegrityRecord>(0);
        for (IntegrityEvent event : events.keySet()) {
            try {
                event.checkIntegrity(integrityRecords);
            }
            catch (Throwable e) {
                e.printStackTrace();
                IntegrityRecord exceptionRecord = new IntegrityRecord("" + e.getMessage());
                exceptionRecord.setTraces(Collections.singletonList(e.getStackTrace()));
                allIntegrityResults.add(exceptionRecord);
                continue;
            }
            if (this.traceOn) {
                for (IntegrityRecord integrityRecord : integrityRecords) {
                    integrityRecord.setTraces(event.getTraces());
                }
            }
            allIntegrityResults.addAll(integrityRecords);
            integrityRecords.clear();
            if (allIntegrityResults.size() < this.maxErrorsPerTransaction) continue;
            break;
        }
        return allIntegrityResults;
    }
}

