/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.InputStream;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class IntegrityTest
extends TestCase {
    private static Log logger = LogFactory.getLog(IntegrityTest.class);
    public static final String NAMESPACE = "http://www.alfresco.org/test/IntegrityTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TEST_TYPE_WITHOUT_ANYTHING = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "typeWithoutAnything");
    public static final QName TEST_TYPE_WITH_ASPECT = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "typeWithAspect");
    public static final QName TEST_TYPE_WITH_PROPERTIES = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "typeWithProperties");
    public static final QName TEST_TYPE_WITH_ASSOCS = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "typeWithAssocs");
    public static final QName TEST_TYPE_WITH_CHILD_ASSOCS = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "typeWithChildAssocs");
    public static final QName TEST_ASSOC_NODE_ZEROMANY_ZEROMANY = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "assoc-0to* - 0to*");
    public static final QName TEST_ASSOC_CHILD_ZEROMANY_ZEROMANY = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "child-0to* - 0to*");
    public static final QName TEST_ASSOC_NODE_ONE_ONE = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "assoc-1to1 - 1to1");
    public static final QName TEST_ASSOC_CHILD_ONE_ONE = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "child-1to1 - 1to1");
    public static final QName TEST_ASSOC_ASPECT_ONE_ONE = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "aspect-assoc-1to1 - 1to1");
    public static final QName TEST_ASPECT_WITH_PROPERTIES = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "aspectWithProperties");
    public static final QName TEST_ASPECT_WITH_ASSOC = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "aspectWithAssoc");
    public static final QName TEST_PROP_TEXT_A = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-text-a");
    public static final QName TEST_PROP_TEXT_B = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-text-b");
    public static final QName TEST_PROP_TEXT_C = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-text-c");
    public static final QName TEST_PROP_INT_A = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-int-a");
    public static final QName TEST_PROP_INT_B = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-int-b");
    public static final QName TEST_PROP_INT_C = QName.createQName("http://www.alfresco.org/test/IntegrityTest", "prop-int-c");
    public static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private IntegrityChecker integrityChecker;
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private PropertyMap allProperties;
    private UserTransaction txn;
    private AuthenticationComponent authenticationComponent;

    public void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/node/integrity/IntegrityTest_model.xml");
        IntegrityTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        this.integrityChecker = (IntegrityChecker)ctx.getBean("integrityChecker");
        this.integrityChecker.setEnabled(true);
        this.integrityChecker.setFailOnViolation(true);
        this.integrityChecker.setTraceOn(true);
        this.integrityChecker.setMaxErrorsPerTransaction(100);
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        this.txn = transactionService.getUserTransaction();
        this.txn.begin();
        StoreRef storeRef = new StoreRef("workspace", this.getName());
        if (!this.nodeService.exists(storeRef)) {
            this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.allProperties = new PropertyMap();
        this.allProperties.put(TEST_PROP_TEXT_A, "ABC");
        this.allProperties.put(TEST_PROP_TEXT_B, "DEF");
        this.allProperties.put(TEST_PROP_INT_A, "123");
        this.allProperties.put(TEST_PROP_INT_B, "456");
    }

    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private NodeRef createNode(String name, QName type, PropertyMap properties) {
        return this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(NAMESPACE, name), type, properties).getChildRef();
    }

    private void checkIntegrityNoFailure() throws Exception {
        this.integrityChecker.checkIntegrity();
    }

    private void checkIntegrityExpectFailure(String failureMsg, int expectedCount) {
        block2: {
            try {
                this.integrityChecker.checkIntegrity();
                IntegrityTest.fail((String)failureMsg);
            }
            catch (IntegrityException e) {
                if (expectedCount < 0) break block2;
                IntegrityTest.assertEquals((String)"Incorrect number of integrity records generated", (int)expectedCount, (int)e.getRecords().size());
            }
        }
    }

    public void testSetUp() throws Exception {
        IntegrityTest.assertNotNull((String)"Static IntegrityChecker not created", (Object)this.integrityChecker);
    }

    public void testCreateWithoutProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_PROPERTIES, null);
        this.checkIntegrityExpectFailure("Failed to detect missing properties", 1);
    }

    public void testCreateWithProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_PROPERTIES, this.allProperties);
        this.checkIntegrityNoFailure();
    }

    public void testMandatoryPropertiesRemoved() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_PROPERTIES, this.allProperties);
        PropertyMap properties = new PropertyMap();
        this.nodeService.setProperties(nodeRef, properties);
        this.checkIntegrityExpectFailure("Failed to detect missing removed properties", 1);
    }

    public void testCreateWithoutPropertiesForAspect() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_ASPECT, null);
        this.checkIntegrityExpectFailure("Failed to detect missing properties for aspect", 1);
    }

    public void testCreateWithPropertiesForAspect() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_ASPECT, this.allProperties);
        this.checkIntegrityNoFailure();
    }

    public void testRemoveMandatoryAspect() throws Exception {
        NodeRef nodeRef = this.createNode("abc", TEST_TYPE_WITH_ASPECT, this.allProperties);
        this.nodeService.removeAspect(nodeRef, TEST_ASPECT_WITH_PROPERTIES);
        this.checkIntegrityExpectFailure("Failed to removal of mandatory aspect", 1);
    }

    public void testCreateTargetOfAssocsWithMandatorySourcesPresent() throws Exception {
        NodeRef targetAndChild = this.createNode("targetAndChild", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef source = this.createNode("source", TEST_TYPE_WITH_ASSOCS, null);
        this.nodeService.createAssociation(source, targetAndChild, TEST_ASSOC_NODE_ONE_ONE);
        NodeRef parent = this.createNode("parent", TEST_TYPE_WITH_CHILD_ASSOCS, null);
        this.nodeService.addChild(parent, targetAndChild, TEST_ASSOC_CHILD_ONE_ONE, QName.createQName(NAMESPACE, "mandatoryChild"));
        NodeRef aspected = this.createNode("aspectNode", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addAspect(aspected, TEST_ASPECT_WITH_ASSOC, null);
        this.nodeService.createAssociation(aspected, targetAndChild, TEST_ASSOC_ASPECT_ONE_ONE);
        this.checkIntegrityNoFailure();
    }

    public void testCreateTargetOfAssocsWithMandatorySourcesMissing() throws Exception {
        logger.error((Object)"Method commented out: testCreateTargetOfAssocsWithMandatorySourcesMissing");
    }

    public void testRemoveSourcesOfMandatoryAssocs() throws Exception {
        logger.error((Object)"Method commented out: testRemoveSourcesOfMandatoryAssocs");
    }

    public void testDuplicateTargetAssocs() throws Exception {
        NodeRef parent = this.createNode("source", TEST_TYPE_WITH_CHILD_ASSOCS, null);
        NodeRef child1 = this.createNode("child1", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef child2 = this.createNode("child2", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef child3 = this.createNode("child3", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addChild(parent, child3, TEST_ASSOC_CHILD_ONE_ONE, QName.createQName(NAMESPACE, "mandatoryChild"));
        this.nodeService.addChild(parent, child1, TEST_ASSOC_CHILD_ZEROMANY_ZEROMANY, QName.createQName(NAMESPACE, "dupli_cate"));
        this.nodeService.addChild(parent, child2, TEST_ASSOC_CHILD_ZEROMANY_ZEROMANY, QName.createQName(NAMESPACE, "dupli_cate"));
        this.checkIntegrityExpectFailure("Failed to detect duplicate association names", 1);
    }

    public void testCreateSourceOfAssocsWithMandatoryTargetsPresent() throws Exception {
        NodeRef source = this.createNode("abc", TEST_TYPE_WITH_ASSOCS, null);
        NodeRef target = this.createNode("target", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.createAssociation(source, target, TEST_ASSOC_NODE_ONE_ONE);
        NodeRef parent = this.createNode("parent", TEST_TYPE_WITH_CHILD_ASSOCS, null);
        NodeRef child = this.createNode("child", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addChild(parent, child, TEST_ASSOC_CHILD_ONE_ONE, QName.createQName(NAMESPACE, "one-to-one"));
        NodeRef aspectSource = this.createNode("aspectSource", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addAspect(aspectSource, TEST_ASPECT_WITH_ASSOC, null);
        NodeRef aspectTarget = this.createNode("aspectTarget", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.createAssociation(aspectSource, aspectTarget, TEST_ASSOC_ASPECT_ONE_ONE);
        this.checkIntegrityNoFailure();
    }

    public void testCreateSourceOfAssocsWithMandatoryTargetsMissing() throws Exception {
        NodeRef source = this.createNode("abc", TEST_TYPE_WITH_ASSOCS, null);
        NodeRef parent = this.createNode("parent", TEST_TYPE_WITH_CHILD_ASSOCS, null);
        NodeRef aspectSource = this.createNode("aspectSource", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addAspect(aspectSource, TEST_ASPECT_WITH_ASSOC, null);
        this.checkIntegrityExpectFailure("Failed to detect missing assoc targets", 3);
    }

    public void testRemoveTargetsOfMandatoryAssocs() throws Exception {
        logger.error((Object)"Method commented out: testRemoveTargetsOfMandatoryAssocs");
    }

    public void testExcessTargetsOfOneToOneAssocs() throws Exception {
        NodeRef source = this.createNode("abc", TEST_TYPE_WITH_ASSOCS, null);
        NodeRef target1 = this.createNode("target1", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef target2 = this.createNode("target2", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.createAssociation(source, target1, TEST_ASSOC_NODE_ONE_ONE);
        this.nodeService.createAssociation(source, target2, TEST_ASSOC_NODE_ONE_ONE);
        NodeRef parent = this.createNode("parent", TEST_TYPE_WITH_CHILD_ASSOCS, null);
        NodeRef child1 = this.createNode("child1", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef child2 = this.createNode("child2", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addChild(parent, child1, TEST_ASSOC_CHILD_ONE_ONE, QName.createQName(NAMESPACE, "one-to-one-first"));
        this.nodeService.addChild(parent, child2, TEST_ASSOC_CHILD_ONE_ONE, QName.createQName(NAMESPACE, "one-to-one-second"));
        NodeRef aspectSource = this.createNode("aspectSource", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.addAspect(aspectSource, TEST_ASPECT_WITH_ASSOC, null);
        NodeRef aspectTarget1 = this.createNode("aspectTarget1", TEST_TYPE_WITHOUT_ANYTHING, null);
        NodeRef aspectTarget2 = this.createNode("aspectTarget2", TEST_TYPE_WITHOUT_ANYTHING, null);
        this.nodeService.createAssociation(aspectSource, aspectTarget1, TEST_ASSOC_ASPECT_ONE_ONE);
        this.nodeService.createAssociation(aspectSource, aspectTarget2, TEST_ASSOC_ASPECT_ONE_ONE);
        this.checkIntegrityExpectFailure("Failed to detect excess target cardinality for one-to-one assocs", 3);
    }
}

