/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(PropertiesIntegrityEvent.class);

    protected PropertiesIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef) {
        super(nodeService, dictionaryService, nodeRef, null, null);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        NodeRef nodeRef = this.getNodeRef();
        if (!this.nodeService.exists(nodeRef)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event ignored - node gone: " + this));
            }
            eventResults.clear();
            return;
        }
        this.checkAllProperties(this.getNodeRef(), eventResults);
    }

    private void checkAllProperties(NodeRef nodeRef, List<IntegrityRecord> eventResults) {
        Map<QName, Serializable> nodeProperties = this.nodeService.getProperties(nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
        Collection<PropertyDefinition> propertyDefs = typeDef.getProperties().values();
        this.checkAllProperties(nodeRef, nodeTypeQName, propertyDefs, nodeProperties, eventResults);
        Set<QName> aspectTypeQNames = this.nodeService.getAspects(nodeRef);
        for (QName aspectTypeQName : aspectTypeQNames) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
            propertyDefs = aspectDef.getProperties().values();
            this.checkAllProperties(nodeRef, aspectTypeQName, propertyDefs, nodeProperties, eventResults);
        }
    }

    private void checkAllProperties(NodeRef nodeRef, QName typeQName, Collection<PropertyDefinition> propertyDefs, Map<QName, Serializable> nodeProperties, Collection<IntegrityRecord> eventResults) {
        if (propertyDefs == null || propertyDefs.isEmpty()) {
            return;
        }
        for (PropertyDefinition propertyDef : propertyDefs) {
            QName propertyQName = propertyDef.getName();
            if (propertyDef.isMandatory() && propertyDef.isMandatoryEnforced() && !nodeProperties.containsKey(propertyQName)) {
                IntegrityRecord result = new IntegrityRecord("Mandatory property not set: \n   Node: " + nodeRef + "\n" + "   Type: " + typeQName + "\n" + "   Property: " + propertyQName);
                eventResults.add(result);
                continue;
            }
            Serializable propertyValue = nodeProperties.get(propertyQName);
            List<ConstraintDefinition> constraintDefs = propertyDef.getConstraints();
            for (ConstraintDefinition constraintDef : constraintDefs) {
                Constraint constraint = constraintDef.getConstraint();
                try {
                    constraint.evaluate(propertyValue);
                }
                catch (ConstraintException e) {
                    IntegrityRecord result = new IntegrityRecord("Invalid property value: \n   Node: " + nodeRef + "\n" + "   Type: " + typeQName + "\n" + "   Property: " + propertyQName + "\n" + "   Constraint: " + e.getMessage());
                    eventResults.add(result);
                }
            }
        }
    }
}

