/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.ownable.impl;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnableServiceImpl
implements OwnableService,
InitializingBean {
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private SimpleCache<NodeRef, String> nodeOwnerCache;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setNodeOwnerCache(SimpleCache<NodeRef, String> ownerCache) {
        this.nodeOwnerCache = ownerCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.nodeService == null) {
            throw new IllegalArgumentException("Property 'nodeService' has not been set");
        }
        if (this.authenticationService == null) {
            throw new IllegalArgumentException("Property 'authenticationService' has not been set");
        }
        if (this.nodeOwnerCache == null) {
            throw new IllegalArgumentException("Property 'nodeOwnerCache' has not been set");
        }
    }

    @Override
    public String getOwner(NodeRef nodeRef) {
        String userName = this.nodeOwnerCache.get(nodeRef);
        if (userName == null) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
                userName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_OWNER));
            } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_AUDITABLE)) {
                userName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
            }
            this.nodeOwnerCache.put(nodeRef, userName);
        }
        return userName;
    }

    @Override
    public void setOwner(NodeRef nodeRef, String userName) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(1, 1.0f);
            properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)userName));
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_OWNABLE, properties);
        } else {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_OWNER, (Serializable)((Object)userName));
        }
        this.nodeOwnerCache.put(nodeRef, userName);
    }

    @Override
    public void takeOwnership(NodeRef nodeRef) {
        this.setOwner(nodeRef, this.authenticationService.getCurrentUserName());
    }

    @Override
    public boolean hasOwner(NodeRef nodeRef) {
        return this.getOwner(nodeRef) != null;
    }
}

