/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class BehaviourFilterImpl
implements BehaviourFilter {
    ThreadLocal<List<QName>> classFilter = new ThreadLocal();
    ThreadLocal<Map<NodeRef, List<QName>>> nodeRefFilter = new ThreadLocal();
    private DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public boolean disableBehaviour(QName className) {
        boolean alreadyDisabled;
        List<QName> classNames = this.classFilter.get();
        if (classNames == null) {
            classNames = new ArrayList<QName>();
            this.classFilter.set(classNames);
        }
        if (!(alreadyDisabled = classNames.contains(className))) {
            classNames.add(className);
        }
        return alreadyDisabled;
    }

    public boolean disableBehaviour(NodeRef nodeRef, QName className) {
        boolean alreadyDisabled;
        List<QName> classNames;
        Map<NodeRef, List<QName>> filters = this.nodeRefFilter.get();
        if (filters == null) {
            filters = new HashMap<NodeRef, List<QName>>();
            this.nodeRefFilter.set(filters);
        }
        if ((classNames = filters.get(nodeRef)) == null) {
            classNames = new ArrayList<QName>();
            filters.put(nodeRef, classNames);
        }
        if (!(alreadyDisabled = classNames.contains(className))) {
            classNames.add(className);
        }
        return alreadyDisabled;
    }

    public void enableBehaviour(QName className) {
        List<QName> classNames = this.classFilter.get();
        if (classNames != null) {
            classNames.remove(className);
        }
    }

    public void enableBehaviour(NodeRef nodeRef, QName className) {
        Map<NodeRef, List<QName>> filters = this.nodeRefFilter.get();
        if (filters != null) {
            List<QName> classNames = filters.get(nodeRef);
            if (classNames != null) {
                classNames.remove(className);
            }
            if (classNames.size() == 0) {
                filters.remove(nodeRef);
            }
        }
    }

    public void enableBehaviours(NodeRef nodeRef) {
        Map<NodeRef, List<QName>> filters = this.nodeRefFilter.get();
        if (filters != null) {
            filters.remove(nodeRef);
        }
    }

    public void enableAllBehaviours() {
        Map<NodeRef, List<QName>> filters = this.nodeRefFilter.get();
        if (filters != null) {
            filters.clear();
        }
    }

    public boolean isEnabled(NodeRef nodeRef, QName className) {
        List<QName> nodeClassFilters;
        if (!this.isEnabled(className)) {
            return false;
        }
        Map<NodeRef, List<QName>> nodeFilters = this.nodeRefFilter.get();
        if (nodeFilters != null && (nodeClassFilters = nodeFilters.get(nodeRef)) != null) {
            boolean filtered = nodeClassFilters.contains(className);
            if (filtered) {
                return false;
            }
            for (QName filterName : nodeClassFilters) {
                filtered = this.dictionaryService.isSubClass(className, filterName);
                if (!filtered) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEnabled(QName className) {
        List<QName> classFilters = this.classFilter.get();
        if (classFilters != null) {
            boolean filtered = classFilters.contains(className);
            if (filtered) {
                return false;
            }
            for (QName filterName : classFilters) {
                filtered = this.dictionaryService.isSubClass(className, filterName);
                if (!filtered) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isActivated() {
        List<QName> classFilters = this.classFilter.get();
        Map<NodeRef, List<QName>> nodeFilters = this.nodeRefFilter.get();
        return classFilters != null && !classFilters.isEmpty() || nodeFilters != null && !nodeFilters.isEmpty();
    }
}

