/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BehaviourMap<B extends BehaviourBinding> {
    private Map<B, BehaviourDefinition<B>> index = new HashMap<B, BehaviourDefinition<B>>();
    private List<BehaviourChangeObserver<B>> observers = new ArrayList<BehaviourChangeObserver<B>>();

    BehaviourMap() {
    }

    public void put(BehaviourDefinition<B> behaviourDefinition) {
        B binding = behaviourDefinition.getBinding();
        this.index.put(binding, behaviourDefinition);
        for (BehaviourChangeObserver<B> listener : this.observers) {
            listener.addition(binding, behaviourDefinition.getBehaviour());
        }
    }

    public BehaviourDefinition<B> get(B binding) {
        return this.index.get(binding);
    }

    public Collection<BehaviourDefinition<B>> getAll() {
        return this.index.values();
    }

    public int size() {
        return this.index.size();
    }

    public void addChangeObserver(BehaviourChangeObserver<B> observer) {
        this.observers.add(observer);
    }
}

