/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.BehaviourMap;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ServiceBehaviourBinding;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassBehaviourIndex<B extends ClassBehaviourBinding>
implements BehaviourIndex<B> {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private BehaviourMap<B> classMap = new BehaviourMap();
    private BehaviourMap<ServiceBehaviourBinding> serviceMap = new BehaviourMap();
    private List<BehaviourChangeObserver<B>> observers = new ArrayList<BehaviourChangeObserver<B>>();
    private BehaviourFilter filter = null;

    ClassBehaviourIndex(BehaviourFilter filter) {
        this.classMap.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.addition(binding, behaviour);
                }
            }
        });
        this.serviceMap.addChangeObserver(new BehaviourChangeObserver<ServiceBehaviourBinding>(){

            @Override
            public void addition(ServiceBehaviourBinding binding, Behaviour behaviour) {
                for (BehaviourChangeObserver listener : ClassBehaviourIndex.this.observers) {
                    listener.addition(null, behaviour);
                }
            }
        });
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BehaviourDefinition> getAll() {
        this.lock.readLock().lock();
        try {
            ArrayList<BehaviourDefinition> all = new ArrayList<BehaviourDefinition>(this.classMap.size() + this.serviceMap.size());
            all.addAll(this.classMap.getAll());
            all.addAll(this.serviceMap.getAll());
            ArrayList<BehaviourDefinition> arrayList = all;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BehaviourDefinition> find(B binding) {
        this.lock.readLock().lock();
        try {
            ArrayList<BehaviourDefinition> behaviours = new ArrayList<BehaviourDefinition>();
            boolean isEnabled = true;
            if (this.filter != null) {
                NodeRef nodeRef = ((ClassBehaviourBinding)binding).getNodeRef();
                QName className = ((ClassBehaviourBinding)binding).getClassQName();
                boolean bl = isEnabled = nodeRef == null ? this.filter.isEnabled(className) : this.filter.isEnabled(nodeRef, className);
            }
            if (isEnabled) {
                BehaviourDefinition<B> behaviour = null;
                while (behaviour == null && binding != null) {
                    behaviour = this.classMap.get(binding);
                    if (behaviour != null) continue;
                    binding = (ClassBehaviourBinding)((ClassBehaviourBinding)binding).generaliseBinding();
                }
                if (behaviour != null) {
                    behaviours.add(behaviour);
                }
            }
            behaviours.addAll(this.serviceMap.getAll());
            ArrayList<BehaviourDefinition> arrayList = behaviours;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addChangeObserver(BehaviourChangeObserver<B> observer) {
        this.observers.add(observer);
    }

    @Override
    public BehaviourFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClassBehaviour(BehaviourDefinition<B> behaviour) {
        this.lock.writeLock().lock();
        try {
            this.classMap.put(behaviour);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putServiceBehaviour(BehaviourDefinition<ServiceBehaviourBinding> behaviour) {
        this.lock.writeLock().lock();
        try {
            this.serviceMap.put(behaviour);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

