/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

class ClassFeatureBehaviourBinding
extends ClassBehaviourBinding {
    private QName featureQName;
    private QName activeFeatureQName;
    private static final QName ALL_FEATURES = QName.createQName("", "*");

    ClassFeatureBehaviourBinding(DictionaryService dictionary, NodeRef nodeRef, QName classQName, QName featureQName) {
        this(dictionary, nodeRef, classQName, featureQName, featureQName);
    }

    ClassFeatureBehaviourBinding(DictionaryService dictionary, QName classQName, QName featureQName) {
        this(dictionary, null, classQName, featureQName, featureQName);
    }

    ClassFeatureBehaviourBinding(DictionaryService dictionary, NodeRef nodeRef, QName classQName) {
        this(dictionary, nodeRef, classQName, ALL_FEATURES);
    }

    ClassFeatureBehaviourBinding(DictionaryService dictionary, QName classQName) {
        this(dictionary, null, classQName, ALL_FEATURES);
    }

    private ClassFeatureBehaviourBinding(DictionaryService dictionary, NodeRef nodeRef, QName classQName, QName featureQName, QName activeFeatureQName) {
        super(dictionary, nodeRef, classQName);
        this.featureQName = featureQName;
        this.activeFeatureQName = activeFeatureQName;
    }

    public BehaviourBinding generaliseBinding() {
        ClassFeatureBehaviourBinding generalisedBinding = null;
        ClassDefinition classDefinition = this.getDictionary().getClass(this.getClassQName());
        if (this.activeFeatureQName.equals(ALL_FEATURES)) {
            QName parentClassName = classDefinition.getParentName();
            if (parentClassName != null) {
                generalisedBinding = new ClassFeatureBehaviourBinding(this.getDictionary(), this.getNodeRef(), parentClassName, this.featureQName, this.featureQName);
            }
        } else {
            generalisedBinding = new ClassFeatureBehaviourBinding(this.getDictionary(), this.getNodeRef(), this.getClassQName(), this.featureQName, ALL_FEATURES);
        }
        return generalisedBinding;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassFeatureBehaviourBinding)) {
            return false;
        }
        return this.getClassQName().equals(((ClassFeatureBehaviourBinding)obj).getClassQName()) && this.activeFeatureQName.equals(((ClassFeatureBehaviourBinding)obj).activeFeatureQName);
    }

    public int hashCode() {
        return 37 * this.getClassQName().hashCode() + this.activeFeatureQName.hashCode();
    }

    public String toString() {
        return "ClassFeatureBinding[class=" + this.getClassQName() + ";feature=" + this.activeFeatureQName + "]";
    }
}

