/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBehaviour
implements Behaviour {
    private Object instance;
    private String method;
    private Behaviour.NotificationFrequency frequency;
    private Map<Class, Object> proxies = new HashMap<Class, Object>();
    private StackThreadLocal disabled = new StackThreadLocal();

    public JavaBehaviour(Object instance, String method) {
        this(instance, method, Behaviour.NotificationFrequency.EVERY_EVENT);
    }

    public JavaBehaviour(Object instance, String method, Behaviour.NotificationFrequency frequency) {
        ParameterCheck.mandatory((String)"Instance", (Object)instance);
        ParameterCheck.mandatory((String)"Method", (Object)method);
        this.instance = instance;
        this.method = method;
        this.frequency = frequency;
    }

    @Override
    public synchronized <T> T getInterface(Class<T> policy) {
        ParameterCheck.mandatory((String)"Policy class", policy);
        Object proxy = this.proxies.get(policy);
        if (proxy == null) {
            InvocationHandler handler = this.getInvocationHandler(this.instance, this.method, policy);
            proxy = Proxy.newProxyInstance(policy.getClassLoader(), new Class[]{policy}, handler);
            this.proxies.put(policy, proxy);
        }
        return (T)proxy;
    }

    @Override
    public void disable() {
        Stack stack = (Stack)this.disabled.get();
        stack.push(this.hashCode());
    }

    @Override
    public void enable() {
        Stack stack = (Stack)this.disabled.get();
        if (!((Integer)stack.peek()).equals(this.hashCode())) {
            throw new PolicyException("Cannot enable " + this.toString() + " at this time - mismatched with disable calls");
        }
        stack.pop();
    }

    @Override
    public boolean isEnabled() {
        Stack stack = (Stack)this.disabled.get();
        return stack.search(this.hashCode()) == -1;
    }

    @Override
    public Behaviour.NotificationFrequency getNotificationFrequency() {
        return this.frequency;
    }

    public String toString() {
        return "Java method[class=" + this.instance.getClass().getName() + ", method=" + this.method + "]";
    }

    private <T> InvocationHandler getInvocationHandler(Object instance, String method, Class<T> policyIF) {
        Method[] policyIFMethods = policyIF.getMethods();
        if (policyIFMethods.length != 1) {
            throw new PolicyException("Policy interface " + policyIF.getCanonicalName() + " must have only one method");
        }
        try {
            Class<?> instanceClass = instance.getClass();
            Method delegateMethod = instanceClass.getMethod(method, policyIFMethods[0].getParameterTypes());
            return new JavaMethodInvocationHandler(this, delegateMethod);
        }
        catch (NoSuchMethodException e) {
            throw new PolicyException("Method " + method + " not found or accessible on " + instance.getClass(), e);
        }
    }

    private static class JavaMethodInvocationHandler
    implements InvocationHandler {
        private JavaBehaviour behaviour;
        private Method delegateMethod;

        private JavaMethodInvocationHandler(JavaBehaviour behaviour, Method delegateMethod) {
            this.behaviour = behaviour;
            this.delegateMethod = delegateMethod;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                if (Proxy.isProxyClass(args[0].getClass())) {
                    return this.equals(Proxy.getInvocationHandler(args[0]));
                }
                return false;
            }
            if (this.behaviour.isEnabled()) {
                try {
                    this.behaviour.disable();
                    Object object = this.delegateMethod.invoke(this.behaviour.instance, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                finally {
                    this.behaviour.enable();
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof JavaMethodInvocationHandler)) {
                return false;
            }
            JavaMethodInvocationHandler other = (JavaMethodInvocationHandler)obj;
            return this.behaviour.instance.equals(other.behaviour.instance) && this.delegateMethod.equals(other.delegateMethod);
        }

        public int hashCode() {
            return 37 * this.behaviour.instance.hashCode() + this.delegateMethod.hashCode();
        }

        public String toString() {
            return "JavaBehaviour[instance=" + this.behaviour.instance.hashCode() + ", method=" + this.delegateMethod.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StackThreadLocal
    extends ThreadLocal<Stack<Integer>> {
        private StackThreadLocal() {
        }

        @Override
        protected Stack<Integer> initialValue() {
            return new Stack<Integer>();
        }
    }
}

