/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.policy.AssociationPolicy;
import org.alfresco.repo.policy.AssociationPolicyDelegate;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.repo.policy.PropertyPolicyDelegate;
import org.alfresco.service.namespace.QName;

public class PolicyComponentTest
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/policy/policycomponenttest_model.xml";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
    private static QName BASE_TYPE = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "base");
    private static QName BASE_PROP_A = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "base_a");
    private static QName BASE_ASSOC_A = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "base_assoc_a");
    private static QName FILE_TYPE = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "file");
    private static QName FILE_PROP_B = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "file_b");
    private static QName FOLDER_TYPE = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "folder");
    private static QName FOLDER_PROP_D = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "folder_d");
    private static QName TEST_ASPECT = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "aspect");
    private static QName ASPECT_PROP_A = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "aspect_a");
    private static QName INVALID_TYPE = QName.createQName("http://www.alfresco.org/test/policycomponenttest/1.0", "classdoesnotexist");
    private PolicyComponent policyComponent = null;

    protected void setUp() throws Exception {
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.bootstrap();
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDAO);
        this.policyComponent = new PolicyComponentImpl(dictionary);
    }

    public void testJavaBehaviour() {
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validTest");
        TestClassPolicy policy = validBehaviour.getInterface(TestClassPolicy.class);
        PolicyComponentTest.assertNotNull((Object)policy);
        String result = policy.test("argument");
        PolicyComponentTest.assertEquals((String)"ValidTest: argument", (String)result);
    }

    public void testRegisterDefinitions() {
        ClassPolicyDelegate<ClassPolicy> delegate;
        try {
            delegate = this.policyComponent.registerClassPolicy(InvalidMetaDataPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch hidden metadata");
        }
        catch (PolicyException e) {
            // empty catch block
        }
        try {
            delegate = this.policyComponent.registerClassPolicy(NoMethodPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch no methods defined in policy");
        }
        catch (PolicyException e) {
            // empty catch block
        }
        try {
            delegate = this.policyComponent.registerClassPolicy(MultiMethodPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch multiple methods defined in policy");
        }
        catch (PolicyException e) {
            // empty catch block
        }
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        boolean isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertFalse((boolean)isRegistered);
        ClassPolicyDelegate<TestClassPolicy> delegate2 = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        PolicyComponentTest.assertNotNull(delegate2);
        isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertTrue((boolean)isRegistered);
        PolicyDefinition<Policy> definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertNotNull(definition);
        PolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getName());
        PolicyComponentTest.assertEquals((Object)((Object)PolicyType.Class), (Object)((Object)definition.getType()));
        PolicyComponentTest.assertEquals(TestClassPolicy.class, definition.getPolicyInterface());
    }

    public void testBindBehaviour() {
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validTest");
        try {
            this.policyComponent.bindClassBehaviour(null, FILE_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch null policy whilst binding behaviour");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.policyComponent.bindClassBehaviour(policyName, null, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch null class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.policyComponent.bindClassBehaviour(policyName, INVALID_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch invalid class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, null);
            PolicyComponentTest.fail((String)"Failed to catch null behaviour whilst binding behaviour");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        JavaBehaviour invalidBehaviour = new JavaBehaviour((Object)this, "methoddoesnotexist");
        this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)invalidBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch invalid behaviour whilst binding behaviour");
        }
        catch (PolicyException e) {
            // empty catch block
        }
        try {
            BehaviourDefinition<ClassBehaviourBinding> definition = this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.assertNotNull(definition);
            PolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getPolicy());
            PolicyComponentTest.assertEquals((Object)FILE_TYPE, (Object)definition.getBinding().getClassQName());
        }
        catch (PolicyException e) {
            PolicyComponentTest.fail((String)"Policy exception thrown for valid behaviour");
        }
    }

    public void testClassDelegate() {
        ClassPolicyDelegate<TestClassPolicy> delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)fileBehaviour);
        Collection<TestClassPolicy> basePolicies = delegate.getList(BASE_TYPE);
        PolicyComponentTest.assertNotNull(basePolicies);
        PolicyComponentTest.assertTrue((basePolicies.size() == 0 ? 1 : 0) != 0);
        TestClassPolicy basePolicy = delegate.get(BASE_TYPE);
        PolicyComponentTest.assertNotNull((Object)basePolicy);
        Collection<TestClassPolicy> filePolicies = delegate.getList(FILE_TYPE);
        PolicyComponentTest.assertNotNull(filePolicies);
        PolicyComponentTest.assertTrue((filePolicies.size() == 1 ? 1 : 0) != 0);
        TestClassPolicy filePolicy = delegate.get(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        PolicyComponentTest.assertEquals((Object)filePolicies.iterator().next(), (Object)filePolicy);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindClassBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection<TestClassPolicy> file2Policies = delegate.getList(FILE_TYPE);
        PolicyComponentTest.assertNotNull(file2Policies);
        PolicyComponentTest.assertTrue((file2Policies.size() == 2 ? 1 : 0) != 0);
        TestClassPolicy filePolicy2 = delegate.get(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
    }

    public void testClassOverride() {
        ClassPolicyDelegate<TestClassPolicy> delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindClassBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        TestClassPolicy basePolicy = delegate.get(BASE_TYPE);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestClassPolicy filePolicy = delegate.get(FILE_TYPE);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestClassPolicy folderPolicy = delegate.get(FOLDER_TYPE);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
    }

    public void testClassCache() {
        ClassPolicyDelegate<TestClassPolicy> delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindClassBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        TestClassPolicy basePolicy = delegate.get(BASE_TYPE);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestClassPolicy filePolicy = delegate.get(FILE_TYPE);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestClassPolicy folderPolicy = delegate.get(FOLDER_TYPE);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestClassPolicy basePolicy2 = delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy == basePolicy2 ? 1 : 0) != 0);
        TestClassPolicy filePolicy2 = delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy == filePolicy2 ? 1 : 0) != 0);
        TestClassPolicy folderPolicy2 = delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy == folderPolicy2 ? 1 : 0) != 0);
        JavaBehaviour newBaseBehaviour = new JavaBehaviour((Object)this, "newBaseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)newBaseBehaviour);
        TestClassPolicy basePolicy3 = delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy3 != basePolicy2 ? 1 : 0) != 0);
        String baseResult3 = basePolicy3.test("base");
        PolicyComponentTest.assertEquals((String)"NewBase: base", (String)baseResult3);
        TestClassPolicy filePolicy3 = delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy3 != filePolicy2 ? 1 : 0) != 0);
        String fileResult3 = filePolicy3.test("file");
        PolicyComponentTest.assertEquals((String)"NewBase: file", (String)fileResult3);
        TestClassPolicy folderPolicy3 = delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy3 == folderPolicy2 ? 1 : 0) != 0);
        String folderResult3 = folderPolicy3.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult3);
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)fileBehaviour);
        TestClassPolicy basePolicy4 = delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy4 == basePolicy3 ? 1 : 0) != 0);
        String baseResult4 = basePolicy4.test("base");
        PolicyComponentTest.assertEquals((String)"NewBase: base", (String)baseResult4);
        TestClassPolicy filePolicy4 = delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy4 != filePolicy3 ? 1 : 0) != 0);
        String fileResult4 = filePolicy4.test("file");
        PolicyComponentTest.assertEquals((String)"File: file", (String)fileResult4);
        TestClassPolicy folderPolicy4 = delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy4 == folderPolicy4 ? 1 : 0) != 0);
        String folderResult4 = folderPolicy4.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult4);
    }

    public void testPropertyDelegate() {
        PropertyPolicyDelegate<TestPropertyPolicy> delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FILE_TYPE, FILE_PROP_B, fileBehaviour);
        Collection<TestPropertyPolicy> basePolicies = delegate.getList(BASE_TYPE, BASE_PROP_A);
        PolicyComponentTest.assertNotNull(basePolicies);
        PolicyComponentTest.assertTrue((basePolicies.size() == 0 ? 1 : 0) != 0);
        TestPropertyPolicy basePolicy = delegate.get(BASE_TYPE, BASE_PROP_A);
        PolicyComponentTest.assertNotNull((Object)basePolicy);
        Collection<TestPropertyPolicy> filePolicies = delegate.getList(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull(filePolicies);
        PolicyComponentTest.assertTrue((filePolicies.size() == 1 ? 1 : 0) != 0);
        TestPropertyPolicy filePolicy = delegate.get(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        PolicyComponentTest.assertEquals((Object)filePolicies.iterator().next(), (Object)filePolicy);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindPropertyBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection<TestPropertyPolicy> file2Policies = delegate.getList(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull(file2Policies);
        PolicyComponentTest.assertTrue((file2Policies.size() == 2 ? 1 : 0) != 0);
        TestPropertyPolicy filePolicy2 = delegate.get(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
    }

    public void testPropertyOverride() {
        PropertyPolicyDelegate<TestPropertyPolicy> delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, BASE_PROP_A, baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, BASE_PROP_A, folderBehaviour);
        JavaBehaviour folderBehaviourD = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, folderBehaviourD);
        TestPropertyPolicy basePolicy = delegate.get(BASE_TYPE, BASE_PROP_A);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestPropertyPolicy filePolicy = delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = delegate.get(FOLDER_TYPE, BASE_PROP_A);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestPropertyPolicy folderPolicy2 = delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult2);
    }

    public void testPropertyWildcard() {
        PropertyPolicyDelegate<TestPropertyPolicy> delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        JavaBehaviour aspectBehaviour = new JavaBehaviour((Object)this, "aspectTest");
        this.policyComponent.bindPropertyBehaviour(policyName, TEST_ASPECT, (Behaviour)aspectBehaviour);
        TestPropertyPolicy basePolicy = delegate.get(BASE_TYPE, BASE_PROP_A);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestPropertyPolicy filePolicy = delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = delegate.get(FOLDER_TYPE, BASE_PROP_A);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestPropertyPolicy folderPolicy2 = delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult2);
        TestPropertyPolicy aspectPolicy = delegate.get(TEST_ASPECT, ASPECT_PROP_A);
        String aspectResult = aspectPolicy.test("aspect_prop_a");
        PolicyComponentTest.assertEquals((String)"Aspect: aspect_prop_a", (String)aspectResult);
        TestPropertyPolicy aspectPolicy2 = delegate.get(TEST_ASPECT, FOLDER_PROP_D);
        String aspectResult2 = aspectPolicy2.test("aspect_folder_d");
        PolicyComponentTest.assertEquals((String)"Aspect: aspect_folder_d", (String)aspectResult2);
        JavaBehaviour folderDBehaviour = new JavaBehaviour((Object)this, "folderDTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, folderDBehaviour);
        TestPropertyPolicy folderPolicy3 = delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult3 = folderPolicy3.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult3);
    }

    public void testPropertyCache() {
        PropertyPolicyDelegate<TestPropertyPolicy> delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        JavaBehaviour folderDBehaviour = new JavaBehaviour((Object)this, "folderDTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, folderDBehaviour);
        JavaBehaviour aspectBehaviour = new JavaBehaviour((Object)this, "aspectTest");
        this.policyComponent.bindPropertyBehaviour(policyName, TEST_ASPECT, (Behaviour)aspectBehaviour);
        TestPropertyPolicy filePolicy = delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult);
        JavaBehaviour newBaseBehaviour = new JavaBehaviour((Object)this, "newBaseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)newBaseBehaviour);
        TestPropertyPolicy filePolicy2 = delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult2 = filePolicy2.test("file");
        PolicyComponentTest.assertEquals((String)"NewBase: file", (String)fileResult2);
        TestPropertyPolicy folderPolicy2 = delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult2);
    }

    public void testAssociationDelegate() {
        AssociationPolicyDelegate<TestAssociationPolicy> delegate = this.policyComponent.registerAssociationPolicy(TestAssociationPolicy.class);
        QName policyName = QName.createQName(TEST_NAMESPACE, "test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindAssociationBehaviour(policyName, BASE_TYPE, BASE_ASSOC_A, baseBehaviour);
        Collection<TestAssociationPolicy> filePolicies = delegate.getList(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull(filePolicies);
        PolicyComponentTest.assertTrue((filePolicies.size() == 1 ? 1 : 0) != 0);
        TestAssociationPolicy filePolicy = delegate.get(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindAssociationBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection<TestAssociationPolicy> file2Policies = delegate.getList(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull(file2Policies);
        PolicyComponentTest.assertTrue((file2Policies.size() == 2 ? 1 : 0) != 0);
        TestAssociationPolicy filePolicy2 = delegate.get(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
    }

    public String validTest(String argument) {
        return "ValidTest: " + argument;
    }

    public String baseTest(String argument) {
        return "Base: " + argument;
    }

    public String newBaseTest(String argument) {
        return "NewBase: " + argument;
    }

    public String fileTest(String argument) {
        return "File: " + argument;
    }

    public String folderTest(String argument) {
        return "Folder: " + argument;
    }

    public String aspectTest(String argument) {
        return "Aspect: " + argument;
    }

    public String folderDTest(String argument) {
        return "FolderD: " + argument;
    }

    public String serviceTest(String argument) {
        return "Service: " + argument;
    }

    public static interface MultiMethodPolicy
    extends ClassPolicy {
        public void a();

        public void b();
    }

    public static interface NoMethodPolicy
    extends ClassPolicy {
    }

    public static interface InvalidMetaDataPolicy
    extends ClassPolicy {
        public static final int NAMESPACE = 0;

        public String test(String var1);
    }

    public static interface TestAssociationPolicy
    extends AssociationPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }

    public static interface TestPropertyPolicy
    extends PropertyPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }

    public static interface TestClassPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }
}

