/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.repo.rule.RuleImpl;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;

public class BaseRuleTest
extends BaseSpringTest {
    protected static final String RULE_TYPE_NAME = "inbound";
    protected static final String ACTION_DEF_NAME = "add-features";
    protected static final String ACTION_PROP_NAME_1 = "aspect-name";
    protected static final QName ACTION_PROP_VALUE_1 = ContentModel.ASPECT_LOCKABLE;
    protected static final String CONDITION_DEF_NAME = "compare-property-value";
    protected static final String COND_PROP_NAME_1 = "value";
    protected static final String COND_PROP_VALUE_1 = ".doc";
    protected static final String TITLE = "title";
    protected static final String DESCRIPTION = "description";
    protected NodeService nodeService;
    protected ContentService contentService;
    protected RuleService ruleService;
    protected ConfigurableService configService;
    protected AuthenticationComponent authenticationComponent;
    protected RuleType ruleType;
    protected StoreRef testStoreRef;
    protected NodeRef rootNodeRef;
    protected NodeRef nodeRef;
    protected NodeRef configFolder;
    protected ActionService actionService;
    protected TransactionService transactionService;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.configService = (ConfigurableService)this.applicationContext.getBean("configurableService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.ruleType = this.ruleService.getRuleType(RULE_TYPE_NAME);
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTAINER).getChildRef();
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    protected void addRulesAspect() {
        this.configService.makeConfigurable(this.nodeRef);
        this.nodeService.addAspect(this.nodeRef, RuleModel.ASPECT_RULES, null);
    }

    protected Rule createTestRule() {
        return this.createTestRule(false);
    }

    protected Rule createTestRule(boolean isAppliedToChildren) {
        HashMap<String, Serializable> conditionProps = new HashMap<String, Serializable>();
        conditionProps.put(COND_PROP_NAME_1, (Serializable)((Object)COND_PROP_VALUE_1));
        HashMap<String, QName> actionProps = new HashMap<String, QName>();
        actionProps.put(ACTION_PROP_NAME_1, ACTION_PROP_VALUE_1);
        Rule rule = this.ruleService.createRule(this.ruleType.getName());
        rule.setTitle(TITLE);
        rule.setDescription(DESCRIPTION);
        rule.applyToChildren(isAppliedToChildren);
        ActionCondition actionCondition = this.actionService.createActionCondition(CONDITION_DEF_NAME);
        actionCondition.setParameterValues(conditionProps);
        rule.addActionCondition(actionCondition);
        Action action = this.actionService.createAction(CONDITION_DEF_NAME);
        action.setParameterValues(conditionProps);
        rule.addAction(action);
        return rule;
    }

    protected void checkRule(RuleImpl rule, String id) {
        BaseRuleTest.assertEquals((String)id, (String)rule.getId());
        BaseRuleTest.assertEquals((String)this.ruleType.getName(), (String)rule.getRuleTypeName());
        BaseRuleTest.assertEquals((String)TITLE, (String)rule.getTitle());
        BaseRuleTest.assertEquals((String)DESCRIPTION, (String)rule.getDescription());
        List<ActionCondition> ruleConditions = rule.getActionConditions();
        BaseRuleTest.assertNotNull(ruleConditions);
        BaseRuleTest.assertEquals((int)1, (int)ruleConditions.size());
        BaseRuleTest.assertEquals((String)CONDITION_DEF_NAME, (String)ruleConditions.get(0).getActionConditionDefinitionName());
        Map<String, Serializable> condParams = ruleConditions.get(0).getParameterValues();
        BaseRuleTest.assertNotNull(condParams);
        BaseRuleTest.assertEquals((int)1, (int)condParams.size());
        BaseRuleTest.assertTrue((boolean)condParams.containsKey(COND_PROP_NAME_1));
        BaseRuleTest.assertEquals((Object)COND_PROP_VALUE_1, (Object)condParams.get(COND_PROP_NAME_1));
        List<Action> ruleActions = rule.getActions();
        BaseRuleTest.assertNotNull(ruleActions);
        BaseRuleTest.assertEquals((int)1, (int)ruleActions.size());
        BaseRuleTest.assertEquals((String)ACTION_DEF_NAME, (String)ruleActions.get(0).getActionDefinitionName());
        Map<String, Serializable> actionParams = ruleActions.get(0).getParameterValues();
        BaseRuleTest.assertNotNull(actionParams);
        BaseRuleTest.assertEquals((int)1, (int)actionParams.size());
        BaseRuleTest.assertTrue((boolean)actionParams.containsKey(ACTION_PROP_NAME_1));
        BaseRuleTest.assertEquals((Object)ACTION_PROP_VALUE_1, (Object)actionParams.get(ACTION_PROP_NAME_1));
    }
}

