/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionServiceImplTest;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleServiceCoverageTest
extends TestCase {
    static ApplicationContext applicationContext = new ClassPathXmlApplicationContext("classpath:alfresco/application-context.xml");
    private TransactionService transactionService;
    private RuleService ruleService;
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private CheckOutCheckInService cociService;
    private LockService lockService;
    private ContentService contentService;
    private ServiceRegistry serviceRegistry;
    private DictionaryDAO dictionaryDAO;
    private ActionService actionService;
    private ContentTransformerRegistry transformerRegistry;
    private CopyService copyService;
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/rulesystemtest";
    private static final QName CAT_PROP_QNAME = QName.createQName("http://www.alfresco.org/test/rulesystemtest", "region");
    private QName regionCategorisationQName;
    private NodeRef catContainer;
    private NodeRef catRoot;
    private NodeRef catRBase;
    private NodeRef catROne;
    private NodeRef catRTwo;
    private NodeRef catRThree;
    private static final String STANDARD_TEXT_CONTENT = "standardTextContent";

    protected void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.ruleService = this.serviceRegistry.getRuleService();
        this.cociService = this.serviceRegistry.getCheckOutCheckInService();
        this.lockService = this.serviceRegistry.getLockService();
        this.copyService = this.serviceRegistry.getCopyService();
        this.contentService = this.serviceRegistry.getContentService();
        this.dictionaryDAO = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        this.actionService = this.serviceRegistry.getActionService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.transformerRegistry = (ContentTransformerRegistry)applicationContext.getBean("contentTransformerRegistry");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
    }

    private Rule createRule(String ruleTypeName, String actionName, Map<String, Serializable> actionParams, String conditionName, Map<String, Serializable> conditionParams) {
        Rule rule = this.ruleService.createRule(ruleTypeName);
        ActionCondition condition = this.actionService.createActionCondition(conditionName, conditionParams);
        rule.addActionCondition(condition);
        Action action = this.actionService.createAction(actionName, actionParams);
        rule.addAction(action);
        return rule;
    }

    private void createTestCategories() {
        M2Model model = M2Model.createModel("test:rulecategory");
        model.createNamespace(TEST_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.regionCategorisationQName = QName.createQName(TEST_NAMESPACE, "Region");
        M2Aspect generalCategorisation = model.createAspect("test:" + this.regionCategorisationQName.getLocalName());
        generalCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property genCatProp = generalCategorisation.createProperty("test:region");
        genCatProp.setIndexed(true);
        genCatProp.setIndexedAtomically(true);
        genCatProp.setMandatory(true);
        genCatProp.setMultiValued(false);
        genCatProp.setStoredInIndex(true);
        genCatProp.setTokenisedInIndex(true);
        genCatProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.dictionaryDAO.putModel(model);
        this.catContainer = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.catRoot = this.nodeService.createNode(this.catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
        this.catRBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName(TEST_NAMESPACE, "Region"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catROne = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(TEST_NAMESPACE, "Europe"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRTwo = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(TEST_NAMESPACE, "RestOfWorld"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRThree = this.nodeService.createNode(this.catRTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(TEST_NAMESPACE, "US"), ContentModel.TYPE_CATEGORY).getChildRef();
    }

    public void testAsyncRuleExecution() {
        final NodeRef newNodeRef = TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<NodeRef>(){

            @Override
            public NodeRef doWork() {
                RuleServiceCoverageTest.this.nodeService.addAspect(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
                HashMap<String, QName> params = new HashMap<String, QName>(1);
                params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
                Rule rule = RuleServiceCoverageTest.this.createRule("inbound", "add-features", params, "no-condition", null);
                rule.setExecuteAsynchronously(true);
                RuleServiceCoverageTest.this.ruleService.saveRule(RuleServiceCoverageTest.this.nodeRef, rule);
                NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(RuleServiceCoverageTest.TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                RuleServiceCoverageTest.this.addContentToNode(newNodeRef);
                return newNodeRef;
            }
        });
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new ActionServiceImplTest.AsyncTest(){

            public boolean executeTest() {
                return RuleServiceCoverageTest.this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE);
            }
        });
    }

    public void testAddFeaturesAction() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>(2);
        params2.put("aspect-name", ContentModel.ASPECT_SIMPLE_WORKFLOW);
        params2.put(ContentModel.PROP_APPROVE_STEP.toString(), (Serializable)((Object)"approveStep"));
        params2.put(ContentModel.PROP_APPROVE_MOVE.toString(), Boolean.valueOf(false));
        rule.removeAllActions();
        Action action2 = this.actionService.createAction("add-features", params2);
        rule.addAction(action2);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"approveStep", (Object)this.nodeService.getProperty(newNodeRef2, ContentModel.PROP_APPROVE_STEP));
        RuleServiceCoverageTest.assertEquals((Object)false, (Object)this.nodeService.getProperty(newNodeRef2, ContentModel.PROP_APPROVE_MOVE));
    }

    public void testDisableRule() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        this.ruleService.disableRule(rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.ruleService.enableRule(rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testAddFeaturesToAFolder() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_TEMPLATABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_FOLDER).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_TEMPLATABLE));
    }

    public void testCopyFolderToTriggerRules() {
        NodeRef copyToFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copyToFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folderToCopy = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}folderToCopy"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef contentToCopy = this.nodeService.createNode(folderToCopy, ContentModel.ASSOC_CONTAINS, QName.createQName("{test}contentToCopy"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(contentToCopy);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_TEMPLATABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        rule.applyToChildren(true);
        this.ruleService.saveRule(copyToFolder, rule);
        NodeRef copiedFolder = this.copyService.copy(folderToCopy, copyToFolder, ContentModel.ASSOC_CONTAINS, QName.createQName("{test}coppiedFolder"), true);
        RuleServiceCoverageTest.assertNotNull((Object)copiedFolder);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copiedFolder, ContentModel.ASPECT_TEMPLATABLE));
        for (ChildAssociationRef childAssoc : this.nodeService.getChildAssocs(copiedFolder)) {
            RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(childAssoc.getChildRef(), ContentModel.ASPECT_TEMPLATABLE));
        }
    }

    private Map<QName, Serializable> getContentProperties() {
        return null;
    }

    public void testSimpleWorkflowAction() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("approve-step", (Serializable)((Object)"approveStep"));
        params.put("approve-folder", this.rootNodeRef);
        params.put("approve-move", Boolean.valueOf(true));
        params.put("reject-step", (Serializable)((Object)"rejectStep"));
        params.put("reject-folder", this.rootNodeRef);
        params.put("reject-move", Boolean.valueOf(false));
        Rule rule = this.createRule("inbound", "simple-workflow", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"approveStep", (Object)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_APPROVE_STEP));
        RuleServiceCoverageTest.assertEquals((Object)this.rootNodeRef, (Object)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_APPROVE_FOLDER));
        RuleServiceCoverageTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_APPROVE_MOVE)));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"rejectStep", (Object)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_REJECT_STEP));
        RuleServiceCoverageTest.assertEquals((Object)this.rootNodeRef, (Object)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_REJECT_FOLDER));
        RuleServiceCoverageTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(newNodeRef, ContentModel.PROP_REJECT_MOVE)));
    }

    public void testInCategoryCondition() {
        this.createTestCategories();
        try {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
            params.put("category-aspect", this.regionCategorisationQName);
            params.put("category-value", this.catROne);
            HashMap<String, Serializable> params2 = new HashMap<String, Serializable>(1);
            params2.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
            Rule rule = this.createRule("inbound", "add-features", params2, "in-category", params);
            this.ruleService.saveRule(this.nodeRef, rule);
            NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "noAspect"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef2);
            RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
            UserTransaction tx = this.transactionService.getUserTransaction();
            tx.begin();
            NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "hasAspectAndValue"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef);
            HashMap<QName, Serializable> catProps = new HashMap<QName, Serializable>();
            catProps.put(CAT_PROP_QNAME, this.catROne);
            this.nodeService.addAspect(newNodeRef, this.regionCategorisationQName, catProps);
            tx.commit();
            RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
            UserTransaction tx3 = this.transactionService.getUserTransaction();
            tx3.begin();
            NodeRef newNodeRef3 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "hasAspectAndValue"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef3);
            HashMap<QName, Serializable> catProps3 = new HashMap<QName, Serializable>();
            catProps3.put(CAT_PROP_QNAME, this.catRTwo);
            this.nodeService.addAspect(newNodeRef3, this.regionCategorisationQName, catProps3);
            tx3.commit();
            RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef3, ContentModel.ASPECT_VERSIONABLE));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testLinkCategoryAction() {
        this.createTestCategories();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("category-aspect", this.regionCategorisationQName);
        params.put("category-value", this.catROne);
        Rule rule = this.createRule("inbound", "link-category", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "noAspect"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        NodeRef setValue = (NodeRef)this.nodeService.getProperty(newNodeRef2, CAT_PROP_QNAME);
        RuleServiceCoverageTest.assertNotNull((Object)setValue);
        RuleServiceCoverageTest.assertEquals((Object)this.catROne, (Object)setValue);
    }

    public void xtestMailAction() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("to", (Serializable)((Object)"alfresco.test@gmail.com"));
        params.put("subject", (Serializable)((Object)"Unit test"));
        params.put("text", (Serializable)((Object)"This is a test to check that the mail action is working."));
        Rule rule = this.createRule("inbound", "mail", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
    }

    public void testCopyAction() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", this.rootNodeRef);
        params.put("assoc-type", ContentModel.ASSOC_CHILDREN);
        params.put("assoc-name", QName.createQName(TEST_NAMESPACE, "copy"));
        Rule rule = this.createRule("inbound", "copy", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "origional"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        List<ChildAssociationRef> origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "origional"));
        RuleServiceCoverageTest.assertNotNull(origRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
        NodeRef origNodeRef = origRefs.get(0).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
        List<ChildAssociationRef> copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "copy"));
        RuleServiceCoverageTest.assertNotNull(copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef copyNodeRef = copyChildAssocRefs.get(0).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
        NodeRef source = (NodeRef)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_COPY_REFERENCE);
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
    }

    public void testTransformAction() {
        if (this.transformerRegistry.getTransformer("application/vnd.excel", "text/plain") != null) {
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
                params.put("mime-type", (Serializable)((Object)"text/plain"));
                params.put("destination-folder", this.rootNodeRef);
                params.put("assoc-type", ContentModel.ASSOC_CHILDREN);
                params.put("assoc-name", QName.createQName(TEST_NAMESPACE, "transformed"));
                Rule rule = this.createRule("inbound", "transform", params, "no-condition", null);
                this.ruleService.saveRule(this.nodeRef, rule);
                UserTransaction tx = this.transactionService.getUserTransaction();
                tx.begin();
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_NAME, (Serializable)((Object)"test.xls"));
                NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "origional"), ContentModel.TYPE_CONTENT, props).getChildRef();
                ContentWriter contentWriter = this.contentService.getWriter(newNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("application/vnd.excel");
                File testFile = AbstractContentTransformerTest.loadQuickTestFile("xls");
                contentWriter.putContent(testFile);
                tx.commit();
                AuthenticationComponent authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
                authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
                List<ChildAssociationRef> origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "origional"));
                RuleServiceCoverageTest.assertNotNull(origRefs);
                RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
                NodeRef origNodeRef = origRefs.get(0).getChildRef();
                RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
                List<ChildAssociationRef> copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "transformed"));
                RuleServiceCoverageTest.assertNotNull(copyChildAssocRefs);
                RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
                NodeRef copyNodeRef = copyChildAssocRefs.get(0).getChildRef();
                RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
                NodeRef source = (NodeRef)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_COPY_REFERENCE);
                RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
                ContentData contentData = (ContentData)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_CONTENT);
                RuleServiceCoverageTest.assertEquals((String)"text/plain", (String)contentData.getMimetype());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void testImageTransformAction() {
        if (this.transformerRegistry.getTransformer("image/gif", "image/jpeg") != null) {
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
                params.put("destination-folder", this.rootNodeRef);
                params.put("assoc-type", ContentModel.ASSOC_CHILDREN);
                params.put("mime-type", (Serializable)((Object)"image/jpeg"));
                params.put("assoc-name", QName.createQName(TEST_NAMESPACE, "transformed"));
                params.put("convert-command", (Serializable)((Object)"-negate"));
                Rule rule = this.createRule("inbound", "transform-image", params, "no-condition", null);
                this.ruleService.saveRule(this.nodeRef, rule);
                UserTransaction tx = this.transactionService.getUserTransaction();
                tx.begin();
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_NAME, (Serializable)((Object)"test.gif"));
                NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "origional"), ContentModel.TYPE_CONTENT, props).getChildRef();
                ContentWriter contentWriter = this.contentService.getWriter(newNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("image/gif");
                File testFile = AbstractContentTransformerTest.loadQuickTestFile("gif");
                contentWriter.putContent(testFile);
                tx.commit();
                List<ChildAssociationRef> origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "origional"));
                RuleServiceCoverageTest.assertNotNull(origRefs);
                RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
                NodeRef origNodeRef = origRefs.get(0).getChildRef();
                RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
                List<ChildAssociationRef> copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "transformed"));
                RuleServiceCoverageTest.assertNotNull(copyChildAssocRefs);
                RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
                NodeRef copyNodeRef = copyChildAssocRefs.get(0).getChildRef();
                RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
                NodeRef source = (NodeRef)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_COPY_REFERENCE);
                RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void testMoveAction() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", this.rootNodeRef);
        params.put("assoc-type", ContentModel.ASSOC_CHILDREN);
        params.put("assoc-name", QName.createQName(TEST_NAMESPACE, "copy"));
        Rule rule = this.createRule("inbound", "move", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "origional"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        List<ChildAssociationRef> origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "origional"));
        RuleServiceCoverageTest.assertNotNull(origRefs);
        RuleServiceCoverageTest.assertEquals((int)0, (int)origRefs.size());
        List<ChildAssociationRef> copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, QName.createQName(TEST_NAMESPACE, "copy"));
        RuleServiceCoverageTest.assertNotNull(copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef movedNodeRef = copyChildAssocRefs.get(0).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)movedNodeRef);
    }

    public void testCheckOutAction() {
        Rule rule = this.createRule("inbound", "check-out", null, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = null;
        UserTransaction tx = this.transactionService.getUserTransaction();
        try {
            tx.begin();
            newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "checkout"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef);
            tx.commit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        List<ChildAssociationRef> children = this.nodeService.getChildAssocs(this.nodeRef);
        RuleServiceCoverageTest.assertNotNull(children);
        RuleServiceCoverageTest.assertEquals((int)3, (int)children.size());
        for (ChildAssociationRef child : children) {
            NodeRef childNodeRef = child.getChildRef();
            if (childNodeRef.equals(newNodeRef)) {
                LockStatus lockStatus = this.lockService.getLockStatus(childNodeRef);
                RuleServiceCoverageTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)lockStatus));
                continue;
            }
            if (!this.nodeService.hasAspect(childNodeRef, ContentModel.ASPECT_WORKING_COPY)) continue;
            NodeRef copiedFromNodeRef = (NodeRef)this.nodeService.getProperty(childNodeRef, ContentModel.PROP_COPY_REFERENCE);
            RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)copiedFromNodeRef);
        }
    }

    public void testCheckInAction() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("description", (Serializable)((Object)"The version description."));
        Rule rule = this.createRule("inbound", "check-in", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        List<NodeRef> list = TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<List<NodeRef>>(){

            @Override
            public List<NodeRef> doWork() {
                NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(RuleServiceCoverageTest.TEST_NAMESPACE, "origional"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                NodeRef workingCopy = RuleServiceCoverageTest.this.cociService.checkout(newNodeRef);
                RuleServiceCoverageTest.this.nodeService.moveNode(workingCopy, RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(RuleServiceCoverageTest.TEST_NAMESPACE, "moved"));
                ArrayList<NodeRef> result = new ArrayList<NodeRef>();
                result.add(newNodeRef);
                result.add(workingCopy);
                return result;
            }
        });
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.exists(list.get(1)));
        RuleServiceCoverageTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(list.get(0))));
    }

    public void testRulesDisabled() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", actionParams, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        this.ruleService.disableRules(this.nodeRef);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.ruleService.enableRules(this.nodeRef);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
    }

    private void addContentToNode(NodeRef nodeRef) {
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        RuleServiceCoverageTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(STANDARD_TEXT_CONTENT + System.currentTimeMillis());
    }

    public void testCheckMandatoryProperties() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        HashMap<String, Serializable> condParams = new HashMap<String, Serializable>(1);
        Rule rule = this.createRule("inbound", "add-features", actionParams, "compare-property-value", condParams);
        this.ruleService.saveRule(this.nodeRef, rule);
        try {
            Map<QName, Serializable> props2 = this.getContentProperties();
            props2.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.doc"));
            NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, props2).getChildRef();
            this.addContentToNode(newNodeRef2);
            RuleServiceCoverageTest.fail((String)"An exception should have been thrown since a mandatory parameter was missing from the condition.");
        }
        catch (Throwable ruleServiceException) {
            // empty catch block
        }
    }

    public void testContainsTextCondition() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        HashMap<String, Serializable> condParams = new HashMap<String, Serializable>(1);
        condParams.put("value", (Serializable)((Object)".doc"));
        Rule rule = this.createRule("inbound", "add-features", actionParams, "compare-property-value", condParams);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, Serializable> props1 = new HashMap<QName, Serializable>();
        props1.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.txt"));
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, props1).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, Serializable> props2 = new HashMap<QName, Serializable>();
        props2.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.doc"));
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, props2).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
        try {
            NodeRef newNodeRef3 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef3);
        }
        catch (RuleServiceException exception) {
            // empty catch block
        }
        HashMap<String, Serializable> condParamsBegins = new HashMap<String, Serializable>(1);
        condParamsBegins.put("value", (Serializable)((Object)"bob*"));
        rule.removeAllActionConditions();
        ActionCondition condition1 = this.actionService.createActionCondition("compare-property-value", condParamsBegins);
        rule.addActionCondition(condition1);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, Serializable> propsx = new HashMap<QName, Serializable>();
        propsx.put(ContentModel.PROP_NAME, (Serializable)((Object)"mybobbins.doc"));
        NodeRef newNodeRefx = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, propsx).getChildRef();
        this.addContentToNode(newNodeRefx);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRefx, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, Serializable> propsy = new HashMap<QName, Serializable>();
        propsy.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.doc"));
        NodeRef newNodeRefy = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, propsy).getChildRef();
        this.addContentToNode(newNodeRefy);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRefy, ContentModel.ASPECT_VERSIONABLE));
        HashMap<String, Serializable> condParamsEnds = new HashMap<String, Serializable>(1);
        condParamsEnds.put("value", (Serializable)((Object)"*s.doc"));
        rule.removeAllActionConditions();
        ActionCondition condition2 = this.actionService.createActionCondition("compare-property-value", condParamsEnds);
        rule.addActionCondition(condition2);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, Serializable> propsa = new HashMap<QName, Serializable>();
        propsa.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.document"));
        NodeRef newNodeRefa = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, propsa).getChildRef();
        this.addContentToNode(newNodeRefa);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRefa, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, Serializable> propsb = new HashMap<QName, Serializable>();
        propsb.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.doc"));
        NodeRef newNodeRefb = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT, propsb).getChildRef();
        this.addContentToNode(newNodeRefb);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRefb, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testInboundRuleType() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTAINER).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef contentNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef moveNode = this.nodeService.createNode(newNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT).getChildRef();
        this.addContentToNode(moveNode);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(moveNode, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.moveNode(moveNode, this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(moveNode, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"name.txt"));
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testUpdateRuleType() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("update", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_FOLDER).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(newNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef contentNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTENT).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
        NodeRef nodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_FOLDER, props).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_NAME, (Serializable)((Object)"testName2"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
                NodeRef nodeRef3 = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(RuleServiceCoverageTest.TEST_NAMESPACE, "children"), ContentModel.TYPE_FOLDER, props).getChildRef();
                Assert.assertFalse((boolean)RuleServiceCoverageTest.this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_VERSIONABLE));
                RuleServiceCoverageTest.this.nodeService.setProperty(nodeRef3, ContentModel.PROP_NAME, (Serializable)((Object)"testName2"));
                Assert.assertFalse((boolean)RuleServiceCoverageTest.this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_VERSIONABLE));
                return null;
            }
        });
    }

    public void testOutboundRuleType() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("outbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTAINER).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.moveNode(newNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.deleteNode(newNodeRef2);
    }

    public void xtestPerformanceOfRuleExecution() {
        try {
            StopWatch sw = new StopWatch();
            sw.start("create nodes with no rule executed");
            UserTransaction userTransaction1 = this.transactionService.getUserTransaction();
            userTransaction1.begin();
            for (int i = 0; i < 100; ++i) {
                this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTAINER).getChildRef();
                RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
            }
            userTransaction1.commit();
            sw.stop();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
            params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
            Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
            this.ruleService.saveRule(this.nodeRef, rule);
            sw.start("create nodes with one rule run (apply versionable aspect)");
            UserTransaction userTransaction2 = this.transactionService.getUserTransaction();
            userTransaction2.begin();
            NodeRef[] nodeRefs = new NodeRef[100];
            for (int i = 0; i < 100; ++i) {
                NodeRef nodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, "children"), ContentModel.TYPE_CONTAINER).getChildRef();
                this.addContentToNode(nodeRef);
                nodeRefs[i] = nodeRef;
                RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
            }
            userTransaction2.commit();
            sw.stop();
            for (NodeRef ref : nodeRefs) {
                RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(ref, ContentModel.ASPECT_VERSIONABLE));
            }
            System.out.println(sw.prettyPrint());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

