/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.rule.RuleImpl;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuleTransactionListener;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleServiceImpl
implements RuleService,
RuntimeRuleService {
    private static final String KEY_RULES_PENDING = "RuleServiceImpl.PendingRules";
    private static final String KEY_RULES_EXECUTED = "RuleServiceImpl.ExecutedRules";
    private QName ASSOC_NAME_RULES = QName.createQName("http://www.alfresco.org/model/rule/1.0", "rules");
    private static Log logger = LogFactory.getLog(RuleServiceImpl.class);
    private NodeService nodeService;
    private NodeService runtimeNodeService;
    private ActionService actionService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    RuntimeActionService runtimeActionService;
    private Set<NodeRef> disabledNodeRefs = new HashSet<NodeRef>(5);
    private Set<Rule> disabledRules = new HashSet<Rule>(5);
    private Map<String, RuleType> ruleTypes = new HashMap<String, RuleType>();
    private TransactionListener ruleTransactionListener = new RuleTransactionListener(this);

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeNodeService(NodeService runtimeNodeService) {
        this.runtimeNodeService = runtimeNodeService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private NodeRef getSavedRuleFolderRef(NodeRef nodeRef) {
        NodeRef result = null;
        List<ChildAssociationRef> assocs = this.runtimeNodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RuleModel.ASSOC_RULE_FOLDER);
        if (assocs.size() > 1) {
            throw new ActionServiceException("There is more than one rule folder, which is invalid.");
        }
        if (assocs.size() == 1) {
            result = assocs.get(0).getChildRef();
        }
        return result;
    }

    @Override
    public List<RuleType> getRuleTypes() {
        return new ArrayList<RuleType>(this.ruleTypes.values());
    }

    @Override
    public RuleType getRuleType(String name) {
        return this.ruleTypes.get(name);
    }

    @Override
    public boolean rulesEnabled(NodeRef nodeRef) {
        return !this.disabledNodeRefs.contains(nodeRef);
    }

    @Override
    public void disableRules(NodeRef nodeRef) {
        this.disabledNodeRefs.add(nodeRef);
    }

    @Override
    public void enableRules(NodeRef nodeRef) {
        this.disabledNodeRefs.remove(nodeRef);
    }

    @Override
    public void disableRule(Rule rule) {
        this.disabledRules.add(rule);
    }

    @Override
    public void enableRule(Rule rule) {
        this.disabledRules.remove(rule);
    }

    @Override
    public boolean hasRules(NodeRef nodeRef) {
        return this.getRules(nodeRef).size() != 0;
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef) {
        return this.getRules(nodeRef, true, null);
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef, boolean includeInherited) {
        return this.getRules(nodeRef, includeInherited, null);
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef, boolean includeInherited, String ruleTypeName) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (this.runtimeNodeService.exists(nodeRef) && this.checkNodeType(nodeRef)) {
            NodeRef ruleFolder;
            if (includeInherited) {
                for (Rule rule : this.getInheritedRules(nodeRef, ruleTypeName, null)) {
                    if (rules.contains(rule)) continue;
                    rules.add(rule);
                }
            }
            if (this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (ruleFolder = this.getSavedRuleFolderRef(nodeRef)) != null) {
                ArrayList<Rule> allRules = new ArrayList<Rule>();
                List<ChildAssociationRef> ruleChildAssocRefs = this.runtimeNodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, this.ASSOC_NAME_RULES);
                for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                    NodeRef ruleNodeRef = ruleChildAssocRef.getChildRef();
                    Rule rule = this.createRule(nodeRef, ruleNodeRef);
                    allRules.add(rule);
                }
                for (Rule rule : allRules) {
                    if (rules.contains(rule) || ruleTypeName != null && !ruleTypeName.equals(rule.getRuleTypeName())) continue;
                    rules.add(rule);
                }
            }
        }
        return rules;
    }

    @Override
    public int countRules(NodeRef nodeRef) {
        NodeRef ruleFolder;
        int ruleCount = 0;
        if (this.runtimeNodeService.exists(nodeRef) && this.checkNodeType(nodeRef) && this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (ruleFolder = this.getSavedRuleFolderRef(nodeRef)) != null) {
            List<ChildAssociationRef> ruleChildAssocRefs = this.runtimeNodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, this.ASSOC_NAME_RULES);
            ruleCount = ruleChildAssocRefs.size();
        }
        return ruleCount;
    }

    private boolean checkNodeType(NodeRef nodeRef) {
        boolean result = true;
        QName nodeType = this.runtimeNodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_SYSTEM_FOLDER) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION_CONDITION) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION_PARAMETER)) {
            result = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("A node of type " + nodeType.toString() + " was checked and can not have rules."));
            }
        }
        return result;
    }

    private List<Rule> getInheritedRules(NodeRef nodeRef, String ruleTypeName, Set<NodeRef> visitedNodeRefs) {
        ArrayList<Rule> inheritedRules = new ArrayList<Rule>();
        if (visitedNodeRefs == null) {
            visitedNodeRefs = new HashSet<NodeRef>();
        }
        if (!visitedNodeRefs.contains(nodeRef)) {
            visitedNodeRefs.add(nodeRef);
            ArrayList<Rule> allInheritedRules = new ArrayList<Rule>();
            List<ChildAssociationRef> parents = this.runtimeNodeService.getParentAssocs(nodeRef);
            for (ChildAssociationRef parent : parents) {
                List<Rule> rules = this.getRules(parent.getParentRef(), false);
                for (Rule rule : rules) {
                    if (!rule.isAppliedToChildren() || allInheritedRules.contains(rule)) continue;
                    allInheritedRules.add(rule);
                }
                for (Rule rule : this.getInheritedRules(parent.getParentRef(), ruleTypeName, visitedNodeRefs)) {
                    if (allInheritedRules.contains(rule)) continue;
                    allInheritedRules.add(rule);
                }
            }
            if (ruleTypeName == null) {
                inheritedRules = allInheritedRules;
            } else {
                for (Rule rule : allInheritedRules) {
                    if (!rule.getRuleTypeName().equals(ruleTypeName)) continue;
                    inheritedRules.add(rule);
                }
            }
        }
        return inheritedRules;
    }

    @Override
    public Rule getRule(NodeRef nodeRef, String ruleId) {
        NodeRef ruleNodeRef;
        Rule rule = null;
        if (this.runtimeNodeService.exists(nodeRef) && (ruleNodeRef = this.getRuleNodeRefFromId(nodeRef, ruleId)) != null) {
            rule = this.createRule(nodeRef, ruleNodeRef);
        }
        return rule;
    }

    private NodeRef getRuleNodeRefFromId(NodeRef nodeRef, String ruleId) {
        NodeRef ruleFolder;
        NodeRef result = null;
        if (this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (ruleFolder = this.getSavedRuleFolderRef(nodeRef)) != null) {
            DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver();
            namespacePrefixResolver.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
            List<NodeRef> nodeRefs = this.searchService.selectNodes(ruleFolder, "*[@sys:" + ContentModel.PROP_NODE_UUID.getLocalName() + "='" + ruleId + "']", null, namespacePrefixResolver, false);
            if (nodeRefs.size() != 0) {
                result = nodeRefs.get(0);
            }
        }
        return result;
    }

    private Rule createRule(NodeRef owningNodeRef, NodeRef ruleNodeRef) {
        Map<QName, Serializable> props = this.nodeService.getProperties(ruleNodeRef);
        String ruleTypeName = (String)((Object)props.get(RuleModel.PROP_RULE_TYPE));
        RuleImpl rule = new RuleImpl(ruleNodeRef.getId(), ruleTypeName, owningNodeRef);
        boolean isAppliedToChildren = false;
        Boolean value = (Boolean)props.get(RuleModel.PROP_APPLY_TO_CHILDREN);
        if (value != null) {
            isAppliedToChildren = value;
        }
        rule.applyToChildren(isAppliedToChildren);
        this.runtimeActionService.populateCompositeAction(ruleNodeRef, rule);
        return rule;
    }

    @Override
    public Rule createRule(String ruleTypeName) {
        String id = GUID.generate();
        return new RuleImpl(id, ruleTypeName, null);
    }

    @Override
    public void saveRule(NodeRef nodeRef, Rule rule) {
        if (!this.nodeService.exists(nodeRef)) {
            throw new RuleServiceException("The node does not exist.");
        }
        NodeRef ruleNodeRef = this.getRuleNodeRefFromId(nodeRef, rule.getId());
        if (ruleNodeRef == null) {
            if (!this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES)) {
                this.nodeService.addAspect(nodeRef, RuleModel.ASPECT_RULES, null);
            }
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(3);
            props.put(RuleModel.PROP_RULE_TYPE, (Serializable)((Object)rule.getRuleTypeName()));
            props.put(ActionModel.PROP_DEFINITION_NAME, (Serializable)((Object)rule.getActionDefinitionName()));
            props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)rule.getId()));
            ruleNodeRef = this.nodeService.createNode(this.getSavedRuleFolderRef(nodeRef), ContentModel.ASSOC_CONTAINS, this.ASSOC_NAME_RULES, RuleModel.TYPE_RULE, props).getChildRef();
            ((RuleImpl)rule).setCreator((String)((Object)this.nodeService.getProperty(ruleNodeRef, ContentModel.PROP_CREATOR)));
            ((RuleImpl)rule).setCreatedDate((Date)this.nodeService.getProperty(ruleNodeRef, ContentModel.PROP_CREATED));
        }
        this.nodeService.setProperty(ruleNodeRef, RuleModel.PROP_APPLY_TO_CHILDREN, Boolean.valueOf(rule.isAppliedToChildren()));
        this.runtimeActionService.saveActionImpl(nodeRef, ruleNodeRef, rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(NodeRef nodeRef, Rule rule) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES)) {
            this.disableRules(nodeRef);
            try {
                NodeRef ruleNodeRef = this.getRuleNodeRefFromId(nodeRef, rule.getId());
                if (ruleNodeRef != null) {
                    this.nodeService.removeChild(this.getSavedRuleFolderRef(nodeRef), ruleNodeRef);
                }
            }
            finally {
                this.enableRules(nodeRef);
            }
        }
    }

    @Override
    public void removeAllRules(NodeRef nodeRef) {
        NodeRef folder;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (folder = this.getSavedRuleFolderRef(nodeRef)) != null) {
            List<ChildAssociationRef> ruleChildAssocs = this.nodeService.getChildAssocs(folder, RegexQNamePattern.MATCH_ALL, this.ASSOC_NAME_RULES);
            for (ChildAssociationRef ruleChildAssoc : ruleChildAssocs) {
                this.nodeService.removeChild(folder, ruleChildAssoc.getChildRef());
            }
        }
    }

    @Override
    public void addRulePendingExecution(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule) {
        this.addRulePendingExecution(actionableNodeRef, actionedUponNodeRef, rule, false);
    }

    @Override
    public void addRulePendingExecution(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule, boolean executeAtEnd) {
        if (!this.disabledNodeRefs.contains(rule.getOwningNodeRef()) && !this.disabledRules.contains(rule)) {
            PendingRuleData pendingRuleData = new PendingRuleData(actionableNodeRef, actionedUponNodeRef, rule, executeAtEnd);
            Set executedRules = (Set)AlfrescoTransactionSupport.getResource(KEY_RULES_EXECUTED);
            if (executedRules == null || !executedRules.contains(new ExecutedRuleData(actionableNodeRef, rule))) {
                HashSet<PendingRuleData> pendingRules = (HashSet<PendingRuleData>)AlfrescoTransactionSupport.getResource(KEY_RULES_PENDING);
                if (pendingRules == null) {
                    pendingRules = new HashSet<PendingRuleData>();
                    AlfrescoTransactionSupport.bindResource(KEY_RULES_PENDING, pendingRules);
                    AlfrescoTransactionSupport.bindListener(this.ruleTransactionListener);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Rule '" + rule.getTitle() + "' has been added pending execution to action upon node '" + actionedUponNodeRef.getId() + "'"));
                    }
                }
                pendingRules.add(pendingRuleData);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("The rule '" + rule.getTitle() + "' or the node '" + rule.getOwningNodeRef().getId() + "' has been disabled."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executePendingRules() {
        AlfrescoTransactionSupport.bindResource(KEY_RULES_EXECUTED, new HashSet());
        try {
            ArrayList<PendingRuleData> executeAtEndRules = new ArrayList<PendingRuleData>();
            this.executePendingRulesImpl(executeAtEndRules);
            for (PendingRuleData data : executeAtEndRules) {
                this.executePendingRule(data);
            }
        }
        finally {
            AlfrescoTransactionSupport.unbindResource(KEY_RULES_EXECUTED);
        }
    }

    private void executePendingRulesImpl(List<PendingRuleData> executeAtEndRules) {
        Set pendingRules = (Set)AlfrescoTransactionSupport.getResource(KEY_RULES_PENDING);
        if (pendingRules != null && !pendingRules.isEmpty()) {
            PendingRuleData[] pendingRulesArr = pendingRules.toArray(new PendingRuleData[0]);
            AlfrescoTransactionSupport.unbindResource(KEY_RULES_PENDING);
            for (PendingRuleData pendingRule : pendingRulesArr) {
                if (!pendingRule.getExecuteAtEnd()) {
                    this.executePendingRule(pendingRule);
                    continue;
                }
                executeAtEndRules.add(pendingRule);
            }
            this.executePendingRulesImpl(executeAtEndRules);
        }
    }

    private void executePendingRule(PendingRuleData pendingRule) {
        NodeRef actionableNodeRef = pendingRule.getActionableNodeRef();
        NodeRef actionedUponNodeRef = pendingRule.getActionedUponNodeRef();
        Rule rule = pendingRule.getRule();
        if (this.actionService.evaluateAction(rule, actionedUponNodeRef)) {
            Set executedRules = (Set)AlfrescoTransactionSupport.getResource(KEY_RULES_EXECUTED);
            executedRules.add(new ExecutedRuleData(actionableNodeRef, rule));
            this.actionService.executeAction(rule, actionedUponNodeRef);
        }
    }

    @Override
    public void registerRuleType(RuleType ruleType) {
        this.ruleTypes.put(ruleType.getName(), ruleType);
    }

    private class PendingRuleData
    extends ExecutedRuleData {
        private NodeRef actionedUponNodeRef;
        private boolean executeAtEnd;

        public PendingRuleData(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule, boolean executeAtEnd) {
            super(actionableNodeRef, rule);
            this.executeAtEnd = false;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.executeAtEnd = executeAtEnd;
        }

        public NodeRef getActionedUponNodeRef() {
            return this.actionedUponNodeRef;
        }

        public boolean getExecuteAtEnd() {
            return this.executeAtEnd;
        }

        public int hashCode() {
            int i = super.hashCode();
            i = i * 37 + this.actionedUponNodeRef.hashCode();
            return i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PendingRuleData) {
                PendingRuleData that = (PendingRuleData)obj;
                return this.actionableNodeRef.equals(that.actionableNodeRef) && this.actionedUponNodeRef.equals(that.actionedUponNodeRef) && this.rule.equals(that.rule);
            }
            return false;
        }
    }

    private class ExecutedRuleData {
        protected NodeRef actionableNodeRef;
        protected Rule rule;

        public ExecutedRuleData(NodeRef actionableNodeRef, Rule rule) {
            this.actionableNodeRef = actionableNodeRef;
            this.rule = rule;
        }

        public NodeRef getActionableNodeRef() {
            return this.actionableNodeRef;
        }

        public Rule getRule() {
            return this.rule;
        }

        public int hashCode() {
            int i = this.actionableNodeRef.hashCode();
            i = i * 37 + this.rule.hashCode();
            return i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutedRuleData) {
                ExecutedRuleData that = (ExecutedRuleData)obj;
                return this.actionableNodeRef.equals(that.actionableNodeRef) && this.rule.equals(that.rule);
            }
            return false;
        }
    }
}

