/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.rule.BaseRuleTest;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.namespace.QName;

public class RuleServiceImplTest
extends BaseRuleTest {
    public void testGetRuleType() {
        List<RuleType> ruleTypes = this.ruleService.getRuleTypes();
        RuleServiceImplTest.assertNotNull(ruleTypes);
        for (RuleType type : ruleTypes) {
            System.out.println(type.getDisplayLabel());
        }
    }

    public void testCreateRule() {
        Rule newRule = this.ruleService.createRule("ruleType1");
        RuleServiceImplTest.assertNotNull((Object)newRule);
        RuleServiceImplTest.assertNotNull((Object)newRule.getId());
        RuleServiceImplTest.assertEquals((String)"ruleType1", (String)newRule.getRuleTypeName());
    }

    public void testAddRule() {
        Rule newRule = this.createTestRule();
        String ruleId = newRule.getId();
        this.ruleService.saveRule(this.nodeRef, newRule);
        Rule savedRule = this.ruleService.getRule(this.nodeRef, ruleId);
        RuleServiceImplTest.assertNotNull((Object)savedRule);
        RuleServiceImplTest.assertFalse((boolean)savedRule.isAppliedToChildren());
        savedRule.applyToChildren(true);
        this.ruleService.saveRule(this.nodeRef, savedRule);
        Rule savedRule2 = this.ruleService.getRule(this.nodeRef, ruleId);
        RuleServiceImplTest.assertNotNull((Object)savedRule2);
        RuleServiceImplTest.assertTrue((boolean)savedRule2.isAppliedToChildren());
    }

    public void testRemoveAllRules() {
        this.ruleService.removeAllRules(this.nodeRef);
        List<Rule> rules1 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules1);
        RuleServiceImplTest.assertEquals((int)0, (int)rules1.size());
        Rule newRule = this.ruleService.createRule(this.ruleType.getName());
        this.ruleService.saveRule(this.nodeRef, newRule);
        Rule newRule2 = this.ruleService.createRule(this.ruleType.getName());
        this.ruleService.saveRule(this.nodeRef, newRule2);
        List<Rule> rules2 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules2);
        RuleServiceImplTest.assertEquals((int)2, (int)rules2.size());
        this.ruleService.removeAllRules(this.nodeRef);
        List<Rule> rules3 = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules3);
        RuleServiceImplTest.assertEquals((int)0, (int)rules3.size());
    }

    public void testGetRules() {
        List<Rule> noRules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(noRules);
        RuleServiceImplTest.assertEquals((int)0, (int)noRules.size());
        List<Rule> noRulesAfterCache = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(noRulesAfterCache);
        RuleServiceImplTest.assertEquals((int)0, (int)noRulesAfterCache.size());
        this.testAddRule();
        List<Rule> rules = this.ruleService.getRules(this.nodeRef);
        RuleServiceImplTest.assertNotNull(rules);
        RuleServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule rule = rules.get(0);
        RuleServiceImplTest.assertEquals((String)"title", (String)rule.getTitle());
        RuleServiceImplTest.assertEquals((String)"description", (String)rule.getDescription());
        RuleServiceImplTest.assertNotNull((Object)rule.getCreatedDate());
        RuleServiceImplTest.assertNotNull((Object)rule.getModifiedDate());
        List<ActionCondition> conditions = rule.getActionConditions();
        RuleServiceImplTest.assertNotNull(conditions);
        RuleServiceImplTest.assertEquals((int)1, (int)conditions.size());
        List<Action> actions = rule.getActions();
        RuleServiceImplTest.assertNotNull(actions);
        RuleServiceImplTest.assertEquals((int)1, (int)actions.size());
    }

    public void testRulesDisabled() {
        this.testAddRule();
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.disableRules(this.nodeRef);
        RuleServiceImplTest.assertFalse((boolean)this.ruleService.rulesEnabled(this.nodeRef));
        this.ruleService.enableRules(this.nodeRef);
        RuleServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(this.nodeRef));
    }

    private NodeRef createNewNode(NodeRef parent, boolean isActionable) {
        NodeRef newNodeRef = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTAINER).getChildRef();
        return newNodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRuleInheritance() {
        NodeRef rootWithRules = this.createNewNode(this.rootNodeRef, true);
        Rule rule1 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule2);
        NodeRef nonActionableChild = this.createNewNode(rootWithRules, false);
        NodeRef childWithRules = this.createNewNode(nonActionableChild, true);
        Rule rule3 = this.createTestRule();
        this.ruleService.saveRule(childWithRules, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(childWithRules, rule4);
        NodeRef rootWithRules2 = this.createNewNode(this.rootNodeRef, true);
        this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"));
        Rule rule5 = this.createTestRule();
        this.ruleService.saveRule(rootWithRules2, rule5);
        Rule rule6 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules2, rule6);
        List<Rule> allRules = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules.size());
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules.contains(rule6));
        int count = 0;
        for (Rule rule : allRules) {
            if (rule.getOwningNodeRef() != childWithRules) continue;
            ++count;
        }
        RuleServiceImplTest.assertEquals((int)2, (int)count);
        List<Rule> myRules = this.ruleService.getRules(childWithRules, false);
        RuleServiceImplTest.assertNotNull(myRules);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules.size());
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)myRules.contains(rule4));
        List<Rule> allRules2 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List<Rule> myRules2 = this.ruleService.getRules(nonActionableChild, false);
        RuleServiceImplTest.assertNotNull(myRules2);
        RuleServiceImplTest.assertEquals((int)0, (int)myRules2.size());
        List<Rule> allRules3 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        List<Rule> myRules3 = this.ruleService.getRules(rootWithRules, false);
        RuleServiceImplTest.assertNotNull(myRules3);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules3.size());
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)myRules3.contains(rule2));
        List<Rule> allRules4 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule6));
        List<Rule> myRules4 = this.ruleService.getRules(rootWithRules2, false);
        RuleServiceImplTest.assertNotNull(myRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)myRules4.size());
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)myRules4.contains(rule6));
        Rule rule7 = this.createTestRule(true);
        this.ruleService.saveRule(rootWithRules, rule7);
        List<Rule> allRules5 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules5);
        RuleServiceImplTest.assertEquals((int)5, (int)allRules5.size());
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule6));
        RuleServiceImplTest.assertTrue((boolean)allRules5.contains(rule7));
        List<Rule> allRules6 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules6);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules6.size());
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules6.contains(rule7));
        List<Rule> allRules7 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules7);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules7.size());
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules7.contains(rule7));
        List<Rule> allRules8 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules8);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules8.size());
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules8.contains(rule6));
        this.ruleService.removeRule(rootWithRules, rule7);
        List<Rule> allRules9 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules9);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules9.size());
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules9.contains(rule6));
        List<Rule> allRules10 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules10);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules10.size());
        RuleServiceImplTest.assertTrue((boolean)allRules10.contains(rule2));
        List<Rule> allRules11 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules11);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules11.size());
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules11.contains(rule2));
        List<Rule> allRules12 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules12);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules12.size());
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules12.contains(rule6));
        this.nodeService.removeChild(rootWithRules2, childWithRules);
        List<Rule> allRules13 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules13);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules13.size());
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules13.contains(rule4));
        List<Rule> allRules14 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules14);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules14.size());
        RuleServiceImplTest.assertTrue((boolean)allRules14.contains(rule2));
        List<Rule> allRules15 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules15);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules15.size());
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules15.contains(rule2));
        List<Rule> allRules16 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules16);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules16.size());
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules16.contains(rule6));
        this.ruleService.disableRules(rootWithRules2);
        try {
            this.nodeService.addChild(rootWithRules2, childWithRules, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"));
        }
        finally {
            this.ruleService.enableRules(rootWithRules2);
        }
        List<Rule> allRules17 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules17);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules17.size());
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule4));
        RuleServiceImplTest.assertTrue((boolean)allRules17.contains(rule6));
        List<Rule> allRules18 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules18);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules18.size());
        RuleServiceImplTest.assertTrue((boolean)allRules18.contains(rule2));
        List<Rule> allRules19 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules19);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules19.size());
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules19.contains(rule2));
        List<Rule> allRules20 = this.ruleService.getRules(rootWithRules2, true);
        RuleServiceImplTest.assertNotNull(allRules20);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules20.size());
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule5));
        RuleServiceImplTest.assertTrue((boolean)allRules20.contains(rule6));
        this.nodeService.deleteNode(rootWithRules2);
        List<Rule> allRules21 = this.ruleService.getRules(childWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules21);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules21.size());
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules21.contains(rule4));
        List<Rule> allRules22 = this.ruleService.getRules(nonActionableChild, true);
        RuleServiceImplTest.assertNotNull(allRules22);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules22.size());
        RuleServiceImplTest.assertTrue((boolean)allRules22.contains(rule2));
        List<Rule> allRules23 = this.ruleService.getRules(rootWithRules, true);
        RuleServiceImplTest.assertNotNull(allRules23);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules23.size());
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules23.contains(rule2));
    }

    public void testCyclicGraphWithInheritedRules() throws Exception {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef, true);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1, true);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2, true);
        try {
            this.nodeService.addChild(nodeRef3, nodeRef1, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}loop"));
            RuleServiceImplTest.fail((String)"Expected detection of cyclic relationship");
        }
        catch (CyclicChildRelationshipException e) {
            // empty catch block
        }
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        List<Rule> allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull(allRules1);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule3));
        List<Rule> allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule3));
        List<Rule> allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)3, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
    }

    public void testRuleDuplication() {
        NodeRef nodeRef1 = this.createNewNode(this.rootNodeRef, true);
        NodeRef nodeRef2 = this.createNewNode(nodeRef1, true);
        NodeRef nodeRef3 = this.createNewNode(nodeRef2, true);
        NodeRef nodeRef4 = this.createNewNode(nodeRef1, true);
        this.nodeService.addChild(nodeRef4, nodeRef3, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}test"));
        Rule rule1 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef1, rule1);
        Rule rule2 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef2, rule2);
        Rule rule3 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef3, rule3);
        Rule rule4 = this.createTestRule(true);
        this.ruleService.saveRule(nodeRef4, rule4);
        List<Rule> allRules1 = this.ruleService.getRules(nodeRef1, true);
        RuleServiceImplTest.assertNotNull(allRules1);
        RuleServiceImplTest.assertEquals((int)1, (int)allRules1.size());
        RuleServiceImplTest.assertTrue((boolean)allRules1.contains(rule1));
        List<Rule> allRules2 = this.ruleService.getRules(nodeRef2, true);
        RuleServiceImplTest.assertNotNull(allRules2);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules2.size());
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules2.contains(rule2));
        List<Rule> allRules3 = this.ruleService.getRules(nodeRef3, true);
        RuleServiceImplTest.assertNotNull(allRules3);
        RuleServiceImplTest.assertEquals((int)4, (int)allRules3.size());
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule2));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule3));
        RuleServiceImplTest.assertTrue((boolean)allRules3.contains(rule4));
        List<Rule> allRules4 = this.ruleService.getRules(nodeRef4, true);
        RuleServiceImplTest.assertNotNull(allRules4);
        RuleServiceImplTest.assertEquals((int)2, (int)allRules4.size());
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule1));
        RuleServiceImplTest.assertTrue((boolean)allRules4.contains(rule4));
    }

    public void testCyclicRules() {
    }

    public void testCyclicAsyncRules() throws Exception {
        NodeRef nodeRef = this.createNewNode(this.rootNodeRef, true);
        HashMap<String, Serializable> conditionProps = new HashMap<String, Serializable>();
        conditionProps.put("value", (Serializable)((Object)"*.jpg"));
        HashMap<String, Serializable> actionProps = new HashMap<String, Serializable>();
        actionProps.put("mime-type", (Serializable)((Object)"image/gif"));
        actionProps.put("destination-folder", nodeRef);
        actionProps.put("assoc-type", ContentModel.ASSOC_CHILDREN);
        actionProps.put("assoc-name", ContentModel.ASSOC_CHILDREN);
        Rule rule = this.ruleService.createRule(this.ruleType.getName());
        rule.setTitle("Convert from *.jpg to *.gif");
        rule.setExecuteAsynchronously(true);
        ActionCondition actionCondition = this.actionService.createActionCondition("compare-property-value");
        actionCondition.setParameterValues(conditionProps);
        rule.addActionCondition(actionCondition);
        Action action = this.actionService.createAction("transform-image");
        action.setParameterValues(actionProps);
        rule.addAction(action);
        HashMap<String, Serializable> conditionProps2 = new HashMap<String, Serializable>();
        conditionProps2.put("value", (Serializable)((Object)"*.gif"));
        HashMap<String, Serializable> actionProps2 = new HashMap<String, Serializable>();
        actionProps2.put("mime-type", (Serializable)((Object)"image/jpeg"));
        actionProps2.put("destination-folder", nodeRef);
        actionProps2.put("assoc-name", ContentModel.ASSOC_CHILDREN);
        Rule rule2 = this.ruleService.createRule(this.ruleType.getName());
        rule2.setTitle("Convert from *.gif to *.jpg");
        rule2.setExecuteAsynchronously(true);
        ActionCondition actionCondition2 = this.actionService.createActionCondition("compare-property-value");
        actionCondition2.setParameterValues(conditionProps2);
        rule2.addActionCondition(actionCondition2);
        Action action2 = this.actionService.createAction("transform-image");
        action2.setParameterValues(actionProps2);
        rule2.addAction(action2);
        this.ruleService.saveRule(nodeRef, rule);
        this.ruleService.saveRule(nodeRef, rule);
        NodeRef contentNode = this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(contentNode, ContentModel.PROP_NAME, (Serializable)((Object)"myFile.jpg"));
        File file = AbstractContentTransformerTest.loadQuickTestFile("jpg");
        ContentWriter writer = this.contentService.getWriter(contentNode, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("image/jpeg");
        writer.putContent(file);
        this.setComplete();
        this.endTransaction();
    }
}

