/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.List;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.action.CommonResourceAbstractBase;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTypeImpl
extends CommonResourceAbstractBase
implements RuleType {
    private static Log logger = LogFactory.getLog(RuleTypeImpl.class);
    private ActionService actionService;
    private RuleService ruleService;

    public RuleTypeImpl(List<RuleTrigger> ruleTriggers) {
        if (ruleTriggers != null) {
            for (RuleTrigger trigger : ruleTriggers) {
                trigger.registerRuleType(this);
            }
        }
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        ((RuntimeRuleService)((Object)this.ruleService)).registerRuleType(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayLabel() {
        return I18NUtil.getMessage((String)(this.name + "." + "display-label"));
    }

    @Override
    public void triggerRuleType(NodeRef nodeRef, NodeRef actionedUponNodeRef) {
        if (this.ruleService.hasRules(nodeRef)) {
            List<Rule> rules = this.ruleService.getRules(nodeRef, true, this.name);
            for (Rule rule : rules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Triggering rule " + rule.getId()));
                }
                ((RuntimeRuleService)((Object)this.ruleService)).addRulePendingExecution(nodeRef, actionedUponNodeRef, rule);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"This node has no rules to trigger.");
        }
    }

    @Override
    public void setBeanName(String name) {
        this.name = name;
    }
}

