/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesAspect {
    private Behaviour onAddAspectBehaviour;
    private PolicyComponent policyComponent;
    private RuleService ruleService;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onCopyNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyComplete"), RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.onAddAspectBehaviour = new JavaBehaviour(this, "onAddAspect");
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), RuleModel.ASPECT_RULES, this.onAddAspectBehaviour);
    }

    public void disbleOnAddAspect() {
        this.onAddAspectBehaviour.disable();
    }

    public void enableOnAddAspect() {
        this.onAddAspectBehaviour.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.ruleService.disableRules(nodeRef);
        try {
            int count = this.nodeService.getChildAssocs(nodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER).size();
            if (count == 0) {
                this.nodeService.createNode(nodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER, ContentModel.TYPE_SYSTEM_FOLDER);
            }
        }
        finally {
            this.ruleService.enableRules(nodeRef);
        }
    }

    public void onCopyNode(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        copyDetails.addAspect(RuleModel.ASPECT_RULES);
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL, RuleModel.ASSOC_RULE_FOLDER);
        for (ChildAssociationRef assoc : assocs) {
            copyDetails.addChildAssociation(classRef, assoc, true);
        }
        this.onAddAspectBehaviour.disable();
    }

    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyToNew, Map<NodeRef, NodeRef> copyMap) {
        this.onAddAspectBehaviour.enable();
    }
}

