/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import org.alfresco.repo.rule.ruletrigger.SingleChildAssocRefPolicyRuleTrigger;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateNodeRuleTrigger
extends SingleChildAssocRefPolicyRuleTrigger {
    private static Log logger = LogFactory.getLog(CreateNodeRuleTrigger.class);
    DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void policyBehaviour(ChildAssociationRef childAssocRef) {
        boolean triggerRule = false;
        QName type = this.nodeService.getType(childAssocRef.getChildRef());
        ClassDefinition classDefinition = this.dictionaryService.getClass(type);
        if (classDefinition != null) {
            for (PropertyDefinition propertyDefinition : classDefinition.getProperties().values()) {
                if (!propertyDefinition.getDataType().getName().equals(DataTypeDefinition.CONTENT)) continue;
                triggerRule = true;
                break;
            }
        }
        if (!triggerRule) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create node rule trigger fired for parent node " + this.nodeService.getType(childAssocRef.getParentRef()).toString() + " " + childAssocRef.getParentRef() + " and child node " + this.nodeService.getType(childAssocRef.getChildRef()).toString() + " " + childAssocRef.getChildRef()));
            }
            this.triggerRules(childAssocRef.getParentRef(), childAssocRef.getChildRef());
        }
        AlfrescoTransactionSupport.bindResource(childAssocRef.getChildRef().toString(), childAssocRef.getChildRef().toString());
    }
}

