/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.List;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnContentUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements ContentServicePolicies.OnContentUpdatePolicy {
    private static Log logger = LogFactory.getLog(OnContentUpdateRuleTrigger.class);
    private boolean onNewContent = false;
    private boolean triggerParentRules = true;

    public void setOnNewContent(boolean onNewContent) {
        this.onNewContent = onNewContent;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.ON_CONTENT_UPDATE, this, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (newContent == this.onNewContent) {
            if (this.triggerParentRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OnContentUpdate rule triggered fired for content; nodeId=" + nodeRef.getId() + "; newContent=" + newContent));
                }
                List<ChildAssociationRef> parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                    this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                }
            } else {
                this.triggerRules(nodeRef, nodeRef);
            }
        }
    }
}

