/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnPropertyUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(OnPropertyUpdateRuleTrigger.class);
    private boolean triggerParentRules = true;

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    @Override
    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    private boolean havePropertiesBeenModified(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        ArrayList<QName> remainder = new ArrayList<QName>(after.keySet());
        ArrayList<QName> modifiedProperties = new ArrayList<QName>();
        for (QName name : before.keySet()) {
            Serializable afterValue;
            if (!after.containsKey(name)) continue;
            Serializable beforeValue = before.get(name);
            if (!EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(name)))) {
                modifiedProperties.add(name);
            }
            remainder.remove(name);
        }
        if (remainder.size() != 0) {
            modifiedProperties.addAll(remainder);
        }
        for (QName propertyName : new ArrayList(modifiedProperties)) {
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(propertyName);
            if (propertyDefinition == null || !propertyDefinition.isProtected() && !propertyDefinition.getDataType().getName().equals(DataTypeDefinition.CONTENT)) continue;
            modifiedProperties.remove(propertyName);
        }
        return !modifiedProperties.isEmpty();
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Object createdNodeRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("OnPropertyUpdate rule triggered fired; nodeRef=" + nodeRef.toString() + "; triggerParentRules=" + this.triggerParentRules));
        }
        if ((createdNodeRef = AlfrescoTransactionSupport.getResource(nodeRef.toString())) == null && this.havePropertiesBeenModified(nodeRef, before, after)) {
            if (this.triggerParentRules) {
                List<ChildAssociationRef> parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                    this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                }
            } else {
                this.triggerRules(nodeRef, nodeRef);
            }
        }
    }
}

