/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.util.BaseSpringTest;

public class RuleTriggerTest
extends BaseSpringTest {
    private static final String ON_CREATE_NODE_TRIGGER = "on-create-node-trigger";
    private static final String ON_UPDATE_NODE_TRIGGER = "on-update-node-trigger";
    private static final String ON_DELETE_NODE_TRIGGER = "on-delete-node-trigger";
    private static final String ON_CREATE_CHILD_ASSOCIATION_TRIGGER = "on-create-child-association-trigger";
    private static final String ON_DELETE_CHILD_ASSOCIATION_TRIGGER = "on-delete-child-association-trigger";
    private static final String ON_CREATE_ASSOCIATION_TRIGGER = "on-create-association-trigger";
    private static final String ON_DELETE_ASSOCIATION_TRIGGER = "on-delete-association-trigger";
    private static final String ON_CONTENT_UPDATE_TRIGGER = "on-content-update-trigger";
    private static final String ON_CONTENT_CREATE_TRIGGER = "on-content-create-trigger";
    private NodeService nodeService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
    }

    public void testOnCreateNodeTrigger() {
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnUpdateNodeTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_UPDATE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"nameChanged"));
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnDeleteNodeTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_DELETE_NODE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.deleteNode(nodeRef);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnCreateChildAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_CHILD_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.addChild(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnDeleteChildAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addChild(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN);
        TestRuleType ruleType = this.createTestRuleType(ON_DELETE_CHILD_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.removeChild(nodeRef, nodeRef2);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnCreateAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        TestRuleType ruleType = this.createTestRuleType(ON_CREATE_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.createAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnDeleteAssociationTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.createAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        TestRuleType ruleType = this.createTestRuleType(ON_DELETE_ASSOCIATION_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)ruleType.rulesTriggered);
        this.nodeService.removeAssociation(nodeRef, nodeRef2, ContentModel.ASSOC_CHILDREN);
        RuleTriggerTest.assertTrue((boolean)ruleType.rulesTriggered);
    }

    public void testOnContentCreateTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
        TestRuleType contentCreate = this.createTestRuleType(ON_CONTENT_CREATE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)contentCreate.rulesTriggered);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("some content");
        RuleTriggerTest.assertTrue((boolean)contentCreate.rulesTriggered);
    }

    public void testOnContentUpdateTrigger() {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT).getChildRef();
        TestRuleType contentUpdate = this.createTestRuleType(ON_CONTENT_UPDATE_TRIGGER);
        RuleTriggerTest.assertFalse((boolean)contentUpdate.rulesTriggered);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent("some content");
        RuleTriggerTest.assertFalse((boolean)contentUpdate.rulesTriggered);
        ContentWriter contentWriter2 = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.setMimetype("text/plain");
        contentWriter2.setEncoding("UTF-8");
        contentWriter2.putContent("more content some content");
        RuleTriggerTest.assertTrue((boolean)contentUpdate.rulesTriggered);
    }

    private TestRuleType createTestRuleType(String ruleTriggerName) {
        RuleTrigger ruleTrigger = (RuleTrigger)this.applicationContext.getBean(ruleTriggerName);
        RuleTriggerTest.assertNotNull((Object)ruleTrigger);
        TestRuleType ruleType = new TestRuleType();
        ruleTrigger.registerRuleType(ruleType);
        return ruleType;
    }

    private class TestRuleType
    implements RuleType {
        public boolean rulesTriggered = false;

        private TestRuleType() {
        }

        public String getName() {
            return "testRuleType";
        }

        public String getDisplayLabel() {
            return "displayLabel";
        }

        public void triggerRuleType(NodeRef nodeRef, NodeRef actionedUponNodeRef) {
            this.rulesTriggered = true;
        }
    }
}

