/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleChildAssocRefPolicyRuleTrigger
extends RuleTriggerAbstractBase {
    private static final String ERR_POLICY_NAME_NOT_SET = "Unable to register rule trigger since policy name has not been set.";
    private static Log logger = LogFactory.getLog(SingleChildAssocRefPolicyRuleTrigger.class);
    private String policyNamespace = "http://www.alfresco.org";
    private String policyName;
    private boolean isClassBehaviour = false;

    public void setPolicyNamespace(String policyNamespace) {
        this.policyNamespace = policyNamespace;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void registerRuleTrigger() {
        if (this.policyName == null) {
            throw new RuleServiceException(ERR_POLICY_NAME_NOT_SET);
        }
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName(this.policyNamespace, this.policyName), this, (Behaviour)new JavaBehaviour(this, "policyBehaviour"));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName(this.policyNamespace, this.policyName), this, (Behaviour)new JavaBehaviour(this, "policyBehaviour"));
        }
    }

    public void policyBehaviour(ChildAssociationRef childAssocRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Single child assoc trigger (policy = " + this.policyName + ") fired for parent node " + childAssocRef.getParentRef() + " and child node " + childAssocRef.getChildRef()));
        }
        this.triggerRules(childAssocRef.getParentRef(), childAssocRef.getChildRef());
    }
}

